ServerEvents.commandRegistry(event => {
	const { commands: Commands, arguments: Arguments } = event

	event.register(
		Commands.literal("setproperty_int")
        .requires(src => src.hasPermission(2))
        .then(Commands.argument('player', Arguments.PLAYER.create(event))
            .then(Commands.argument('property', Arguments.STRING.create(event))
                .then(Commands.argument('value', Arguments.INTEGER.create(event))
                    .executes(ctx => setPropInt(ctx))
                )
            )
        )
	)

	event.register(
		Commands.literal("getproperty")
        .requires(src => src.hasPermission(2))
        .then(Commands.argument('player', Arguments.PLAYER.create(event))
            .then(Commands.argument('property', Arguments.STRING.create(event))
                .executes(ctx => getPropInt(ctx))
            )
        )
	)

	event.register(
		Commands.literal("speedcolor")
        .requires(src => src.hasPermission(2))
        .then(Commands.argument('value', Arguments.INTEGER.create(event))
            .executes(ctx => setSpeedColor(ctx))
        )
	)

	event.register(
		Commands.literal("vibecolor")
        .requires(src => src.hasPermission(2))
        .then(Commands.argument('value', Arguments.INTEGER.create(event))
            .executes(ctx => setVibeColor(ctx))
        )
	)

	event.register(
		Commands.literal("magiccolor")
        .requires(src => src.hasPermission(2))
        .then(Commands.argument('value', Arguments.INTEGER.create(event))
            .executes(ctx => setMagicColor(ctx))
        )
	)

	event.register(
		Commands.literal("setspeed")
        .requires(src => src.hasPermission(2))
        .then(Commands.argument('value', Arguments.INTEGER.create(event))
            .executes(ctx => setMaxSpeed(ctx))
        )
	)

	event.register(
		Commands.literal("getspeedlevels")
        .requires(src => src.hasPermission(2))
        .executes(ctx => getSpeedLevels(ctx))
	)

    let setPropInt = (ctx) => {
        let player = Arguments.PLAYER.getResult(ctx, 'player')
        let property = Arguments.STRING.getResult(ctx, 'property')
        let value = Arguments.INTEGER.getResult(ctx, 'value')
    
        palladium.setProperty(player, property, value);
        // return 0 if fail
        return 1
    }

    let getPropInt = (ctx) => {
        let player = Arguments.PLAYER.getResult(ctx, 'player')
        let property = Arguments.STRING.getResult(ctx, 'property')
    
        player.tell(
            palladium.getProperty(player, property)
        )
        // return 0 if fail
        return 1
    }

    let setSpeedColor = (ctx) => {
        let val = Arguments.INTEGER.getResult(ctx, 'value')
    
        palladium.setProperty(ctx.source.player, 'arrzenhanced.speedColor', val)
        palladium.setProperty(ctx.source.player, 'arrzenhanced.oldSpeedColor', val)
        return 1
    }

    let setVibeColor = (ctx) => {
        let val = Arguments.INTEGER.getResult(ctx, 'value')
    
        palladium.setProperty(ctx.source.player, 'arrzenhanced.warpwave.color', val)
        palladium.setProperty(ctx.source.player, 'arrzenhanced.warpwave.colorold', val)
        return 1
    }

    let setMagicColor = (ctx) => {
        let val = Arguments.INTEGER.getResult(ctx, 'value')
    
        palladium.setProperty(ctx.source.player, 'arrzenhanced.magic.color', val)
        return 1
    }

    let setMaxSpeed = (ctx) => {
        let val = Arguments.INTEGER.getResult(ctx, 'value')
        let maxSpeed = palladium.getProperty(ctx.source.player, 'arrzenhanced.maxSpeed')
        let tachSpeed = palladium.getProperty(ctx.source.player, 'arrzenhanced.tachyonBoost')
        let veloSpeed = palladium.getProperty(ctx.source.player, 'arrzenhanced.velocityBoost')

        let realSpeed = maxSpeed - (tachSpeed + veloSpeed)
        let speedBoosts = (tachSpeed + veloSpeed)
        let newSpeed = val + speedBoosts

        if (tachSpeed == 0) {
            ctx.source.player.tell(`Base speed set to ${val}`)
        } else {
            ctx.source.player.tell(`Base speed set to ${val} (Max speed ${newSpeed})`)
        }
    
        palladium.setProperty(ctx.source.player, 'arrzenhanced.maxSpeed', newSpeed)

        let expBaseline = 500
        palladium.setProperty(ctx.source.player, 'arrzenhanced.speedExp', (expBaseline * (2 ** val)) + 1)
        return 1
    }

    let getSpeedLevels = (ctx) => {
        let maxSpeed = palladium.getProperty(ctx.source.player, 'arrzenhanced.maxSpeed')
        let tachSpeed = palladium.getProperty(ctx.source.player, 'arrzenhanced.tachyonBoost')
        let veloSpeed = palladium.getProperty(ctx.source.player, 'arrzenhanced.velocityBoost')
        let speedExp = palladium.getProperty(ctx.source.player, 'arrzenhanced.speedExp')

        let realSpeed = maxSpeed - (tachSpeed + veloSpeed)

        ctx.source.player.tell(`Max Levels: ${maxSpeed}`)
        ctx.source.player.tell(`Real Speed Levels: ${realSpeed}`) // not calculated the same universally
        ctx.source.player.tell(`Tachyon Levels: ${tachSpeed}`)
        ctx.source.player.tell(`Velocity Levels: ${veloSpeed}`)
        ctx.source.player.tell(`Speed Experience: ${speedExp}`)

        return 1
    }
})

