const BIFROST_X = 'bifrost_x';
const BIFROST_Y = 'bifrost_y';
const BIFROST_Z = 'bifrost_z';
const BIFROST_DIM = 'bifrost_dim';

const ACE_FIRST_CARD = 'arrzenhanced.ace.first_card';
const ACE_SECOND_CARD = 'arrzenhanced.ace.second_card';
const ACE_THIRD_CARD = 'arrzenhanced.ace.third_card';
const ACE_FOURTH_CARD = 'arrzenhanced.ace.fourth_card';
const ACE_FIFTH_CARD = 'arrzenhanced.ace.fifth_card';

const SIZE_MANIP_SCALE = 'arrzenhanced.size';

const STORMBREAKER_LEASH = 50

var BlockPos = Java.loadClass('net.minecraft.core.BlockPos');

PalladiumEvents.registerProperties((event) => {
    if (event.getEntityType() === "minecraft:player") {
        event.registerProperty(BIFROST_X, 'integer', 0);
        event.registerProperty(BIFROST_Y, 'integer', -255);
        event.registerProperty(BIFROST_Z, 'integer', 0);
        event.registerProperty(BIFROST_DIM, 'string', 'minecraft:overworld');
        
        event.registerProperty(ACE_FIRST_CARD, 'string', 'empty');
        event.registerProperty(ACE_SECOND_CARD, 'string', 'empty');
        event.registerProperty(ACE_THIRD_CARD, 'string', 'empty');
        event.registerProperty(ACE_FOURTH_CARD, 'string', 'empty');
        event.registerProperty(ACE_FIFTH_CARD, 'string', 'empty');

        event.registerProperty(SIZE_MANIP_SCALE, 'float', 0);
    }
});

ItemEvents.rightClicked('arrzenhanced:stormbreaker', (event) => {
    let player = event.player
    
    // player.tell("stormin my breaker")
    if (player.mainHandItem.id !== "arrzenhanced:stormbreaker") return
    
    let powers = abilityUtil.getEntries(player, "hertz:asgardian_ascend")
    if (powers.length > 0) {
        let lookAngle = player.getLookAngle().scale(STORMBREAKER_LEASH)
        let playerLocation = Vec3d(
            player.getX(),
            player.getY(),
            player.getZ()
        )
        let targetLocation = Vec3d(
            (playerLocation.x() + lookAngle.x()),
            (playerLocation.y() + lookAngle.y()),
            (playerLocation.z() + lookAngle.z())
        )

        // player.tell(`coords: ${targetLocation.x()}, ${targetLocation.y()}, ${targetLocation.z()}`)

        let stormbreakerHolder = player.getLevel().createEntity("minecraft:armor_stand");
        stormbreakerHolder.setItemSlot(
            5, // helmet
            Item.of(
                event.player.getMainHandItem().id,
                event.player.getMainHandItem().count,
                event.player.getMainHandItem().nbt
            )
        );
        let tagname = "Stormbreaker" + player.name.getString()
        stormbreakerHolder.setNbt({Invisible:true, Marker:true});
        stormbreakerHolder.tags.add(tagname)

        let otherLookAngle = player.getLookAngle().scale(1.5) // 1.5 blocks in front of them
        let spawnStandLoc = Vec3d(
            (playerLocation.x() + otherLookAngle.x()),
            (playerLocation.y() + otherLookAngle.y()),
            (playerLocation.z() + otherLookAngle.z())
        )

        stormbreakerHolder.setPosition(spawnStandLoc.x(), spawnStandLoc.y(), spawnStandLoc.z());
        stormbreakerHolder.spawn();
        event.player.mainHandItem.count = 0
        
        flyingAxes[stormbreakerHolder.id] = targetLocation
    }
})

var flyingAxes = {}
var reachedTargetAxes = {}
var soundtracker = {}

PlayerEvents.tick((event) => {
    let player = event.player
    let tagname = 'Stormbreaker' + player.name.getString()
    // event.player.tell(tagname)
    let powers = abilityUtil.getEntries(player, "hertz:asgardian_ascend")
    if (powers.length > 0) {
        player.getLevel().getEntities().forEach((entity) => {
            if (entity.type != 'minecraft:armor_stand') return
            if (!entity.tags.contains(tagname)) return
            entity.setRotation(entity.getRotationVector().y + 40, 0)
            // player.tell(entity.id)
            if (flyingAxes[entity.id] == undefined) {
                // player.tell("nowhere to go!")

                var inven = entity.getAllSlots()
                inven.forEach((item) => {
                    if (item.isEmpty()) return
                    /*
                    let ourItem = player.getLevel().createEntity('minecraft:item')
                    ourItem.item = Item.of(item.id, item.count, item.nbt)
                    ourItem.setPosition(
                        player.getX(),
                        player.getY(),
                        player.getZ()
                    )
                    ourItem.spawn()
                    */
                    event.server.runCommandSilent(`stopsound @a * arrzenhanced:stormbreakerthrowloop`)
                    player.give(Item.of(item.id, item.count, item.nbt))
                    delete soundtracker[entity.id]
                    delete reachedTargetAxes[entity.id]
                    delete flyingAxes[entity.id]
                })

                entity.kill()
            } else {
                if (!soundtracker[entity.id]) {
                    soundtracker[entity.id] = 1
                    var px = entity.getX();
                    var py = entity.getY();
                    var pz = entity.getZ();
                    // let blockPos = new BlockPos(px, py, pz)
                    event.server.runCommandSilent(`playsound arrzenhanced:stormbreakerthrowloop master @a ${px} ${py} ${pz} 1 1`)
                    // entity.getLevel().playSound(player, blockPos.pos, "arrzenhanced:stormbreakerthrowloop", "master", 0.5, 1)
                } else {soundtracker[entity.id] += 1}
                let targetPos = flyingAxes[entity.id]
                let dirToTarget = {
                    x: targetPos.x() - entity.getX(),
                    y: targetPos.y() - entity.getY(),
                    z: targetPos.z() - entity.getZ()
                };
                let distance = Math.sqrt(
                    dirToTarget.x * dirToTarget.x +
                    dirToTarget.y * dirToTarget.y +
                    dirToTarget.z * dirToTarget.z
                );

                // Check if the entity has reached its target (within 0.25 blocks)
                // player.tell(distance)
                if (reachedTargetAxes[entity.id]) {
                    flyingAxes[entity.id] = Vec3d(
                        player.getX(),
                        player.getY(),
                        player.getZ()
                    )
                }

                if (distance <= 0.8) {
                    // Update the target to the player's current position
                    if (reachedTargetAxes[entity.id] == undefined) {
                        reachedTargetAxes[entity.id] = true
                    } else {
                        // drop the weapon
                        var inven = entity.getAllSlots()
                        inven.forEach((item) => {
                            if (item.isEmpty()) return
                            /*
                            let ourItem = entity.getLevel().createEntity('minecraft:item')
                            ourItem.item = Item.of(item.id, item.count, item.nbt)
                            ourItem.setPosition(
                                entity.getX(),
                                entity.getY(),
                                entity.getZ()
                            )
                            ourItem.spawn()
                            */
                            player.give(Item.of(item.id, item.count, item.nbt))
                        })
                        event.server.runCommandSilent(`stopsound @a * arrzenhanced:stormbreakerthrowloop`)
                        entity.kill()
                        delete soundtracker[entity.id]
                        delete reachedTargetAxes[entity.id]
                        delete flyingAxes[entity.id]
                    }
                    
                    flyingAxes[entity.id] = Vec3d(
                        player.getX(),
                        player.getY(),
                        player.getZ()
                    )
                    let targetPos = flyingAxes[entity.id]

                    dirToTarget = {
                        x: targetPos.x() - entity.getX(),
                        y: targetPos.y() - entity.getY(),
                        z: targetPos.z() - entity.getZ()
                    };
                    distance = Math.sqrt(
                        dirToTarget.x * dirToTarget.x +
                        dirToTarget.y * dirToTarget.y +
                        dirToTarget.z * dirToTarget.z
                    );
                }

                // Check if the entity collides with a block
                let block = player.getLevel().getBlock(
                    Math.floor(entity.getX()),
                    Math.floor(entity.getY()+1),
                    Math.floor(entity.getZ())
                )
                if (
                    !(
                        block == 'minecraft:air' ||
                        block == 'minecraft:water' ||
                        block == 'minecraft:lava'
                    )
                ) {
                    // Update the target to the player's current position
                    if (reachedTargetAxes[entity.id] == undefined) {
                        reachedTargetAxes[entity.id] = true
                    }
                }


                if (distance > 0.01) {
                    // Normalize the direction vector
                    dirToTarget.x /= distance;
                    dirToTarget.y /= distance;
                    dirToTarget.z /= distance;
    
                    // Move the entity by 0.25 blocks in the direction of the target
                    // let speed = 0.8;
                    let speed = 1.2;
                    entity.teleportTo(
                        entity.x + dirToTarget.x * speed,
                        entity.y + dirToTarget.y * speed,
                        entity.z + dirToTarget.z * speed
                    );
                }

                // deal damage to nearby entities
                entity.getLevel().getEntitiesWithin(AABB.of(
                    entity.getX()+1,
                    entity.getY()+2,
                    entity.getZ()+1,
                    entity.getX()-1,
                    entity.getY()+1,
                    entity.getZ()-1,
                )).forEach((target) => {
                    if (target == event.player) return;
                    if (target.type == 'minecraft:item') return;
                    target.attack(6)
                })
                //120 v1
                //24 v2
                //16 v3
                if (soundtracker[entity.id] % 120 == 0) {
                    event.server.runCommandSilent(`stopsound @a * arrzenhanced:stormbreakerthrowloop`)
                    var px = entity.getX();
                    var py = entity.getY();
                    var pz = entity.getZ();
                    // let blockPos = new BlockPos(px, py, pz)
                    // entity.getLevel().playSound(player, px, py, pz, "arrzenhanced:stormbreakerthrowloop", "master", 0.5, 1)
                    event.server.runCommandSilent(`playsound arrzenhanced:stormbreakerthrowloop master @a ${px} ${py} ${pz} 1 1`)
                }
            }
        })
    }
})

/*
ServerEvents.tick((event) => {
    //
})
*/