var BuiltInRegistries = Java.loadClass("net.minecraft.core.registries.BuiltInRegistries")

EntityEvents.hurt(event => {
    var { entity, source } = event
    let attackingEntity = source.player
    //
    if (entity.type == "minecraft:player") {
        let allPowers = palladium.powers.getPowerIdsForNamespace(entity, 'arrzenhanced'),
        hasPowers = false,
        metConditions = false,
        ignorePowers = ['arrzenhanced:concussed', 'arrzenhanced:incognito', 'arrzenhanced:shocked']
        allPowers.forEach(power => {
            if (palladium.superpowers.hasSuperpower(entity, power) == true && !ignorePowers.includes(power.toString())) {hasPowers = true}
        })
        if (source.type().msgId() == 'lightningBolt') { // struck by lightning
            if (
                (entity.mainHandItem.id == "minecraft:redstone_lamp" && entity.offHandItem.id == "minecraft:daylight_detector") ||
                (entity.offHandItem.id == "minecraft:redstone_lamp" && entity.mainHandItem.id == "minecraft:daylight_detector")
            ) {
                metConditions = true
            }
            
            if (metConditions && !hasPowers) {
                entity.potionEffects.add('minecraft:blindness', 3*20, 100, false, false)
                entity.potionEffects.add('minecraft:weakness', 3*20, 100, false, false)
                palladium.superpowers.addSuperpower(entity, "arrzenhanced:electricity_conduction")
            }
        }
    }
})