BlockEvents.broken('dampened:dampening_block', event => {
    var {entity} = event
    if (entity.type == "minecraft:player") {
        let allPowers = palladium.powers.getPowerIdsForNamespace(entity, 'arrzenhanced'),
        hasPowers = false,
        ignorePowers = ['arrzenhanced:concussed', 'arrzenhanced:incognito', 'arrzenhanced:shocked']
        allPowers.forEach(power => {
            if (palladium.superpowers.hasSuperpower(entity, power) == true && !ignorePowers.includes(power.toString())) {hasPowers = true}
        })
        if (
            (entity.mainHandItem.id == "arrzenhanced:deadzone_dagger" ||
            entity.offHandItem.id == "arrzenhanced:deadzone_dagger") && !hasPowers) {
            entity.getLevel().spawnParticles("minecraft:firework", true, entity.getX(), entity.getY()+1.5, entity.getZ(), 0, 0, 0, 200, 0.1);
            entity.potionEffects.add('minecraft:blindness', 10*20, 100, false, false)
            entity.potionEffects.add('minecraft:weakness', 10*20, 100, false, false)
            palladium.superpowers.addSuperpower(entity, "arrzenhanced:power_negation")
            
            if (entity.mainHandItem.id == "arrzenhanced:deadzone_dagger") {
                entity.mainHandItem.setNbt({CustomModelData:1, Unbreakable:true})
            }
            if (entity.offHandItem.id == "arrzenhanced:deadzone_dagger") {
                entity.offHandItem.setNbt({CustomModelData:1, Unbreakable:true})
            }
        }
    }
})