var BuiltInRegistries = Java.loadClass("net.minecraft.core.registries.BuiltInRegistries")

EntityEvents.hurt(event => {
    var { entity, source } = event
    let attackingEntity = source.player
    //
    if (entity.type == "minecraft:player") {
        let allPowers = palladium.powers.getPowerIdsForNamespace(entity, 'arrzenhanced'),
        hasPowers = false,
        metConditions = false,
        ignorePowers = ['arrzenhanced:concussed', 'arrzenhanced:incognito', 'arrzenhanced:shocked']
        allPowers.forEach(power => {
            if (palladium.superpowers.hasSuperpower(entity, power) == true && !ignorePowers.includes(power.toString())) {hasPowers = true}
        })
        if (source.type().msgId().includes('explosion')) { // exploded
            if (
                (entity.mainHandItem.id == "arrzenhanced:fatherbox") ||
                (entity.offHandItem.id == "arrzenhanced:fatherbox")
            ) {
                metConditions = true
            }
            
            if (metConditions && !hasPowers) {
                entity.potionEffects.add('minecraft:blindness', 3*20, 100, false, false)
                entity.potionEffects.add('minecraft:weakness', 3*20, 100, false, false)
                if (entity.mainHandItem.id == "arrzenhanced:fatherbox") {
                    entity.mainHandItem.count--
                }
                if (entity.offHandItem.id == "arrzenhanced:fatherbox") {
                    entity.offHandItem.count--
                }
                palladium.superpowers.addSuperpower(entity, "arrzenhanced:warpwave_manipulation")
                palladium.setProperty(entity, 'arrzenhanced.warpwave.color', 0)
                palladium.setProperty(entity, 'arrzenhanced.warpwave.color.old', 0)
            }
        }
    }
})