ServerEvents.recipes(event => {
    event.shaped(
        Item.of(`arrzenhanced:empty_injector`, 1),
        [
            " A ",
            " B ",
            " C "
        ],
        {
            A: 'minecraft:piston',
            B: '#forge:ingots/titanium',
            C: 'minecraft:iron_nugget'
        }
    )
    event.shaped(
        Item.of(`arrzenhanced:witherbone_alloy`, 1),
        [
            "ABA",
            "ACA",
            "ADA"
        ],
        {
            A: 'minecraft:bone',
            B: 'minecraft:wither_skeleton_skull',
            C: '#forge:ingots/titanium',
            D: 'minecraft:lava_bucket'
        }
    )
    event.shaped(
        Item.of(`arrzenhanced:liquid_witherbone_alloy`, 1),
        [
            "   ",
            " B ",
            " A "
        ],
        {
            A: 'minecraft:lava_bucket',
            B: 'arrzenhanced:witherbone_alloy'
        }
    )
    event.shapeless(
        Item.of(`arrzenhanced:witherbone_alloy_injector`, 1),
        [
            'arrzenhanced:liquid_witherbone_alloy',
            'arrzenhanced:empty_injector'
        ]
    )
    event.shapeless(
        Item.of(`arrzenhanced:compound_v_injector`, 1),
        [
            'arrzenhanced:compound_v',
            'arrzenhanced:empty_injector'
        ]
    )
    event.shapeless(
        Item.of(`arrzenhanced:dna_normalizer`, 1),
        [
            'arrzenhanced:stabilizing_serum',
            'arrzenhanced:empty_injector'
        ]
    )
    event.shapeless(
        Item.of(`arrzenhanced:velocity_injector`, 1, {level: 0}),
        [
            'arrzenhanced:velocity_serum',
            'arrzenhanced:empty_injector'
        ]
    ).modifyResult((grid, result) => {
        var serum = grid.get(4); // fallback
        for (var z = 0; z < 9; z++) {
            serum = grid.get(z);
            if (serum?.nbt?.level != undefined) { break; }
        }
        return xferNBT(serum, result)
    })
});