var $ResourceKey_ = Java.loadClass("net.minecraft.resources.ResourceKey");
var DAMAGE_TYPE_KEY = $ResourceKey_.createRegistryKey("damage_type");

function getDamageSourceBothSides(
    /** @type {Internal.Level}*/ level,
    /** @type {Internal.DamageType_}*/ damageType,
    /** @type {Internal.LivingEntity}*/ destEntity,
    /** @type {Internal.LivingEntity}*/ sourceEntity
    ) {
    var resourceKey = $ResourceKey_.create(DAMAGE_TYPE_KEY, Utils.id(damageType));
    var holder = level.registryAccess().registryOrThrow(DAMAGE_TYPE_KEY).getHolderOrThrow(resourceKey);
    var damagesourceholder = holder;
    return new DamageSource(damagesourceholder, sourceEntity, destEntity);
}

EntityEvents.hurt(event => {
    var source = event.source.actual;
    var target = event.entity;
    var arrow = event.getSource().getImmediate()
    // console.log(arrow)

    if (!arrow || arrow.type != 'palladium:custom_projectile') {return}
    if (target.isPlayer()) {
        if (target.isCreative()) {return}
    }
    if (arrow.tags.contains('arrz.dampening_pellet')) {
        if (!target?.potionEffects) return
        target.potionEffects.add('dampened:genetic', 15 * 20, 0, false, false)
    }
})