EntityEvents.hurt(event => {
    var source = event.source.actual;
    var target = event.entity;

    // Ensure the source is an entity (not a block, projectile, etc.)
    if (!source || !source.isLiving() || !target || !target.isLiving()) return;

    palladium.abilities.getEntries(source, 'arrzenhanced:effect_punch').forEach(ability => {
        if (!ability.isEnabled()) return
        if (!event.source.type().msgId().includes('player')) return
        var effect = ability.getPropertyByName('effect')
        var strength = Number(ability.getPropertyByName('strength'))
        var length = Number(ability.getPropertyByName('length'))
        
        if (!target?.potionEffects) return
        target.potionEffects.add(effect, length * 20, strength, false, false)
    })
})