EntityEvents.hurt(event => {
    var source = event.source.actual;
    var target = event.entity;

    // Ensure the source is an entity (not a block, projectile, etc.)
    // if (!source || !source.isLiving() || !target || !target.isLiving()) return;
    if (target.type != 'minecraft:player') return;
    palladium.abilities.getEntries(target, 'arrzenhanced:telekinesis').forEach(ability => {
        if (!ability.isEnabled()) return
        if (!ability.isUnlocked()) return
        if (ability.isOnCooldown()) return
        if (target.invulnerableTime > 10) {return}
        var failChance = Number(ability.getPropertyByName('fail_chance'))
        var roll = Math.random()

        if (roll < failChance) {
            // event.server.runCommand(`say Concentration broken`)
            target.getLevel().playSound(null, target.getX(), target.getY(), target.getZ(), 'minecraft:block.beacon.deactivate', 'master', 1, 1)
            ability.startCooldown(target, 10 * 20)
            ability.syncState(target)
        }
    })
});
