/*
 * Decompiled with CFR 0.152.
 */
package com.sakuraryoko.afkplus.player;

import com.sakuraryoko.afkplus.AfkPlus;
import com.sakuraryoko.afkplus.api.AfkPlusEvents;
import com.sakuraryoko.afkplus.compat.morecolors.TextHandler;
import com.sakuraryoko.afkplus.config.ConfigWrap;
import com.sakuraryoko.afkplus.player.AfkPlayer;
import com.sakuraryoko.afkplus.player.interfaces.IPlayerInvoker;
import com.sakuraryoko.corelib.api.log.AnsiLogger;
import eu.pb4.placeholders.api.PlaceholderContext;
import eu.pb4.placeholders.api.Placeholders;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.lucko.fabric.api.permissions.v0.Permissions;
import net.minecraft.class_1297;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2703;
import net.minecraft.class_3222;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public class AfkHandler {
    private static final AnsiLogger LOGGER = new AnsiLogger(AfkHandler.class, true);
    private AfkPlayer player;

    public AfkHandler(@Nonnull AfkPlayer afkPlayer) {
        this.player = afkPlayer;
    }

    @ApiStatus.Internal
    public void registerAfk(@Nullable String reason) {
        if (this.player.isAfk()) {
            return;
        }
        this.player.setAfkTimeMs(class_156.method_658());
        if (reason == null && ConfigWrap.mess().defaultReason == null) {
            this.player.setAfkReason("<red>none");
        } else if (reason == null || reason.isEmpty()) {
            this.player.setAfkReason("<red>none");
            class_2561 mess = Placeholders.parseText((class_2561)TextHandler.getInstance().formatTextSafe(ConfigWrap.mess().whenAfk), (PlaceholderContext)PlaceholderContext.of((class_3222)this.player.getPlayer()));
            this.sendAfkMessage(mess);
        } else {
            this.player.setAfkReason(reason);
            String mess1 = ConfigWrap.mess().whenAfk + ConfigWrap.mess().whenAfkPunctuation + reason;
            class_2561 mess2 = Placeholders.parseText((class_2561)TextHandler.getInstance().formatTextSafe(mess1), (PlaceholderContext)PlaceholderContext.of((class_3222)this.player.getPlayer()));
            this.sendAfkMessage(mess2);
        }
        ((AfkPlusEvents.AfkEvent)AfkPlusEvents.AFK_EVENT.invoker()).onAfk(this.invoker().afkplus$player(), Placeholders.parseText((class_2561)TextHandler.getInstance().formatTextSafe(this.player.getAfkReason()), (PlaceholderContext)PlaceholderContext.of((class_3222)this.player.getPlayer())));
        if (ConfigWrap.dmg().disableDamage && ConfigWrap.dmg().disableDamageCooldown < 1) {
            this.disableDamage();
        }
        this.updatePlayerList();
        this.player.setAfk(true);
    }

    @ApiStatus.Internal
    public void unregisterAfkSilently() {
        ((AfkPlusEvents.AfkReturnEvent)AfkPlusEvents.AFK_RETURN_EVENT.invoker()).onReturn(this.invoker().afkplus$player(), class_156.method_658() - this.player.getAfkTimeMs());
        this.player.setAfk(false);
        this.player.setAfkTimeMs(0L);
        this.player.setAfkReason("");
    }

    @ApiStatus.Internal
    public void unregisterAfk() {
        if (!this.player.isAfk()) {
            this.player.setAfk(false);
            this.player.setAfkTimeMs(0L);
            this.player.setAfkReason("");
            return;
        }
        long duration = class_156.method_658() - this.player.getAfkTimeMs();
        if (ConfigWrap.mess().displayDuration) {
            String ret = ConfigWrap.mess().whenReturn + ConfigWrap.mess().whenReturnDurationPrefix + this.player.getAfkDurationString() + ConfigWrap.mess().whenReturnDurationSuffix + "<r>";
            class_2561 mess1 = TextHandler.getInstance().formatTextSafe(ret);
            class_2561 mess2 = Placeholders.parseText((class_2561)mess1, (PlaceholderContext)PlaceholderContext.of((class_3222)this.player.getPlayer()));
            this.sendAfkMessage(mess2);
        } else {
            String ret = ConfigWrap.mess().whenReturn + "<r>";
            class_2561 mess1 = TextHandler.getInstance().formatTextSafe(ret);
            class_2561 mess2 = Placeholders.parseText((class_2561)mess1, (PlaceholderContext)PlaceholderContext.of((class_3222)this.player.getPlayer()));
            this.sendAfkMessage(mess2);
        }
        ((AfkPlusEvents.AfkReturnEvent)AfkPlusEvents.AFK_RETURN_EVENT.invoker()).onReturn(this.invoker().afkplus$player(), duration);
        this.player.setAfk(false);
        this.player.setAfkTimeMs(0L);
        this.player.setAfkReason("");
        if (!this.player.isDamageEnabled()) {
            this.enableDamage();
        }
        this.updatePlayerList();
    }

    @ApiStatus.Internal
    public void enableDamage() {
        AfkPlus.debugLog("enableDamage() has been invoked for: {}", this.player.getName());
        if (this.player.getPlayer().method_7337() || this.player.getPlayer().method_7325()) {
            return;
        }
        if (!this.player.isDamageEnabled()) {
            this.player.setDamageEnabled(true);
            if (this.invoker().afkplus$player().method_5655()) {
                this.toggleInvulnerable(false);
                AfkPlus.LOGGER.info("Damage Enabled for player: {}", (Object)this.player.getName());
            }
            if (!ConfigWrap.dmg().whenDamageEnabled.isEmpty()) {
                class_2561 mess1 = TextHandler.getInstance().formatTextSafe(ConfigWrap.dmg().whenDamageEnabled);
                class_2561 mess2 = Placeholders.parseText((class_2561)mess1, (PlaceholderContext)PlaceholderContext.of((class_3222)this.player.getPlayer()));
                this.sendAfkMessage(mess2);
            }
            ((AfkPlusEvents.AfkEnableDamageEvent)AfkPlusEvents.AFK_ENABLE_DAMAGE_EVENT.invoker()).onDamageEnabled(this.invoker().afkplus$player());
        }
        this.updatePlayerList();
    }

    @ApiStatus.Internal
    public void disableDamage() {
        AfkPlus.debugLog("disableDamage() has been invoked for: {}", this.player.getName());
        if (this.player.getPlayer().method_7337() || this.player.getPlayer().method_7325() || !ConfigWrap.dmg().disableDamage) {
            return;
        }
        if (this.player.isLockDamageEnabled()) {
            AfkPlus.LOGGER.info("Disable Damage is locked from player: {}", (Object)this.player.getName());
            return;
        }
        if (this.player.isAfk()) {
            if (this.player.isDamageEnabled()) {
                this.player.setDamageEnabled(false);
                if (!this.invoker().afkplus$player().method_5655()) {
                    this.toggleInvulnerable(true);
                    AfkPlus.LOGGER.info("Damage Disabled for player: {}", (Object)this.player.getName());
                }
                if (!ConfigWrap.dmg().whenDamageDisabled.isEmpty()) {
                    class_2561 mess1 = TextHandler.getInstance().formatTextSafe(ConfigWrap.dmg().whenDamageDisabled);
                    class_2561 mess2 = Placeholders.parseText((class_2561)mess1, (PlaceholderContext)PlaceholderContext.of((class_3222)this.player.getPlayer()));
                    this.sendAfkMessage(mess2);
                }
                ((AfkPlusEvents.AfkDisableDamageEvent)AfkPlusEvents.AFK_DISABLE_DAMAGE_EVENT.invoker()).onDamageDisabled(this.invoker().afkplus$player());
            }
            this.updatePlayerList();
        }
    }

    @ApiStatus.Internal
    public void lockDamageEnabled() {
        this.player.setLockDamageEnabled(true);
        if (!this.player.isDamageEnabled()) {
            this.enableDamage();
        }
    }

    @ApiStatus.Internal
    public void unlockDamageEnabled() {
        this.player.setLockDamageEnabled(false);
        this.player.tickPlayer(class_156.method_658());
    }

    @ApiStatus.Internal
    public void afkKick() {
        if (this.player.isAfk() && ConfigWrap.kick().afkKickEnabled) {
            if ((this.player.getPlayer().method_7337() || this.player.getPlayer().method_7325()) && !ConfigWrap.kick().afkKickNonSurvival || Permissions.check((class_1297)this.player.getPlayer(), (String)"afkplus.kick.safe", (int)ConfigWrap.kick().afkKickSafePermissions) || Permissions.check((class_1297)this.player.getPlayer(), (String)"afkplus.afkplus", (int)ConfigWrap.afk().afkPlusCommandPermissions)) {
                return;
            }
            Object kickMessageString = ConfigWrap.kick().whenKicked.isEmpty() ? "" : ConfigWrap.kick().whenKicked;
            AfkPlus.LOGGER.warn("Configured timeout has been reached for player {} --> removing from server.", (Object)this.player.getName());
            if (!ConfigWrap.kick().afkKickMessage.isEmpty()) {
                Object kickReasonString;
                if (ConfigWrap.mess().displayDuration) {
                    long afkDuration = class_156.method_658() - this.player.getPlayer().method_14219();
                    String durationString = this.player.getDurationType().format(afkDuration, ConfigWrap.mess().duration.customFormat);
                    kickReasonString = ConfigWrap.kick().afkKickMessage + "\n" + ConfigWrap.kick().whenKickedDurationNamedPrefix + durationString + ConfigWrap.kick().whenKickedDurationSuffix + "<r>";
                    if (!((String)kickMessageString).isEmpty()) {
                        kickMessageString = (String)kickMessageString + ConfigWrap.kick().whenKickedDurationDefaultPrefix + durationString + ConfigWrap.kick().whenKickedDurationSuffix + "<r>";
                    }
                } else {
                    kickReasonString = ConfigWrap.kick().afkKickMessage;
                }
                class_2561 kickReason = TextHandler.getInstance().formatTextSafe((String)kickReasonString);
                kickReason = Placeholders.parseText((class_2561)kickReason, (PlaceholderContext)PlaceholderContext.of((class_3222)this.player.getPlayer()));
                this.player.setAfk(false);
                this.player.setAfkTimeMs(0L);
                this.player.setAfkReason("");
                if (!this.player.isDamageEnabled()) {
                    this.enableDamage();
                }
                this.invoker().afkplus$connection().method_52396(kickReason);
                ((AfkPlusEvents.AfkRemovalKickEvent)AfkPlusEvents.AFK_REMOVAL_KICK_EVENT.invoker()).onPlayerKick(this.player.getPlayer(), kickReason);
                if (!((String)kickMessageString).isEmpty()) {
                    class_2561 kickMessage = TextHandler.getInstance().formatTextSafe((String)kickMessageString);
                    kickMessage = Placeholders.parseText((class_2561)kickMessage, (PlaceholderContext)PlaceholderContext.of((class_3222)this.player.getPlayer()));
                    this.sendAfkMessage(kickMessage);
                }
            } else {
                String kickReasonString = ConfigWrap.kick().whenKickedDefaultReason + "<r>";
                class_2561 kickReason = TextHandler.getInstance().formatTextSafe(kickReasonString);
                kickReason = Placeholders.parseText((class_2561)kickReason, (PlaceholderContext)PlaceholderContext.of((class_3222)this.player.getPlayer()));
                this.player.setAfk(false);
                this.player.setAfkTimeMs(0L);
                this.player.setAfkReason("");
                if (!this.player.isDamageEnabled()) {
                    this.enableDamage();
                }
                this.invoker().afkplus$connection().method_52396(kickReason);
                if (!((String)kickMessageString).isEmpty()) {
                    class_2561 kickMessage = TextHandler.getInstance().formatTextSafe((String)kickMessageString);
                    kickMessage = Placeholders.parseText((class_2561)kickMessage, (PlaceholderContext)PlaceholderContext.of((class_3222)this.player.getPlayer()));
                    this.sendAfkMessage(kickMessage);
                }
            }
        }
    }

    @ApiStatus.Internal
    public void updatePlayerList() {
        this.invoker().afkplus$server().method_3760().method_14581((class_2596)new class_2703(class_2703.class_5893.field_29139, this.player.getPlayer()));
        ((AfkPlusEvents.UpdatePlayerListEvent)AfkPlusEvents.UPDATE_PLAYER_LIST.invoker()).onPlayerListUpdate(this.player.getPlayer());
        AfkPlus.debugLog("updatePlayerList(): Sending player list update for {}", this.player.getName());
    }

    private void sendAfkMessage(class_2561 message) {
        if (!ConfigWrap.mess().enableMessages || message.getString().trim().isEmpty()) {
            return;
        }
        this.invoker().afkplus$server().method_43496(message);
        for (class_3222 player : this.invoker().afkplus$server().method_3760().method_14571()) {
            player.method_43496(message);
        }
    }

    private void toggleInvulnerable(boolean toggle) {
        this.invoker().afkplus$setInvulnerable(toggle);
    }

    @ApiStatus.Internal
    public void tickPlayer(@NotNull class_3222 player) {
        this.player = this.player.setPlayer(player);
        this.player.tickPlayer(class_156.method_658());
    }

    @ApiStatus.Internal
    public void reset() {
        if (this.invoker().afkplus$player().method_5655()) {
            this.toggleInvulnerable(false);
        }
    }

    private IPlayerInvoker invoker() {
        return (IPlayerInvoker)this.player.getPlayer();
    }
}

