/*
 * Decompiled with CFR 0.152.
 */
package com.sakuraryoko.afkplus.player;

import com.sakuraryoko.afkplus.AfkPlus;
import com.sakuraryoko.afkplus.compat.styledplayerlist.StyledPlayerListCompat;
import com.sakuraryoko.afkplus.compat.vanish.VanishAPICompat;
import com.sakuraryoko.afkplus.player.AfkPlayer;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.class_1297;
import net.minecraft.class_156;
import net.minecraft.class_3222;

public class AfkPlayerList {
    private static final AfkPlayerList INSTANCE = new AfkPlayerList();
    private final List<AfkPlayer> afkPlayers = new ArrayList<AfkPlayer>();

    public static AfkPlayerList getInstance() {
        return INSTANCE;
    }

    @Nullable
    public AfkPlayer getPlayer(@Nonnull class_3222 player) {
        for (AfkPlayer entry : this.afkPlayers) {
            if (!entry.matches(player)) continue;
            return entry;
        }
        return null;
    }

    public AfkPlayer addOrGetPlayer(@Nonnull class_3222 player) {
        AfkPlayer afkPlayer = this.getPlayer(player);
        if (afkPlayer == null) {
            afkPlayer = AfkPlayer.init(player);
            this.afkPlayers.add(afkPlayer);
            AfkPlus.debugLog("AfkPlayerList(): addOrGetPlayer({}) --> ADD", afkPlayer.getName());
        }
        return afkPlayer;
    }

    public List<class_3222> listAllAfk() {
        ArrayList<class_3222> list = new ArrayList<class_3222>();
        for (AfkPlayer entry : this.afkPlayers) {
            if (VanishAPICompat.isVanishedByEntity((class_1297)entry.getPlayer()) || !entry.isAfk() && !StyledPlayerListCompat.getInstance().hasStyledPlayerList()) continue;
            list.add(entry.getPlayer());
        }
        return list;
    }

    public void removePlayer(@Nonnull class_3222 player) {
        for (AfkPlayer entry : this.afkPlayers) {
            if (!entry.matches(player)) continue;
            AfkPlus.debugLog("AfkPlayerList(): removePlayer({}) --> REMOVE", entry.getName());
            entry.reset();
            this.afkPlayers.remove(entry);
            break;
        }
    }

    public void removeAllPlayers() {
        AfkPlus.debugLog("AfkPlayerList(): removeAllPlayers()", new Object[0]);
        for (AfkPlayer entry : this.afkPlayers) {
            entry.reset();
        }
        this.clear();
    }

    public void tickPlayers() {
        this.afkPlayers.forEach(afkPlayer -> afkPlayer.tickPlayer(class_156.method_658()));
    }

    public boolean tickEachByPlayer(@Nonnull class_3222 player) {
        AfkPlayer afkPlayer = this.getPlayer(player);
        if (afkPlayer != null) {
            afkPlayer.getHandler().tickPlayer(player);
            return true;
        }
        return false;
    }

    public void clear() {
        this.afkPlayers.clear();
    }
}

