/*
 * Decompiled with CFR 0.152.
 */
package com.sakuraryoko.afkplus.util;

import com.sakuraryoko.afkplus.AfkPlus;
import java.util.Collection;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.metadata.ModMetadata;

public class AfkPlusConflicts {
    public static boolean checkMods() {
        String modName;
        String modVer;
        ModMetadata modData;
        boolean modCheck = true;
        AfkPlus.debugLog("Checking for conflicting mods.", new Object[0]);
        String modTarget = "svrutil";
        if (FabricLoader.getInstance().isModLoaded(modTarget)) {
            modData = ((ModContainer)FabricLoader.getInstance().getModContainer(modTarget).get()).getMetadata();
            modVer = modData.getVersion().getFriendlyString();
            modName = modData.getName();
            AfkPlus.LOGGER.warn("{}-{} has been found, please verify that the /afk command is disabled under config/svrutil/commands.json.", (Object)modName, (Object)modVer);
            modCheck = false;
        }
        modTarget = "antilogout";
        if (FabricLoader.getInstance().isModLoaded(modTarget)) {
            modData = ((ModContainer)FabricLoader.getInstance().getModContainer(modTarget).get()).getMetadata();
            modVer = modData.getVersion().getFriendlyString();
            modName = modData.getName();
            AfkPlus.LOGGER.warn("{}-{} has been found, please remove this mod to avoid AFK timeout confusion.", (Object)modName, (Object)modVer);
            modCheck = false;
        }
        modTarget = "autoafk";
        if (FabricLoader.getInstance().isModLoaded(modTarget)) {
            modData = ((ModContainer)FabricLoader.getInstance().getModContainer(modTarget).get()).getMetadata();
            modVer = modData.getVersion().getFriendlyString();
            modName = modData.getName();
            AfkPlus.LOGGER.warn("{}-{} has been found, please remove this mod to avoid AFK timeout confusion.", (Object)modName, (Object)modVer);
            modCheck = false;
        }
        modTarget = "sessility";
        if (FabricLoader.getInstance().isModLoaded(modTarget)) {
            modData = ((ModContainer)FabricLoader.getInstance().getModContainer(modTarget).get()).getMetadata();
            modVer = modData.getVersion().getFriendlyString();
            modName = modData.getName();
            AfkPlus.LOGGER.warn("{}-{} has been found, please remove this mod to avoid AFK timeout confusion.", (Object)modName, (Object)modVer);
            modCheck = false;
        }
        modTarget = "playtime-tracker";
        if (FabricLoader.getInstance().isModLoaded(modTarget)) {
            modData = ((ModContainer)FabricLoader.getInstance().getModContainer(modTarget).get()).getMetadata();
            modVer = modData.getVersion().getFriendlyString();
            modName = modData.getName();
            AfkPlus.LOGGER.warn("{}-{} has been found, please remove this mod to avoid AFK timeout/player list confusion.", (Object)modName, (Object)modVer);
            modCheck = false;
        }
        modTarget = "afkdisplay";
        if (FabricLoader.getInstance().isModLoaded(modTarget)) {
            modData = ((ModContainer)FabricLoader.getInstance().getModContainer(modTarget).get()).getMetadata();
            modVer = modData.getVersion().getFriendlyString();
            modName = modData.getName();
            AfkPlus.LOGGER.warn("{}-{} has been found, please remove this mod to avoid AFK timeout/player list confusion.", (Object)modName, (Object)modVer);
            modCheck = false;
        }
        return modCheck;
    }

    public static boolean checkDatapacks(Collection<String> dpCollection) {
        boolean dpCheck = true;
        AfkPlus.debugLog("Data pack reload detected.  Checking for conflicting data packs.", new Object[0]);
        for (String dpString : dpCollection) {
            if (!dpString.contains("afk") && !dpString.contains("Afk") && !dpString.contains("AFK")) continue;
            AfkPlus.LOGGER.warn("Possible conflict found with data pack: {} -- please remove/disable it.", (Object)dpString);
            dpCheck = false;
        }
        return dpCheck;
    }
}

