/*
 * Decompiled with CFR 0.152.
 */
package com.sakuraryoko.afkplus.compat.styledplayerlist;

import com.sakuraryoko.afkplus.AfkPlus;
import com.sakuraryoko.afkplus.config.ConfigWrap;
import net.fabricmc.loader.api.FabricLoader;

public class StyledPlayerListCompat {
    private static final StyledPlayerListCompat INSTANCE = new StyledPlayerListCompat();
    private boolean hasStyledPlayerList = FabricLoader.getInstance().isModLoaded("styledplayerlist");

    public static StyledPlayerListCompat getInstance() {
        return INSTANCE;
    }

    public boolean hasStyledPlayerList() {
        return this.hasStyledPlayerList;
    }

    public void setStyledPlayerList(boolean toggle) {
        if (!this.hasStyledPlayerList && toggle) {
            this.handleStyledPlayerList();
        }
        this.hasStyledPlayerList = toggle;
    }

    public void handleStyledPlayerList() {
        if (this.hasStyledPlayerList()) {
            this.checkListConfig();
        }
    }

    private void checkListConfig() {
        if (this.hasStyledPlayerList()) {
            AfkPlus.debugLog("handleStyledPlayerList(): checking that List display config is enabled", new Object[0]);
            if (!ConfigWrap.list().enableListDisplay) {
                ConfigWrap.list().enableListDisplay = true;
            }
            if (ConfigWrap.list().updateInterval < 1 || ConfigWrap.list().updateInterval > 10) {
                ConfigWrap.list().updateInterval = 10;
            }
        }
    }
}

