/*
 * Decompiled with CFR 0.152.
 */
package com.sakuraryoko.afkplus.events;

import com.sakuraryoko.afkplus.AfkPlus;
import com.sakuraryoko.afkplus.util.AfkPlusConflicts;
import com.sakuraryoko.corelib.api.events.IServerEventsDispatch;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.class_1132;
import net.minecraft.class_1934;
import net.minecraft.class_3176;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class ServerEventsHandler
implements IServerEventsDispatch {
    private static final ServerEventsHandler INSTANCE = new ServerEventsHandler();
    private Collection<String> dpCollection = new ArrayList<String>();

    public static ServerEventsHandler getInstance() {
        return INSTANCE;
    }

    @ApiStatus.Internal
    public void onStarting(MinecraftServer server) {
        AfkPlus.debugLog("onStarting(): Server is starting, {}", server.getServerModName());
    }

    @ApiStatus.Internal
    public void onStarted(MinecraftServer server) {
        this.dpCollection = server.method_3836().method_29210();
        if (!AfkPlusConflicts.checkDatapacks(this.dpCollection)) {
            AfkPlus.LOGGER.warn("onStarted(): MOD Data Pack test has FAILED.");
        }
        AfkPlus.debugLog("onStarted(): Server has started, {}", server.getServerModName());
    }

    @ApiStatus.Internal
    public void onReloadComplete(MinecraftServer server, Collection<String> resources) {
        this.dpCollection = server.method_3836().method_29210();
        if (!AfkPlusConflicts.checkDatapacks(this.dpCollection)) {
            AfkPlus.LOGGER.warn("onReloadComplete(): MOD Data Pack test has FAILED.");
        }
        AfkPlus.debugLog("onReloadComplete(): Server has reloaded it's data packs, {}", server.getServerModName());
    }

    @ApiStatus.Internal
    public void onDedicatedStarted(class_3176 server) {
        AfkPlus.debugLog("onDedicatedStarted(): Dedicated Server is starting, {}", server.getServerModName());
    }

    @ApiStatus.Internal
    public void onIntegratedStarted(class_1132 server) {
        AfkPlus.debugLog("onIntegratedStarted(): Integrated Server is starting, {}", server.getServerModName());
    }

    @ApiStatus.Internal
    public void onOpenToLan(class_1132 server, class_1934 mode) {
        AfkPlus.debugLog("onOpenToLan(): Server is open for LAN, {} [Game Mode: {}]", server.getServerModName(), mode.method_8381());
    }

    @ApiStatus.Internal
    public void onDedicatedStopping(class_3176 server) {
        AfkPlus.debugLog("onDedicatedStopping(): Server is stopping, {}", server.getServerModName());
    }

    @ApiStatus.Internal
    public void onStopping(MinecraftServer server) {
        AfkPlus.debugLog("onStopping(): Server is stopping, {}", server.getServerModName());
    }

    @ApiStatus.Internal
    public void onStopped(MinecraftServer server) {
        AfkPlus.debugLog("onStopped(): Server has stopped, {}", server.getServerModName());
    }
}

