/*
 * Decompiled with CFR 0.152.
 */
package com.sakuraryoko.afkplus.commands.server;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.sakuraryoko.afkplus.AfkPlus;
import com.sakuraryoko.afkplus.compat.morecolors.TextHandler;
import com.sakuraryoko.afkplus.compat.vanish.VanishAPICompat;
import com.sakuraryoko.afkplus.config.AfkConfigHandler;
import com.sakuraryoko.afkplus.config.ConfigWrap;
import com.sakuraryoko.afkplus.modinit.AfkPlusInit;
import com.sakuraryoko.afkplus.player.AfkPlayer;
import com.sakuraryoko.afkplus.player.AfkPlayerInfo;
import com.sakuraryoko.afkplus.player.AfkPlayerList;
import com.sakuraryoko.corelib.api.commands.IServerCommand;
import com.sakuraryoko.corelib.api.config.IConfigDispatch;
import com.sakuraryoko.corelib.api.modinit.ModInitData;
import com.sakuraryoko.corelib.impl.config.ConfigManager;
import java.util.List;
import me.lucko.fabric.api.permissions.v0.Permissions;
import net.minecraft.class_1297;
import net.minecraft.class_156;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_7157;

public class AfkPlusCommand
implements IServerCommand {
    public void register(CommandDispatcher<class_2168> dispatcher, class_7157 registryAccess, class_2170.class_5364 environment) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)this.getName()).requires(Permissions.require((String)this.getNode(), (int)ConfigWrap.afk().afkPlusCommandPermissions))).executes(ctx -> this.about((class_2168)ctx.getSource(), (CommandContext<class_2168>)ctx))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"reload").requires(Permissions.require((String)(this.getNode() + ".reload"), (int)ConfigWrap.afk().afkPlusCommandPermissions))).executes(ctx -> this.reload((class_2168)ctx.getSource(), (CommandContext<class_2168>)ctx)))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"save").requires(Permissions.require((String)(this.getNode() + ".save"), (int)ConfigWrap.afk().afkPlusCommandPermissions))).executes(ctx -> this.save((class_2168)ctx.getSource(), (CommandContext<class_2168>)ctx)))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"defaults").requires(Permissions.require((String)(this.getNode() + ".defaults"), (int)4))).executes(ctx -> this.defaults((class_2168)ctx.getSource(), (CommandContext<class_2168>)ctx)))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"set").requires(Permissions.require((String)(this.getNode() + ".set"), (int)ConfigWrap.afk().afkPlusCommandPermissions))).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).executes(ctx -> this.setAfk((class_2168)ctx.getSource(), class_2186.method_9315((CommandContext)ctx, (String)"player"), "", (CommandContext<class_2168>)ctx))).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"reason", (ArgumentType)StringArgumentType.greedyString()).requires(Permissions.require((String)(this.getNode() + ".set"), (int)ConfigWrap.afk().afkPlusCommandPermissions))).executes(ctx -> this.setAfk((class_2168)ctx.getSource(), class_2186.method_9315((CommandContext)ctx, (String)"player"), StringArgumentType.getString((CommandContext)ctx, (String)"reason"), (CommandContext<class_2168>)ctx)))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"clear").requires(Permissions.require((String)(this.getNode() + ".clear"), (int)ConfigWrap.afk().afkPlusCommandPermissions))).then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).executes(ctx -> this.clearAfk((class_2168)ctx.getSource(), class_2186.method_9315((CommandContext)ctx, (String)"player"), (CommandContext<class_2168>)ctx))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"info").requires(Permissions.require((String)(this.getNode() + ".info"), (int)ConfigWrap.afk().afkPlusCommandPermissions))).then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).executes(ctx -> this.infoAfkPlayer((class_2168)ctx.getSource(), class_2186.method_9315((CommandContext)ctx, (String)"player"), (CommandContext<class_2168>)ctx))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"damage").requires(Permissions.require((String)(this.getNode() + ".damage"), (int)ConfigWrap.afk().afkPlusCommandPermissions))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"disable").requires(Permissions.require((String)(this.getNode() + ".damage.disable"), (int)ConfigWrap.afk().afkPlusCommandPermissions))).then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).executes(ctx -> this.disableDamagePlayer((class_2168)ctx.getSource(), class_2186.method_9315((CommandContext)ctx, (String)"player"), (CommandContext<class_2168>)ctx))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"enable").requires(Permissions.require((String)(this.getNode() + ".damage.enable"), (int)ConfigWrap.afk().afkPlusCommandPermissions))).then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).executes(ctx -> this.enableDamagePlayer((class_2168)ctx.getSource(), class_2186.method_9315((CommandContext)ctx, (String)"player"), (CommandContext<class_2168>)ctx)))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"update").requires(Permissions.require((String)(this.getNode() + ".update"), (int)ConfigWrap.afk().afkPlusCommandPermissions))).then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).executes(ctx -> this.updatePlayer((class_2168)ctx.getSource(), class_2186.method_9315((CommandContext)ctx, (String)"player"), (CommandContext<class_2168>)ctx)))));
    }

    public String getName() {
        return this.getModId();
    }

    public String getModId() {
        return "afkplus";
    }

    private int about(class_2168 src, CommandContext<class_2168> context) {
        List info = AfkPlusInit.getInstance().getPlaceholderFormatted(ModInitData.ALL_INFO);
        String user = src.method_9214();
        for (class_2561 entry : info) {
            ((class_2168)context.getSource()).method_9226(entry, false);
        }
        AfkPlus.debugLog("{} has executed /afkplus .", user);
        return 1;
    }

    private int reload(class_2168 src, CommandContext<class_2168> context) {
        String user = src.method_9214();
        ConfigManager.getInstance().reloadEach((IConfigDispatch)AfkConfigHandler.getInstance());
        ((class_2168)context.getSource()).method_9226((class_2561)class_2561.method_43470((String)"Reloaded config!"), false);
        AfkPlus.LOGGER.info("{} has reloaded the configuration.", (Object)user);
        return 1;
    }

    private int save(class_2168 src, CommandContext<class_2168> context) {
        String user = src.method_9214();
        ConfigManager.getInstance().saveEach((IConfigDispatch)AfkConfigHandler.getInstance());
        ((class_2168)context.getSource()).method_9226((class_2561)class_2561.method_43470((String)"Saving config!"), false);
        AfkPlus.LOGGER.info("{} has saved the configuration.", (Object)user);
        return 1;
    }

    private int defaults(class_2168 src, CommandContext<class_2168> context) {
        String user = src.method_9214();
        ConfigManager.getInstance().defaultEach((IConfigDispatch)AfkConfigHandler.getInstance());
        ((class_2168)context.getSource()).method_9226((class_2561)class_2561.method_43470((String)"Set config defaults!"), false);
        AfkPlus.LOGGER.info("{} has set the default configuration.", (Object)user);
        return 1;
    }

    private int setAfk(class_2168 src, class_3222 player, String reason, CommandContext<class_2168> context) {
        AfkPlayer afkPlayer = AfkPlayerList.getInstance().addOrGetPlayer(player);
        String user = src.method_9214();
        if (VanishAPICompat.hasVanish() && VanishAPICompat.isVanishedByEntity((class_1297)player)) {
            String response = afkPlayer.getName() + ConfigWrap.mess().whileVanished;
            ((class_2168)context.getSource()).method_9226(TextHandler.getInstance().formatTextSafe(response), false);
            return 1;
        }
        if (afkPlayer.isAfk()) {
            ((class_2168)context.getSource()).method_9226((class_2561)class_2561.method_43470((String)(afkPlayer.getName() + " is already marked as AFK.")), false);
            return 1;
        }
        if (class_156.method_658() - afkPlayer.getLastAfkTimeMs() > (long)ConfigWrap.afk().afkCommandCooldown * 1000L) {
            ((class_2168)context.getSource()).method_9226((class_2561)class_2561.method_43470((String)(afkPlayer.getName() + " was AFK too recently.  Give them a second to catch up.")), false);
            return 1;
        }
        if (afkPlayer.isNoAfkEnabled()) {
            afkPlayer.setNoAfkEnabled(false);
            ((class_2168)context.getSource()).method_9226((class_2561)class_2561.method_43470((String)("Toggled player " + afkPlayer.getName() + "'s NoAFK status OFF.")), true);
        }
        if (reason == null && ConfigWrap.mess().defaultReason == null) {
            afkPlayer.getHandler().registerAfk("via /afkplus set");
            AfkPlus.LOGGER.info("{} set player {} as AFK", (Object)user, (Object)afkPlayer.getName());
        } else if (reason == null || reason.isEmpty()) {
            afkPlayer.getHandler().registerAfk(ConfigWrap.mess().defaultReason);
            AfkPlus.LOGGER.info("{} set player {} as AFK for reason: {}", (Object)user, (Object)afkPlayer.getName(), (Object)ConfigWrap.mess().defaultReason);
        } else {
            afkPlayer.getHandler().registerAfk(reason);
            AfkPlus.LOGGER.info("{} set player {} as AFK for reason: {}", (Object)user, (Object)afkPlayer.getName(), (Object)reason);
        }
        return 1;
    }

    private int clearAfk(class_2168 src, class_3222 player, CommandContext<class_2168> context) {
        AfkPlayer afkPlayer = AfkPlayerList.getInstance().addOrGetPlayer(player);
        String user = src.method_9214();
        if (VanishAPICompat.hasVanish() && VanishAPICompat.isVanishedByEntity((class_1297)player)) {
            String response = afkPlayer.getName() + ConfigWrap.mess().whileVanished;
            ((class_2168)context.getSource()).method_9226(TextHandler.getInstance().formatTextSafe(response), false);
            return 1;
        }
        if (afkPlayer.isAfk()) {
            afkPlayer.getHandler().unregisterAfk();
            AfkPlus.LOGGER.info("{} cleared player {} from AFK", (Object)user, (Object)afkPlayer.getName());
        } else {
            ((class_2168)context.getSource()).method_9226((class_2561)class_2561.method_43470((String)(afkPlayer.getName() + " is not marked as AFK.")), false);
        }
        return 1;
    }

    private int infoAfkPlayer(class_2168 src, class_3222 player, CommandContext<class_2168> context) {
        AfkPlayer afkPlayer = AfkPlayerList.getInstance().addOrGetPlayer(player);
        String user = src.method_9214();
        if (afkPlayer.isAfk()) {
            ((class_2168)context.getSource()).method_9226(TextHandler.getInstance().formatTextSafe(AfkPlayerInfo.getString(afkPlayer)), false);
            ((class_2168)context.getSource()).method_9226(AfkPlayerInfo.getReason(afkPlayer, src), false);
            AfkPlus.LOGGER.info("{} displayed {}'s AFK info.", (Object)user, (Object)afkPlayer.getName());
        } else {
            ((class_2168)context.getSource()).method_9226((class_2561)class_2561.method_43470((String)(afkPlayer.getName() + " is not marked as AFK.")), false);
        }
        return 1;
    }

    private int disableDamagePlayer(class_2168 src, class_3222 player, CommandContext<class_2168> context) {
        AfkPlayer afkPlayer = AfkPlayerList.getInstance().addOrGetPlayer(player);
        String user = src.method_9214();
        if (VanishAPICompat.hasVanish() && VanishAPICompat.isVanishedByEntity((class_1297)player)) {
            String response = afkPlayer.getName() + ConfigWrap.mess().whileVanished;
            ((class_2168)context.getSource()).method_9226(TextHandler.getInstance().formatTextSafe(response), false);
            return 1;
        }
        if (afkPlayer.isLockDamageEnabled()) {
            afkPlayer.getHandler().unlockDamageEnabled();
            ((class_2168)context.getSource()).method_9226((class_2561)class_2561.method_43470((String)("Allowing Damage Disable feature for player " + afkPlayer.getName())), true);
            AfkPlus.LOGGER.info("{} Allowing Damage Disable feature for player {}", (Object)user, (Object)afkPlayer.getName());
        } else {
            ((class_2168)context.getSource()).method_9226((class_2561)class_2561.method_43470((String)("Damage Disable is already allowed for player " + afkPlayer.getName())), false);
        }
        return 1;
    }

    private int enableDamagePlayer(class_2168 src, class_3222 player, CommandContext<class_2168> context) {
        AfkPlayer afkPlayer = AfkPlayerList.getInstance().addOrGetPlayer(player);
        String user = src.method_9214();
        if (VanishAPICompat.hasVanish() && VanishAPICompat.isVanishedByEntity((class_1297)player)) {
            String response = afkPlayer.getName() + ConfigWrap.mess().whileVanished;
            ((class_2168)context.getSource()).method_9226(TextHandler.getInstance().formatTextSafe(response), false);
            return 1;
        }
        if (!afkPlayer.isLockDamageEnabled()) {
            afkPlayer.getHandler().lockDamageEnabled();
            ((class_2168)context.getSource()).method_9226((class_2561)class_2561.method_43470((String)("Force-Enabling Damage for player " + afkPlayer.getName())), true);
            AfkPlus.LOGGER.info("{} Force-Enabling Damage for player {}", (Object)user, (Object)afkPlayer.getName());
        } else {
            ((class_2168)context.getSource()).method_9226((class_2561)class_2561.method_43470((String)("Damage Disable is already disallowed for player " + afkPlayer.getName())), false);
        }
        return 1;
    }

    private int updatePlayer(class_2168 src, class_3222 player, CommandContext<class_2168> context) {
        AfkPlayer afkPlayer = AfkPlayerList.getInstance().addOrGetPlayer(player);
        String user = src.method_9214();
        if (VanishAPICompat.hasVanish() && VanishAPICompat.isVanishedByEntity((class_1297)player)) {
            String response = afkPlayer.getName() + ConfigWrap.mess().whileVanished;
            ((class_2168)context.getSource()).method_9226(TextHandler.getInstance().formatTextSafe(response), false);
            return 1;
        }
        afkPlayer.getHandler().updatePlayerList();
        ((class_2168)context.getSource()).method_9226((class_2561)class_2561.method_43470((String)("Updating player list entry for " + afkPlayer.getName())), false);
        AfkPlus.LOGGER.info("{} updated player list entry for {}", (Object)user, (Object)afkPlayer.getName());
        return 1;
    }
}

