/*
 * Decompiled with CFR 0.152.
 */
package com.sakuraryoko.afkplus.compat.vanish;

import com.sakuraryoko.afkplus.AfkPlus;
import java.util.UUID;
import javax.annotation.Nonnull;
import me.drex.vanish.api.VanishAPI;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1297;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;

public class VanishAPICompat {
    private static final boolean hasVanish = FabricLoader.getInstance().isModLoaded("melius-vanish");

    public static boolean hasVanish() {
        return hasVanish;
    }

    public static boolean isVanishedByEntity(@Nonnull class_1297 entity) {
        if (!hasVanish) {
            return false;
        }
        try {
            return VanishAPI.isVanished((class_1297)entity);
        }
        catch (Throwable e) {
            AfkPlus.LOGGER.error("VanishCompat#isVanishedEntity(): has thrown an error: [{}]", (Object)e.getMessage());
            return false;
        }
    }

    public static boolean isVanishedByUUIO(@Nonnull MinecraftServer server, @Nonnull UUID uuid) {
        if (!hasVanish) {
            return false;
        }
        try {
            return VanishAPI.isVanished((MinecraftServer)server, (UUID)uuid);
        }
        catch (Throwable e) {
            AfkPlus.LOGGER.error("VanishCompat#isVanishedUUID(): has thrown an error: [{}]", (Object)e.getMessage());
            return false;
        }
    }

    public static void broadcastHiddenMessage(@Nonnull class_3222 player, @Nonnull class_2561 message) {
        if (!hasVanish) {
            return;
        }
        try {
            VanishAPI.broadcastHiddenMessage((class_3222)player, (class_2561)message);
        }
        catch (Throwable e) {
            AfkPlus.LOGGER.error("VanishCompat#broadcastHiddenMessage(): has thrown an error: [{}]", (Object)e.getMessage());
        }
    }

    public static void sendHiddenMessage(@Nonnull class_3222 sender, @Nonnull class_3222 observer, @Nonnull class_2561 message) {
    }
}

