/*
 * Decompiled with CFR 0.152.
 */
package com.sakuraryoko.afkplus.config;

import com.sakuraryoko.afkplus.AfkPlus;
import com.sakuraryoko.afkplus.Reference;
import com.sakuraryoko.afkplus.config.TomlConfigManager;
import com.sakuraryoko.afkplus.config.data.AfkConfigData;
import com.sakuraryoko.afkplus.config.data.options.AfkPlusOptions;
import com.sakuraryoko.afkplus.config.data.options.DisableDamageOptions;
import com.sakuraryoko.afkplus.config.data.options.KickOptions;
import com.sakuraryoko.afkplus.config.data.options.MessageOptions;
import com.sakuraryoko.afkplus.config.data.options.PacketOptions;
import com.sakuraryoko.afkplus.config.data.options.PlaceholderOptions;
import com.sakuraryoko.afkplus.config.data.options.PlayerListOptions;
import com.sakuraryoko.afkplus.modinit.AfkPlusInit;
import com.sakuraryoko.corelib.api.config.IConfigData;
import com.sakuraryoko.corelib.api.config.IConfigDispatch;
import com.sakuraryoko.corelib.api.time.TimeFormat;
import com.sakuraryoko.corelib.impl.config.ConfigManager;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;

public class AfkConfigHandler
implements IConfigDispatch {
    private static final AfkConfigHandler INSTANCE = new AfkConfigHandler();
    private AfkConfigData CONFIG = this.newConfig();
    private final String CONFIG_ROOT = ".";
    private final String CONFIG_NAME = "afkplus";
    private boolean loaded = false;

    public static AfkConfigHandler getInstance() {
        return INSTANCE;
    }

    public String getConfigRoot() {
        return this.CONFIG_ROOT;
    }

    public boolean useRootDir() {
        return true;
    }

    public String getConfigName() {
        return this.CONFIG_NAME;
    }

    public AfkConfigData newConfig() {
        return new AfkConfigData();
    }

    public AfkConfigData getConfig() {
        return this.CONFIG;
    }

    public AfkPlusOptions getAfkPlusOptions() {
        return this.CONFIG.AFK_PLUS;
    }

    public MessageOptions getMessageOptions() {
        return this.CONFIG.MESSAGE;
    }

    public PacketOptions getPacketOptions() {
        return this.CONFIG.PACKET;
    }

    public DisableDamageOptions getDisableDamageOptions() {
        return this.CONFIG.DAMAGE;
    }

    public KickOptions getKickOptions() {
        return this.CONFIG.KICK;
    }

    public PlaceholderOptions getPlaceholderOptions() {
        return this.CONFIG.PLACEHOLDER;
    }

    public PlayerListOptions getPlayerListOptions() {
        return this.CONFIG.PLAYER_LIST;
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    public void initConfig() {
        this.checkForTomlFile();
        this.checkForRootConfig();
    }

    @Deprecated(forRemoval=true)
    private void checkForTomlFile() {
        try {
            Path tomlFile = Reference.CONFIG_DIR.resolve("afkplus.toml");
            if (Files.exists(tomlFile, new LinkOption[0])) {
                AfkPlus.LOGGER.warn("checkForTomlFile(): Found legacy TOML file [{}]; importing ...", (Object)tomlFile.getFileName().toString());
                this.CONFIG = this.defaults();
                TomlConfigManager.initConfig();
                TomlConfigManager.loadConfig();
                this.CONFIG.AFK_PLUS.fromToml(TomlConfigManager.CONFIG.afkPlusOptions, this.CONFIG.AFK_PLUS);
                this.CONFIG.MESSAGE.fromToml(TomlConfigManager.CONFIG.messageOptions, this.CONFIG.MESSAGE);
                this.CONFIG.PACKET.fromToml(TomlConfigManager.CONFIG.packetOptions, this.CONFIG.PACKET);
                this.CONFIG.DAMAGE.fromToml(TomlConfigManager.CONFIG.packetOptions, this.CONFIG.DAMAGE);
                this.CONFIG.DAMAGE.fromToml(TomlConfigManager.CONFIG.messageOptions, this.CONFIG.DAMAGE);
                this.CONFIG.KICK.fromToml(TomlConfigManager.CONFIG.packetOptions, this.CONFIG.KICK);
                this.CONFIG.KICK.fromToml(TomlConfigManager.CONFIG.messageOptions, this.CONFIG.KICK);
                this.CONFIG.PLACEHOLDER.fromToml(TomlConfigManager.CONFIG.PlaceholderOptions, this.CONFIG.PLACEHOLDER);
                this.CONFIG.PLAYER_LIST.fromToml(TomlConfigManager.CONFIG.playerListOptions, this.CONFIG.PLAYER_LIST);
                this.onPreSaveConfig();
                ConfigManager.getInstance().saveEach((IConfigDispatch)this);
                this.execute(true);
                this.onPostSaveConfig();
                AfkPlus.LOGGER.info("checkForTomlFile(): Deleting legacy TOML file [{}]", (Object)tomlFile.getFileName().toString());
                Files.delete(tomlFile);
            }
        }
        catch (Exception err) {
            AfkPlus.LOGGER.error("checkForTomlFile(): Error converting legacy TOML file // {}", (Object)err.getMessage());
        }
    }

    private void checkForRootConfig() {
        try {
            Path dir = Reference.CONFIG_DIR.resolve("afkplus");
            if (Files.isDirectory(dir, new LinkOption[0])) {
                AfkPlus.LOGGER.warn("checkForRootConfig(): Found Sub Config dir [{}]", (Object)dir.getFileName().toString());
                Path oldFile = dir.resolve(this.getConfigName() + ".json");
                if (Files.exists(oldFile, new LinkOption[0])) {
                    Path newFile = Reference.CONFIG_DIR.resolve("afkplus.json");
                    AfkPlus.LOGGER.warn("checkForRootConfig(): Moving Root Config file [{}/{}] to [{}] ...", (Object)dir.getFileName().toString(), (Object)oldFile.getFileName().toString(), (Object)newFile.getFileName().toString());
                    Files.move(oldFile, newFile, new CopyOption[0]);
                }
                Files.delete(dir);
            }
        }
        catch (Exception err) {
            AfkPlus.LOGGER.error("checkForRootConfig(): Error moving Root Config file // {}", (Object)err.getMessage());
        }
    }

    public void onPreLoadConfig() {
        this.loaded = false;
    }

    public void onPostLoadConfig() {
        this.loaded = true;
    }

    public void onPreSaveConfig() {
        this.loaded = false;
    }

    public void onPostSaveConfig() {
        this.loaded = true;
    }

    public AfkConfigData defaults() {
        AfkConfigData config = this.newConfig();
        AfkPlus.debugLog("AfkConfigHandler#defaults(): Setting default config.", new Object[0]);
        config.config_date = TimeFormat.RFC1123.formatNow(null);
        config.AFK_PLUS.defaults();
        config.MESSAGE.defaults();
        config.PACKET.defaults();
        config.DAMAGE.defaults();
        config.KICK.defaults();
        config.PLACEHOLDER.defaults();
        config.PLAYER_LIST.defaults();
        return config;
    }

    public AfkConfigData update(IConfigData newConfig) {
        AfkConfigData newConf = (AfkConfigData)newConfig;
        AfkPlus.debugLog("AfkConfigHandler#update(): Refresh config.", new Object[0]);
        this.CONFIG.comment = AfkPlusInit.getInstance().getModVersionString() + " Config";
        this.CONFIG.config_date = TimeFormat.RFC1123.formatNow(null);
        AfkPlus.debugLog("AfkConfigHandler#update(): save_date: {} --> {}", newConf.config_date, this.CONFIG.config_date);
        this.CONFIG.AFK_PLUS.copy(newConf.AFK_PLUS);
        this.CONFIG.MESSAGE.copy(newConf.MESSAGE);
        this.CONFIG.PACKET.copy(newConf.PACKET);
        this.CONFIG.DAMAGE.copy(newConf.DAMAGE);
        this.CONFIG.KICK.copy(newConf.KICK);
        this.CONFIG.PLACEHOLDER.copy(newConf.PLACEHOLDER);
        this.CONFIG.PLAYER_LIST.copy(newConf.PLAYER_LIST);
        return this.CONFIG;
    }

    public void execute(boolean fromInit) {
        AfkPlus.debugLog("AfkConfigHandler#execute(): Execute config.", new Object[0]);
        AfkPlus.debugLog("AfkConfigHandler#execute(): new config_date: {}", this.CONFIG.config_date);
    }
}

