/*
 * Decompiled with CFR 0.152.
 */
package com.sakuraryoko.afkplus.config.data.options;

import com.sakuraryoko.afkplus.config.data.TomlConfigData;
import com.sakuraryoko.corelib.api.config.IConfigOption;
import com.sakuraryoko.corelib.api.time.DurationFormat;
import com.sakuraryoko.corelib.api.time.DurationOption;
import com.sakuraryoko.corelib.api.time.TimeDateOption;

public class MessageOptions
implements IConfigOption {
    public boolean enableMessages;
    public String whenAfk;
    public String whenAfkPunctuation;
    public String whenReturn;
    public String whenReturnDurationPrefix;
    public String whenReturnDurationSuffix;
    public String defaultReason;
    public String afkCooldownGreeting;
    public String whileYourVanished;
    public String whileVanished;
    public boolean displayDuration;
    public DurationOption duration;
    public TimeDateOption timeDate;

    public MessageOptions() {
        this.defaults();
    }

    public void defaults() {
        this.enableMessages = true;
        this.whenAfk = "%player:displayname% <yellow>is now AFK<r>";
        this.whenAfkPunctuation = "<yellow>,<r> ";
        this.whenReturn = "%player:displayname% <yellow>is no longer AFK<r>";
        this.whenReturnDurationPrefix = " <gray>(Gone for: <green>";
        this.whenReturnDurationSuffix = "<gray>)";
        this.defaultReason = "<gray>poof!<r>";
        this.afkCooldownGreeting = "<yellow>Welcome back, <r>%player:display_name%<r>, <yellow>did you miss anything fun?";
        this.whileYourVanished = "<red>You are vanished, and probably shouldn't be doing that.<r>";
        this.whileVanished = "<red> is vanished, and probably shouldn't be doing that.<r>";
        this.displayDuration = true;
        this.duration = new DurationOption();
        this.duration.option = DurationFormat.PRETTY;
        this.timeDate = new TimeDateOption();
    }

    public MessageOptions copy(IConfigOption opt) {
        MessageOptions opts = (MessageOptions)opt;
        this.enableMessages = opts.enableMessages;
        this.whenAfk = opts.whenAfk;
        this.whenAfkPunctuation = !opts.whenAfkPunctuation.isEmpty() ? opts.whenAfkPunctuation : "<yellow>,<r> ";
        this.whenReturn = opts.whenReturn;
        this.whenReturnDurationPrefix = !opts.whenReturnDurationPrefix.isEmpty() ? opts.whenReturnDurationPrefix : " <gray>(Gone for: <green>";
        this.whenReturnDurationSuffix = !opts.whenReturnDurationSuffix.isEmpty() ? opts.whenReturnDurationSuffix : "<gray>)";
        this.defaultReason = opts.defaultReason;
        this.afkCooldownGreeting = opts.afkCooldownGreeting;
        this.whileYourVanished = opts.whileYourVanished;
        this.whileVanished = opts.whileVanished;
        this.displayDuration = opts.displayDuration;
        this.duration.copy((IConfigOption)opts.duration);
        this.timeDate.copy((IConfigOption)opts.timeDate);
        return this;
    }

    public MessageOptions fromToml(TomlConfigData.MessageOptions opts, MessageOptions opt) {
        this.copy(opt);
        this.enableMessages = opts.enableMessages;
        this.whenAfk = opts.whenAfk;
        this.whenAfkPunctuation = "<yellow>,<r> ";
        this.whenReturn = opts.whenReturn;
        this.whenReturnDurationPrefix = " <gray>(Gone for: <green>";
        this.whenReturnDurationSuffix = "<gray>)";
        this.defaultReason = opts.defaultReason;
        this.afkCooldownGreeting = "<yellow>Welcome back, <r>%player:display_name%<r>, <yellow>did you miss anything fun?";
        this.displayDuration = opts.displayDuration;
        this.whileYourVanished = "<red>You are vanished, and probably shouldn't be doing that.<r>";
        this.whileVanished = "<red> is vanished, and probably shouldn't be doing that.<r>";
        this.duration = new DurationOption();
        this.timeDate = new TimeDateOption();
        if (opts.prettyDuration) {
            this.duration.option = DurationFormat.PRETTY;
        }
        return this;
    }
}

