/*
 * Decompiled with CFR 0.152.
 */
package com.sakuraryoko.afkplus.events;

import com.mojang.authlib.GameProfile;
import com.sakuraryoko.afkplus.AfkPlus;
import com.sakuraryoko.afkplus.compat.morecolors.TextHandler;
import com.sakuraryoko.afkplus.compat.vanish.VanishAPICompat;
import com.sakuraryoko.afkplus.config.ConfigWrap;
import com.sakuraryoko.afkplus.modinit.AfkPlusInit;
import com.sakuraryoko.afkplus.player.AfkPlayer;
import com.sakuraryoko.afkplus.player.AfkPlayerList;
import com.sakuraryoko.corelib.api.events.IPlayerEventsDispatch;
import eu.pb4.placeholders.api.PlaceholderContext;
import eu.pb4.placeholders.api.Placeholders;
import java.net.SocketAddress;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.class_1297;
import net.minecraft.class_156;
import net.minecraft.class_1934;
import net.minecraft.class_2535;
import net.minecraft.class_2561;
import net.minecraft.class_2828;
import net.minecraft.class_3222;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class PlayerEventsHandler
implements IPlayerEventsDispatch {
    private static final PlayerEventsHandler INSTANCE = new PlayerEventsHandler();

    public static PlayerEventsHandler getInstance() {
        return INSTANCE;
    }

    @ApiStatus.Internal
    public PlayerEventsHandler() {
    }

    @ApiStatus.Internal
    public void onConnection(@Nonnull SocketAddress addr, @Nonnull GameProfile profile, @Nullable class_2561 result) {
        if (result == null) {
            AfkPlus.debugLog("onConnection(): Client connection from Profile [{}]", profile.name());
        } else {
            AfkPlus.debugLog("onConnection(): Client connection from Profile [{}] --> REFUSED [{}]", profile.name(), result.getString());
        }
    }

    @ApiStatus.Internal
    public void onCreatePlayer(@Nonnull class_3222 player, @Nullable GameProfile profile) {
        if (profile == null) {
            profile = player.method_7334();
        }
        AfkPlus.debugLog("onCreatePlayer(): Player created [{}] // Profile [{}]", player.method_5477().getString(), profile.name());
        AfkPlayer afkPlayer = AfkPlayerList.getInstance().addOrGetPlayer(player);
        if (player.field_13974.method_14257() == class_1934.field_9215 && player.method_5655()) {
            AfkPlus.LOGGER.warn("PlayerManager().createPlayer() -> Marking SURVIVAL player: {} as vulnerable.", (Object)afkPlayer.getName());
            player.method_5684(false);
        }
    }

    @ApiStatus.Internal
    public void onPlayerJoinPre(class_3222 player, class_2535 connection) {
        AfkPlus.debugLog("onJoinPre(): Player [{}] // Joining", player.method_5477().getString());
    }

    @ApiStatus.Internal
    public void onPlayerJoinPost(class_3222 player, class_2535 connection) {
        AfkPlus.debugLog("onJoinPost(): Player [{}] // Joined", player.method_5477().getString());
        AfkPlayer afkPlayer = AfkPlayerList.getInstance().addOrGetPlayer(player);
        if (player.field_13974.method_14257() == class_1934.field_9215 && player.method_5655()) {
            AfkPlus.LOGGER.warn("PlayerManager().onPlayerConnect() -> Marking SURVIVAL player: {} as vulnerable.", (Object)afkPlayer.getName());
            player.method_5684(false);
        }
        if (VanishAPICompat.hasVanish() && VanishAPICompat.isVanishedByEntity((class_1297)player)) {
            return;
        }
        if (AfkPlusInit.getInstance().isServer()) {
            afkPlayer.getHandler().updatePlayerList();
        }
    }

    @ApiStatus.Internal
    public void onPlayerRespawn(class_3222 player) {
        AfkPlus.debugLog("onRespawn(): Player [{}] // Respawned", player.method_5477().getString());
        if (player.field_13974.method_14257() == class_1934.field_9215 && player.method_5655()) {
            AfkPlayer afkPlayer = AfkPlayerList.getInstance().addOrGetPlayer(player);
            AfkPlus.LOGGER.warn("PlayerManager().repsawnPlayer() -> Marking SURVIVAL player: {} as vulnerable.", (Object)afkPlayer.getName());
            player.method_5684(false);
            if (VanishAPICompat.hasVanish() && VanishAPICompat.isVanishedByEntity((class_1297)player)) {
                return;
            }
            if (AfkPlusInit.getInstance().isServer()) {
                afkPlayer.getHandler().updatePlayerList();
            }
        }
    }

    @ApiStatus.Internal
    public void onPlayerLeave(class_3222 player) {
        AfkPlus.debugLog("onRespawn(): Player [{}] // Disconnected", player.method_5477().getString());
        AfkPlayerList.getInstance().removePlayer(player);
    }

    @ApiStatus.Internal
    public void onDisconnectAll() {
        AfkPlus.debugLog("onDisconnectAll()", new Object[0]);
        AfkPlayerList.getInstance().removeAllPlayers();
    }

    @ApiStatus.Internal
    public void onSetViewDistance(int i) {
    }

    @ApiStatus.Internal
    public void onSetSimulationDistance(int i) {
    }

    @ApiStatus.Internal
    public void onTickPacket(@Nonnull class_3222 player) {
        if (VanishAPICompat.hasVanish() && VanishAPICompat.isVanishedByEntity((class_1297)player)) {
            return;
        }
        AfkPlayer afkPlayer = AfkPlayerList.getInstance().addOrGetPlayer(player);
        int timeoutSeconds = ConfigWrap.pack().timeoutSeconds;
        long afkDuration = class_156.method_658() - player.method_14219();
        if (afkPlayer.isAfk() || timeoutSeconds <= 0) {
            if (ConfigWrap.kick().afkKickEnabled && ConfigWrap.kick().afkKickTimer > -1 && AfkPlusInit.getInstance().isServer()) {
                if ((afkPlayer.getPlayer().method_68878() || afkPlayer.getPlayer().method_7325()) && !ConfigWrap.kick().afkKickNonSurvival) {
                    return;
                }
                int kickTimeout = ConfigWrap.kick().afkKickTimer + ConfigWrap.pack().timeoutSeconds;
                if (afkDuration > (long)kickTimeout * 1000L) {
                    AfkPlus.debugLog("onTickPacket(): Kicking player {} from AFK (timeout)", afkPlayer.getName());
                    afkPlayer.getHandler().afkKick();
                }
            }
        } else if (!afkPlayer.isNoAfkEnabled()) {
            if (afkDuration > (long)timeoutSeconds * 1000L) {
                if (ConfigWrap.pack().afkTimeoutString.isEmpty()) {
                    afkPlayer.getHandler().registerAfk("");
                } else {
                    afkPlayer.getHandler().registerAfk(ConfigWrap.pack().afkTimeoutString);
                }
                AfkPlus.debugLog("onTickPacket(): Setting player {} as AFK (timeout) [Duration {}, timeoutSeconds {}]", afkPlayer.getName(), afkDuration, timeoutSeconds);
            } else if (afkPlayer.shouldIgnoreAttacks()) {
                if (ConfigWrap.pack().afkTimeoutString.isEmpty()) {
                    afkPlayer.getHandler().registerAfk("");
                } else {
                    afkPlayer.getHandler().registerAfk(ConfigWrap.pack().afkTimeoutIgnoreAttack);
                }
                AfkPlus.debugLog("onTickPacket(): Setting player {} as AFK (movement/looking timeout; but they are still attacking)", afkPlayer.getName());
            }
        }
        afkPlayer.getHandler().tickPlayer(player);
    }

    @ApiStatus.Internal
    public void onTickPlayer(@Nonnull class_3222 player) {
        if (!player.field_13987.method_48106()) {
            return;
        }
        if (VanishAPICompat.hasVanish() && VanishAPICompat.isVanishedByEntity((class_1297)player)) {
            return;
        }
        AfkPlayer afkPlayer = AfkPlayerList.getInstance().addOrGetPlayer(player);
        if (afkPlayer.isAfk() && ConfigWrap.list().updateInterval > 0) {
            if (afkPlayer.getLastPlayerListUpdate() <= 0L) {
                afkPlayer.getHandler().updatePlayerList();
            } else {
                long diff = class_156.method_658() - afkPlayer.getLastPlayerListUpdate();
                if (diff > (long)ConfigWrap.list().updateInterval * 1000L) {
                    afkPlayer.getHandler().updatePlayerList();
                }
            }
        }
        if (player.method_68878() || player.method_7325()) {
            return;
        }
        if (afkPlayer.isLockDamageEnabled()) {
            if (!afkPlayer.isDamageEnabled()) {
                afkPlayer.getHandler().enableDamage();
                AfkPlus.debugLog("onTickPlayer() - Damage Enabled for player: {} because they are [LOCKED]. step 1.", afkPlayer.getName());
            }
        } else if (afkPlayer.isAfk() && ConfigWrap.dmg().disableDamage) {
            if (afkPlayer.isDamageEnabled()) {
                int cooldownSeconds = ConfigWrap.dmg().disableDamageCooldown;
                if (cooldownSeconds > 0) {
                    long diff = class_156.method_658() - afkPlayer.getAfkTimeMs();
                    if (diff > (long)cooldownSeconds * 1000L) {
                        afkPlayer.getHandler().disableDamage();
                        AfkPlus.debugLog("onTickPlayer() - Damage Disabled for player: {} step 2.", afkPlayer.getName());
                    }
                } else if (player.field_13974.method_30119() != class_1934.field_9220) {
                    afkPlayer.getHandler().disableDamage();
                    AfkPlus.debugLog("onTickPlayer() - Damage Disabled for player: {} step 4.", afkPlayer.getName());
                }
            }
        } else if (!afkPlayer.isDamageEnabled()) {
            afkPlayer.getHandler().enableDamage();
            AfkPlus.debugLog("onTickPlayer() - Damage Enabled for player: {} step 5.", afkPlayer.getName());
        }
    }

    @ApiStatus.Internal
    public void onMovement(@Nonnull class_3222 player, class_2828 packet) {
        if (VanishAPICompat.hasVanish() && VanishAPICompat.isVanishedByEntity((class_1297)player)) {
            return;
        }
        if (packet.method_36172()) {
            player.method_23320();
            float yaw = player.method_36454();
            float pitch = player.method_36455();
            if (pitch != packet.method_12270(pitch) || yaw != packet.method_12271(yaw)) {
                AfkPlayer afkPlayer = AfkPlayerList.getInstance().addOrGetPlayer(player);
                afkPlayer.setLastLookTime(class_156.method_658());
                if (ConfigWrap.pack().resetOnLook) {
                    player.method_14234();
                }
            }
        }
    }

    @ApiStatus.Internal
    public void onChangeGameMode(@Nonnull class_3222 player, class_1934 mode, boolean result) {
        AfkPlus.debugLog("onChangeGameMode(): Player [{}] // newGameMode [{}]", player.method_5477().getString(), mode.method_8381());
        AfkPlayer afkPlayer = AfkPlayerList.getInstance().addOrGetPlayer(player);
        if (VanishAPICompat.hasVanish() && VanishAPICompat.isVanishedByEntity((class_1297)player)) {
            return;
        }
        if (result) {
            AfkPlus.debugLog("onChangeGameMode() -- Invoked for player {} GameMode: {}", afkPlayer.getName(), mode.method_8381());
            if (afkPlayer.isAfk()) {
                afkPlayer.getHandler().unregisterAfk();
                if (mode == class_1934.field_9215 && ConfigWrap.dmg().disableDamage) {
                    if (player.method_5655()) {
                        player.method_5684(false);
                    }
                    afkPlayer.getHandler().enableDamage();
                }
            }
        }
    }

    @ApiStatus.Internal
    public void onPlayerAttack(@Nonnull class_3222 player, class_1297 entity) {
        if (VanishAPICompat.hasVanish() && VanishAPICompat.isVanishedByEntity((class_1297)player)) {
            return;
        }
        AfkPlayer afkPlayer = AfkPlayerList.getInstance().addOrGetPlayer(player);
        afkPlayer.setLastAttackTime(class_156.method_658());
    }

    @ApiStatus.Internal
    public void onResetLastAction(@Nonnull class_3222 player) {
        if (VanishAPICompat.hasVanish() && VanishAPICompat.isVanishedByEntity((class_1297)player)) {
            return;
        }
        AfkPlayer afkPlayer = AfkPlayerList.getInstance().addOrGetPlayer(player);
        if (afkPlayer.isAfk() && !afkPlayer.shouldIgnoreAttacks()) {
            AfkPlus.debugLog("onResetLastAction(): Player [{}] // Reset Last Action (Remove AFK)", afkPlayer.getName());
            afkPlayer.getHandler().unregisterAfk();
        }
    }

    @ApiStatus.Internal
    public void onSetPos(@Nullable class_3222 player, double x, double y, double z) {
        if (player != null) {
            if (VanishAPICompat.hasVanish() && VanishAPICompat.isVanishedByEntity((class_1297)player)) {
                return;
            }
            if (player.method_23317() != x || player.method_23318() != y || player.method_23321() != z) {
                AfkPlayer afkPlayer = AfkPlayerList.getInstance().addOrGetPlayer(player);
                afkPlayer.setLastMovementTime(class_156.method_658());
                if (ConfigWrap.pack().resetOnMovement) {
                    player.method_14234();
                }
            }
        }
    }

    @ApiStatus.Internal
    public boolean onCheckIfPushable(@Nonnull class_3222 player, boolean value) {
        AfkPlayer afkPlayer = AfkPlayerList.getInstance().addOrGetPlayer(player);
        if (afkPlayer.isAfk() && !afkPlayer.isDamageEnabled() && player.method_5655()) {
            return false;
        }
        return value;
    }

    @Nullable
    @ApiStatus.Internal
    public class_2561 onUpdateDisplayName(@Nonnull class_3222 player, @Nullable class_2561 oldName) {
        AfkPlus.debugLog("onUpdateDisplayName(): Player [{}] // oldName [{}]", player.method_5477().getString(), oldName != null ? oldName.getString() : "<empty>");
        if (VanishAPICompat.hasVanish() && VanishAPICompat.isVanishedByEntity((class_1297)player)) {
            return null;
        }
        AfkPlayer afkPlayer = AfkPlayerList.getInstance().addOrGetPlayer(player);
        if (ConfigWrap.list().enableListDisplay && afkPlayer.isAfk()) {
            class_2561 listEntry = Placeholders.parseText((class_2561)TextHandler.getInstance().formatTextSafe(ConfigWrap.list().afkPlayerName), (PlaceholderContext)PlaceholderContext.of((class_3222)player));
            AfkPlus.debugLog("replacePlayerListName-listEntry().toString(): {}", listEntry.getString());
            afkPlayer.setLastPlayerListUpdate(class_156.method_658());
            return listEntry.method_27661();
        }
        return null;
    }

    @ApiStatus.Internal
    public boolean onCheckSleepCount(@Nonnull class_3222 player, int countActive, int countSleeping, int totalActive, int totalSleeping) {
        AfkPlayer afkPlayer = AfkPlayerList.getInstance().addOrGetPlayer(player);
        AfkPlus.debugLog("checkSleepCount(): Current: countActive {}, countSleeping {} // total {}, sleeping {}", countActive, countSleeping, totalActive, totalSleeping);
        if (afkPlayer.isAfk() && ConfigWrap.pack().bypassSleepCount) {
            AfkPlus.debugLog("AFK Player: {} is being excluded from the sleep requirements.", afkPlayer.getName());
            return true;
        }
        return false;
    }

    @ApiStatus.Internal
    public int onCheckBypassInsomnia(@Nullable class_3222 player, int currentValue) {
        if (player == null) {
            return currentValue;
        }
        AfkPlayer afkPlayer = AfkPlayerList.getInstance().addOrGetPlayer(player);
        if (afkPlayer.isAfk() && ConfigWrap.pack().bypassInsomnia) {
            if (currentValue > 72000) {
                AfkPlus.debugLog("Afk Player: {} was just spared from a phantom spawn chance.", afkPlayer.getName());
            }
            AfkPlus.debugLog("checkPhantomSpawn(): [Player: {}] obtained TIME_SINCE_REST value of {} setting value to 1", afkPlayer.getName(), currentValue);
            return 1;
        }
        AfkPlus.debugLog("checkPhantomSpawn(): [Player: {}] TIME_SINCE_REST has a value of {} ", afkPlayer.getName(), currentValue);
        return currentValue;
    }

    @ApiStatus.Internal
    public void onVanish(@Nonnull class_3222 player, boolean isVanished) {
        AfkPlus.debugLog("onVanish(): Player [{}] / Vanish [{}]", player.method_5477().getString(), isVanished);
        AfkPlayer afkPlayer = AfkPlayerList.getInstance().addOrGetPlayer(player);
        if (afkPlayer.isAfk() && isVanished) {
            afkPlayer.getHandler().unregisterAfkSilently();
        }
    }
}

