/*
 * Decompiled with CFR 0.152.
 */
package com.sakuraryoko.afkplus.player;

import com.sakuraryoko.afkplus.config.ConfigWrap;
import com.sakuraryoko.afkplus.player.AfkHandler;
import com.sakuraryoko.corelib.api.log.AnsiLogger;
import com.sakuraryoko.corelib.api.time.DurationFormat;
import com.sakuraryoko.corelib.api.time.TimeFormat;
import java.time.ZonedDateTime;
import javax.annotation.Nonnull;
import net.minecraft.class_156;
import net.minecraft.class_3222;

public class AfkPlayer {
    private static final AnsiLogger LOGGER = new AnsiLogger(AfkPlayer.class, true);
    private class_3222 player;
    private AfkHandler handler;
    private int entityId;
    private boolean afkEnabled;
    private boolean damageEnabled;
    private boolean lockDamageEnabled;
    private boolean noAfkEnabled;
    private long lastPlayerTick;
    private long afkTimeMs;
    private long lastAfkTimeMs;
    private long afkTimeEpoch;
    private long lastMovementTime;
    private long lastLookTime;
    private long lastAttackTime;
    private long lastPlayerListUpdate;
    private String afkReason;

    private AfkPlayer(@Nonnull class_3222 player) {
        this.player = player;
        this.entityId = player.method_5628();
        this.afkEnabled = false;
        this.damageEnabled = true;
        this.lockDamageEnabled = false;
        this.noAfkEnabled = false;
        this.afkTimeMs = 0L;
        this.lastAfkTimeMs = 0L;
        this.afkTimeEpoch = 0L;
        this.lastPlayerTick = class_156.method_658();
        this.lastMovementTime = class_156.method_658();
        this.lastLookTime = class_156.method_658();
        this.lastAttackTime = class_156.method_658();
        this.lastPlayerListUpdate = -1L;
        this.afkReason = "";
        this.handler = new AfkHandler(this);
    }

    public static AfkPlayer init(@Nonnull class_3222 player) {
        return new AfkPlayer(player);
    }

    public AfkHandler getHandler() {
        if (this.handler == null) {
            this.handler = new AfkHandler(this);
        }
        return this.handler;
    }

    public class_3222 getPlayer() {
        return this.player;
    }

    public int getEntityId() {
        return this.entityId;
    }

    public String getName() {
        return this.player.method_5477().getString();
    }

    public boolean isAfk() {
        return this.afkEnabled;
    }

    public boolean isDamageEnabled() {
        return this.damageEnabled;
    }

    public boolean isLockDamageEnabled() {
        return this.lockDamageEnabled;
    }

    public boolean isNoAfkEnabled() {
        return this.noAfkEnabled;
    }

    public long getLastPlayerTick() {
        return this.lastPlayerTick;
    }

    public long getAfkTimeMs() {
        return this.afkTimeMs;
    }

    public long getAfkTimeEpoch() {
        return this.afkTimeEpoch;
    }

    public long getLastAfkTimeMs() {
        if (this.lastAfkTimeMs <= 0L) {
            this.lastAfkTimeMs = class_156.method_658();
        }
        return this.lastAfkTimeMs;
    }

    public long getLastMovementTime() {
        return this.lastMovementTime;
    }

    public void setLastMovementTime(long lastMovementTime) {
        this.lastMovementTime = lastMovementTime;
    }

    public long getLastLookTime() {
        return this.lastLookTime;
    }

    public void setLastLookTime(long lastLookTime) {
        this.lastLookTime = lastLookTime;
    }

    public long getLastAttackTime() {
        return this.lastAttackTime;
    }

    public void setLastAttackTime(long lastAttackTime) {
        this.lastAttackTime = lastAttackTime;
    }

    public long getLastPlayerListUpdate() {
        return this.lastPlayerListUpdate;
    }

    public void setLastPlayerListUpdate(long lastPlayerListUpdate) {
        this.lastPlayerListUpdate = lastPlayerListUpdate;
    }

    public DurationFormat getDurationType() {
        DurationFormat format = DurationFormat.fromStringStatic((String)ConfigWrap.mess().duration.option.getName());
        if (format != null) {
            return format;
        }
        ConfigWrap.mess().duration.option = DurationFormat.PRETTY;
        return DurationFormat.REGULAR;
    }

    public TimeFormat getTimeDateType() {
        TimeFormat format = TimeFormat.fromStringStatic((String)ConfigWrap.mess().timeDate.option.getName());
        if (format != null) {
            return format;
        }
        ConfigWrap.mess().timeDate.option = TimeFormat.REGULAR;
        return TimeFormat.REGULAR;
    }

    public DurationFormat getDurationTypeForPlaceholder() {
        DurationFormat format = DurationFormat.fromStringStatic((String)ConfigWrap.place().duration.option.getName());
        if (format != null) {
            return format;
        }
        ConfigWrap.place().duration.option = DurationFormat.REGULAR;
        return DurationFormat.REGULAR;
    }

    public TimeFormat getTimeDateTypeForPlaceholder() {
        TimeFormat format = TimeFormat.fromStringStatic((String)ConfigWrap.place().timeDate.option.getName());
        if (format != null) {
            return format;
        }
        ConfigWrap.place().timeDate.option = TimeFormat.REGULAR;
        return TimeFormat.REGULAR;
    }

    public String getAfkDurationString() {
        return this.getDurationType().format(class_156.method_658() - this.getAfkTimeMs(), ConfigWrap.mess().duration.customFormat);
    }

    public String getAfkTimeString() {
        return this.getTimeDateType().formatTo(this.getAfkTimeEpoch(), ConfigWrap.mess().timeDate.customFormat);
    }

    public String getAfkDurationStringForPlaceholder() {
        return this.getDurationTypeForPlaceholder().format(class_156.method_658() - this.getAfkTimeMs(), ConfigWrap.place().duration.customFormat);
    }

    public String getAfkTimeStringForPlaceholder() {
        return this.getTimeDateTypeForPlaceholder().formatTo(this.getAfkTimeEpoch(), ConfigWrap.place().timeDate.customFormat);
    }

    public String getAfkDurationFormat() {
        return this.getDurationType().getFormatString();
    }

    public String getAfkTimeFormat() {
        return this.getTimeDateType().getFormatString();
    }

    public String getAfkDurationFormatForPlaceholder() {
        return this.getDurationTypeForPlaceholder().getFormatString();
    }

    public String getAfkTimeFormatForPlaceholder() {
        return this.getTimeDateTypeForPlaceholder().getFormatString();
    }

    public String getAfkReason() {
        return this.afkReason;
    }

    public void setAfk(boolean toggle) {
        if (this.afkEnabled && !toggle) {
            this.lastAfkTimeMs = class_156.method_658();
        }
        this.setLastPlayerListUpdate(-1L);
        this.afkEnabled = toggle;
    }

    public void setDamageEnabled(boolean toggle) {
        this.damageEnabled = toggle;
    }

    public void setLockDamageEnabled(boolean toggle) {
        this.lockDamageEnabled = toggle;
    }

    public void setNoAfkEnabled(boolean toggle) {
        this.noAfkEnabled = toggle;
    }

    public void setAfkReason(String reason) {
        this.afkReason = reason;
    }

    public void setAfkTimeMs(long time) {
        this.afkTimeMs = time;
        this.afkTimeEpoch = time > 0L ? ZonedDateTime.now().toInstant().toEpochMilli() : 0L;
    }

    public boolean shouldBeAfk() {
        long now = class_156.method_658();
        long lastMovement = now - this.getLastMovementTime();
        long lastLook = now - this.getLastLookTime();
        long lastAttack = now - this.getLastAttackTime();
        long lastTick = now - this.lastPlayerTick;
        long lastAction = now - this.player.method_14219();
        long limit = (long)ConfigWrap.pack().timeoutSeconds * 1000L;
        int weight = 0;
        if (lastMovement > limit) {
            ++weight;
        }
        if (lastLook > limit) {
            ++weight;
        }
        if (lastAttack > limit) {
            ++weight;
        }
        if (lastAction > limit) {
            ++weight;
        }
        if (weight > 1) {
            LOGGER.debug("shouldBeAfk(): m: {}, l: {}, A: {}, lA: {}, T: {} [timeout: {} (s) // weight {}]", new Object[]{lastMovement, lastLook, lastAttack, lastAction, lastTick, ConfigWrap.pack().timeoutSeconds, weight});
        }
        return weight > 2;
    }

    public boolean shouldIgnoreAttacks() {
        long now = class_156.method_658();
        long lastMovement = now - this.getLastMovementTime();
        long lastLook = now - this.getLastLookTime();
        long lastAttack = now - this.getLastAttackTime();
        long limit = (long)ConfigWrap.pack().timeoutSeconds * 1000L;
        if (ConfigWrap.pack().ignoreAttacks) {
            return lastMovement > limit && lastLook > limit && lastAttack < limit;
        }
        return false;
    }

    public void tickPlayer(long time) {
        this.lastPlayerTick = time;
    }

    public AfkPlayer setPlayer(@Nonnull class_3222 player) {
        this.player = player;
        this.entityId = player.method_5628();
        return this;
    }

    public boolean matches(@Nonnull class_3222 player) {
        return player.method_5628() == this.entityId || this.player.method_5477().equals((Object)player.method_5477()) || this.player.equals((Object)player);
    }

    public void clearAfkValues() {
        this.afkTimeMs = 0L;
        this.lastAfkTimeMs = 0L;
        this.lastPlayerListUpdate = -1L;
        this.afkReason = "";
    }

    public void reset() {
        this.handler.reset();
        this.afkEnabled = false;
        this.damageEnabled = true;
        this.lockDamageEnabled = false;
        this.noAfkEnabled = false;
        this.lastPlayerTick = 0L;
        this.lastMovementTime = 0L;
        this.lastLookTime = 0L;
        this.lastAttackTime = 0L;
        this.clearAfkValues();
    }
}

