/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.shatterbyte.clavis.common.data;

import com.mojang.serialization.Codec;
import java.util.stream.IntStream;
import net.minecraft.class_156;
import net.minecraft.class_1923;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_3532;

public class Box {
    public static final Codec<Box> CODEC = Codec.INT_STREAM.comapFlatMap(intStream -> class_156.method_29190((IntStream)intStream, (int)6).map(is -> new Box(is[0], is[1], is[2], is[3], is[4], is[5])), box -> IntStream.of(box.minX, box.minY, box.minZ, box.maxX, box.maxY, box.maxZ)).stable();
    public final int minX;
    public final int minY;
    public final int minZ;
    public final int maxX;
    public final int maxY;
    public final int maxZ;

    public Box(int x1, int y1, int z1, int x2, int y2, int z2) {
        this.minX = Math.min(x1, x2);
        this.minY = Math.min(y1, y2);
        this.minZ = Math.min(z1, z2);
        this.maxX = Math.max(x1, x2);
        this.maxY = Math.max(y1, y2);
        this.maxZ = Math.max(z1, z2);
    }

    public Box(class_2382 block) {
        this(block, block);
    }

    public Box(class_2382 start, class_2382 end) {
        this(start.method_10263(), start.method_10264(), start.method_10260(), end.method_10263(), end.method_10264(), end.method_10260());
    }

    public boolean isInside(class_2382 block) {
        int x = block.method_10263();
        int y = block.method_10264();
        int z = block.method_10260();
        return this.minX <= x && x <= this.maxX && this.minY <= y && y <= this.maxY && this.minZ <= z && z <= this.maxZ;
    }

    public boolean intersectsChunk(class_1923 pos) {
        int minX = pos.method_8326();
        int maxX = pos.method_8327();
        int minZ = pos.method_8328();
        int maxZ = pos.method_8329();
        return this.minX <= maxX && this.maxX >= minX && this.minZ <= maxZ && this.maxZ >= minZ;
    }

    public class_238 getAABB() {
        return new class_238((double)this.minX, (double)this.minY, (double)this.minZ, (double)(this.maxX + 1), (double)(this.maxY + 1), (double)(this.maxZ + 1));
    }

    public class_243 getCenter() {
        return new class_243(class_3532.method_16436((double)0.5, (double)this.minX, (double)(this.maxX + 1)), class_3532.method_16436((double)0.5, (double)this.minY, (double)(this.maxY + 1)), class_3532.method_16436((double)0.5, (double)this.minZ, (double)(this.maxZ + 1)));
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Box)) {
            return false;
        }
        Box other = (Box)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.minX != other.minX) {
            return false;
        }
        if (this.minY != other.minY) {
            return false;
        }
        if (this.minZ != other.minZ) {
            return false;
        }
        if (this.maxX != other.maxX) {
            return false;
        }
        if (this.maxY != other.maxY) {
            return false;
        }
        return this.maxZ == other.maxZ;
    }

    protected boolean canEqual(Object other) {
        return other instanceof Box;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.minX;
        result = result * 59 + this.minY;
        result = result * 59 + this.minZ;
        result = result * 59 + this.maxX;
        result = result * 59 + this.maxY;
        result = result * 59 + this.maxZ;
        return result;
    }
}

