/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.shatterbyte.clavis.common.data;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import dev.architectury.networking.NetworkManager;
import it.hurts.octostudios.octolib.OctoLib;
import it.hurts.shatterbyte.clavis.common.Clavis;
import it.hurts.shatterbyte.clavis.common.client.render.LockWorldRenderer;
import it.hurts.shatterbyte.clavis.common.data.Lock;
import it.hurts.shatterbyte.clavis.common.network.packet.AddLockPacket;
import it.hurts.shatterbyte.clavis.common.network.packet.RemoveLockPacket;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.class_18;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_3218;
import net.minecraft.class_7225;
import net.minecraft.class_8710;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class ClavisSavedData
extends class_18 {
    private static final String DATA_NAME = "clavis_locks";
    public static final class_18.class_8645<ClavisSavedData> FACTORY = new class_18.class_8645(ClavisSavedData::new, ClavisSavedData::load, null);
    private final class_2487 dataTag = new class_2487();
    private final Set<Lock> locks = new HashSet<Lock>();
    private final Multimap<class_1923, Lock> lockLookupMap = HashMultimap.create();

    public static ClavisSavedData get(class_3218 level) {
        return (ClavisSavedData)level.method_17983().method_17924(FACTORY, DATA_NAME);
    }

    private ClavisSavedData() {
    }

    @NotNull
    public class_2487 method_75(class_2487 tag, class_7225.class_7874 registries) {
        tag.method_10543(this.dataTag);
        DataResult result = Lock.SET_CODEC.encodeStart((DynamicOps)class_2509.field_11560, this.locks);
        result.resultOrPartial(arg_0 -> ((Logger)OctoLib.LOGGER).warn(arg_0)).ifPresent(encodedTag -> tag.method_10566("Locks", encodedTag));
        return tag;
    }

    private static ClavisSavedData load(class_2487 tag, class_7225.class_7874 registries) {
        ClavisSavedData data = new ClavisSavedData();
        data.dataTag.method_10543(tag);
        if (tag.method_10573("Locks", 9)) {
            DataResult result = Lock.SET_CODEC.parse((DynamicOps)class_2509.field_11560, (Object)tag.method_10580("Locks"));
            result.resultOrPartial(arg_0 -> ((Logger)OctoLib.LOGGER).warn(arg_0)).ifPresent(list -> {
                data.locks.addAll((Collection<Lock>)list);
                list.forEach(data::indexLock);
            });
        }
        return data;
    }

    private void indexLock(Lock lock) {
        int minChunkX = lock.box.minX >> 4;
        int maxChunkX = lock.box.maxX >> 4;
        int minChunkZ = lock.box.minZ >> 4;
        int maxChunkZ = lock.box.maxZ >> 4;
        for (int cx = minChunkX; cx <= maxChunkX; ++cx) {
            for (int cz = minChunkZ; cz <= maxChunkZ; ++cz) {
                this.lockLookupMap.put((Object)new class_1923(cx, cz), (Object)lock);
            }
        }
    }

    public void addLock(Lock lock, class_3218 level) {
        this.locks.add(lock);
        int minChunkX = lock.box.minX >> 4;
        int maxChunkX = lock.box.maxX >> 4;
        int minChunkZ = lock.box.minZ >> 4;
        int maxChunkZ = lock.box.maxZ >> 4;
        HashSet toSend = new HashSet();
        for (int cx = minChunkX; cx <= maxChunkX; ++cx) {
            int cz = minChunkZ;
            while (cz <= maxChunkZ) {
                this.lockLookupMap.put((Object)new class_1923(cx, cz), (Object)lock);
                int finalCx = cx;
                int finalCz = cz++;
                toSend.addAll(level.method_18766(player -> player.method_52372().method_52356(finalCx, finalCz)));
            }
        }
        if (!Clavis.CONFIG.isDisableLockRendering()) {
            NetworkManager.sendToPlayers(toSend, (class_8710)new AddLockPacket(lock));
        }
        this.method_80();
    }

    public void removeLock(Lock lock, class_3218 level) {
        this.locks.remove(lock);
        int minChunkX = lock.box.minX >> 4;
        int maxChunkX = lock.box.maxX >> 4;
        int minChunkZ = lock.box.minZ >> 4;
        int maxChunkZ = lock.box.maxZ >> 4;
        HashSet toSend = new HashSet();
        for (int cx = minChunkX; cx <= maxChunkX; ++cx) {
            int cz = minChunkZ;
            while (cz <= maxChunkZ) {
                this.lockLookupMap.remove((Object)new class_1923(cx, cz), (Object)lock);
                int finalCx = cx;
                int finalCz = cz++;
                toSend.addAll(level.method_18766(player -> player.method_52372().method_52356(finalCx, finalCz)));
            }
        }
        NetworkManager.sendToPlayers(toSend, (class_8710)new RemoveLockPacket(lock));
        this.method_80();
    }

    public List<Lock> getLocksAt(class_2338 pos) {
        class_1923 chunkPos = new class_1923(pos);
        return new ArrayList<Lock>(this.lockLookupMap.get((Object)chunkPos).stream().filter(lock -> lock.box.isInside((class_2382)pos)).toList());
    }

    public List<Lock> getLocksAt(class_1923 chunkPos) {
        return new ArrayList<Lock>(this.lockLookupMap.get((Object)chunkPos));
    }

    public static boolean isLocked(class_2338 pos, class_1937 level) {
        if (level instanceof class_3218) {
            class_3218 serverLevel = (class_3218)level;
            ClavisSavedData data = ClavisSavedData.get(serverLevel);
            return !data.getLocksAt(pos).isEmpty();
        }
        return LockWorldRenderer.FOR_RENDERING.stream().anyMatch(lock -> lock.getBox().isInside((class_2382)pos));
    }
}

