/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.shatterbyte.clavis.common.minigame.rule;

import it.hurts.shatterbyte.clavis.common.client.ClientMinigameTypeRegistry;
import it.hurts.shatterbyte.clavis.common.client.screen.widget.AbstractMinigameWidget;
import it.hurts.shatterbyte.clavis.common.client.screen.widget.GearMechanismWidget;
import it.hurts.shatterbyte.clavis.common.client.screen.widget.MirrorWidget;
import it.hurts.shatterbyte.clavis.common.minigame.rule.EndRules;
import it.hurts.shatterbyte.clavis.common.minigame.rule.OverworldRules;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraft.class_2960;
import org.apache.logging.log4j.util.Cast;

public class Rule<T extends AbstractMinigameWidget<?>> {
    private static final Map<class_2960, Map<class_2960, Rule<?>>> REGISTRY = new HashMap();
    class_2960 id;
    BiConsumer<T, Boolean> onClick;
    BiConsumer<T, Long> everyTick;
    Consumer<T> onCreate;

    public Rule(class_2960 id) {
        this.id = id;
    }

    protected Rule<T> withOnClick(BiConsumer<T, Boolean> onClick) {
        this.onClick = onClick;
        return this;
    }

    protected Rule<T> withEveryTick(BiConsumer<T, Long> everyTick) {
        this.everyTick = everyTick;
        return this;
    }

    protected Rule<T> withOnCreate(Consumer<T> onCreate) {
        this.onCreate = onCreate;
        return this;
    }

    public String getLanguageKey(class_2960 minigameType) {
        return "rule." + this.id.method_12836() + "." + minigameType.method_12832() + "." + this.id.method_12832();
    }

    public String getLanguageKey(class_2960 minigameType, String key) {
        return this.getLanguageKey(minigameType) + "." + key;
    }

    protected Rule<T> register(Class<T> clazz) {
        class_2960 minigameType = ClientMinigameTypeRegistry.getId(clazz);
        REGISTRY.putIfAbsent(minigameType, new HashMap());
        REGISTRY.get(minigameType).put(this.id, this);
        return this;
    }

    public static <W extends AbstractMinigameWidget<?>> Collection<Rule<W>> getRegisteredRules(Class<W> clazz) {
        class_2960 minigameType = ClientMinigameTypeRegistry.getId(clazz);
        return (Collection)Cast.cast(REGISTRY.get(minigameType).values());
    }

    public static <W extends AbstractMinigameWidget<?>> Rule<W> getRegisteredRule(class_2960 id) {
        return (Rule)Cast.cast(REGISTRY.get(id));
    }

    public static void registerAll() {
        OverworldRules.FAKE_PIN.register(GearMechanismWidget.class);
        OverworldRules.MOOD_SWINGS.register(GearMechanismWidget.class);
        OverworldRules.ROTATE_GEAR.register(GearMechanismWidget.class);
        OverworldRules.FULL_THROTTLE.register(GearMechanismWidget.class);
        OverworldRules.SELF_DESTRUCTION.register(GearMechanismWidget.class);
        EndRules.ROTATE.register(MirrorWidget.class);
        EndRules.SWAP.register(MirrorWidget.class);
        EndRules.SHOCKWAVE.register(MirrorWidget.class);
        EndRules.FAKE.register(MirrorWidget.class);
        EndRules.HOT_METEOR.register(MirrorWidget.class);
    }

    public class_2960 getId() {
        return this.id;
    }

    public BiConsumer<T, Boolean> getOnClick() {
        return this.onClick;
    }

    public BiConsumer<T, Long> getEveryTick() {
        return this.everyTick;
    }

    public Consumer<T> getOnCreate() {
        return this.onCreate;
    }
}

