/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.shatterbyte.clavis.common.data;

import it.hurts.shatterbyte.clavis.common.Clavis;
import it.hurts.shatterbyte.clavis.common.data.ValueModifier;
import it.hurts.shatterbyte.clavis.common.registry.ValueModifierRegistry;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiFunction;
import net.minecraft.world.item.ItemStack;

public class ItemValues {
    public static final BiFunction<ItemStack, Double, Double> DEFAULT_FUNCTION = (itemStack, value) -> {
        double finalValue = value;
        for (ValueModifier modifier : ValueModifierRegistry.MODIFIERS.values()) {
            finalValue *= modifier.apply((ItemStack)itemStack);
        }
        return finalValue * (double)itemStack.getCount();
    };

    public static double getValue(ItemStack stack) {
        Map<String, Double> tags = Clavis.CONFIG.getValuableTags();
        AtomicReference<Double> value = new AtomicReference<Double>(0.0);
        stack.getTags().forEach(tagKey -> value.set((Double)value.get() + tags.getOrDefault(tagKey.location().toString(), 0.0)));
        if (value.get() <= 0.0) {
            return DEFAULT_FUNCTION.apply(stack, Clavis.CONFIG.getDefaultBaseItemValue());
        }
        return DEFAULT_FUNCTION.apply(stack, value.get());
    }
}

