/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.shatterbyte.clavis.common.network.packet;

import dev.architectury.networking.NetworkManager;
import it.hurts.octostudios.octolib.module.network.Packet;
import it.hurts.shatterbyte.clavis.common.Clavis;
import it.hurts.shatterbyte.clavis.common.LockManager;
import it.hurts.shatterbyte.clavis.common.data.Lock;
import it.hurts.shatterbyte.clavis.common.data.LootUtils;
import it.hurts.shatterbyte.clavis.common.network.packet.OpenLockpickingPacket;
import it.hurts.shatterbyte.clavis.common.registry.ItemRegistry;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class CheckIfLockedPacket
extends Packet {
    public static final CustomPacketPayload.Type<CheckIfLockedPacket> TYPE = Packet.createType((String)"clavis", (String)"check_locked");
    public static final StreamCodec<RegistryFriendlyByteBuf, CheckIfLockedPacket> STREAM_CODEC = Packet.createCodec(CheckIfLockedPacket::write, CheckIfLockedPacket::new);
    BlockPos blockPos;
    InteractionHand hand;

    public CheckIfLockedPacket(RegistryFriendlyByteBuf buf) {
        this.blockPos = buf.readBlockPos();
        this.hand = (InteractionHand)buf.readEnum(InteractionHand.class);
    }

    public CheckIfLockedPacket(BlockPos blockPos, InteractionHand hand) {
        this.blockPos = blockPos;
        this.hand = hand;
    }

    public void write(RegistryFriendlyByteBuf buf) {
        buf.writeBlockPos(this.blockPos);
        buf.writeEnum((Enum)this.hand);
    }

    protected void handleServer(NetworkManager.PacketContext packetContext) {
        ServerPlayer player = (ServerPlayer)packetContext.getPlayer();
        List<Lock> locks = LockManager.getLocksAt(player.serverLevel(), player, this.blockPos);
        if (locks.isEmpty()) {
            return;
        }
        ItemStack itemInHand = player.getItemInHand(this.hand);
        if (itemInHand.is((Item)ItemRegistry.LOCK_PICK.get())) {
            LootUtils.unlockWithQuality(player.serverLevel(), player, this.blockPos, locks.getFirst(), Clavis.CONFIG.getStartingQuality());
            itemInHand.shrink(1);
            return;
        }
        NetworkManager.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new OpenLockpickingPacket(this.blockPos, locks.getFirst()));
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

