/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.shatterbyte.clavis.common.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import it.hurts.shatterbyte.clavis.common.Clavis;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;

public class LockModel
extends Model {
    private final ModelPart main;
    private boolean glow;

    public static ResourceLocation getTexture(ResourceLocation minigameType) {
        return Clavis.path(minigameType.getNamespace(), "textures/model/" + minigameType.getPath() + "/lock.png");
    }

    public LockModel(boolean glow) {
        super(glow ? RenderType::entityCutout : RenderType::entityCutoutNoCull);
        this.main = LockModel.createBodyLayer(glow).bakeRoot().getChild("main");
        this.glow = glow;
    }

    public static LayerDefinition createBodyLayer(boolean glow) {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition main = partdefinition.addOrReplaceChild("main", CubeListBuilder.create(), PartPose.offsetAndRotation((float)0.0f, (float)23.4f, (float)-0.5f, (float)0.0f, (float)1.5708f, (float)0.0f));
        if (glow) {
            main.addOrReplaceChild("glow", CubeListBuilder.create().texOffs(0, 20).addBox(-2.5f, 0.0f, -1.0f, 5.0f, 4.0f, 2.0f, new CubeDeformation(-4.5f)).texOffs(0, 0).addBox(-3.5f, -4.0f, -2.0f, 7.0f, 5.0f, 4.0f, new CubeDeformation(-4.5f)), PartPose.offset((float)-0.5f, (float)-4.0f, (float)0.0f));
        } else {
            main.addOrReplaceChild("layer", CubeListBuilder.create().texOffs(0, 10).addBox(-1.5f, -0.25f, -3.0f, 3.0f, 4.0f, 6.0f, new CubeDeformation(0.25f)).texOffs(14, 20).addBox(-0.5f, -3.25f, -2.0f, 1.0f, 3.0f, 4.0f, new CubeDeformation(0.25f)), PartPose.offset((float)-0.5f, (float)-3.75f, (float)0.0f));
            main.addOrReplaceChild("model", CubeListBuilder.create().texOffs(18, 10).addBox(-1.5f, 0.625f, -3.0f, 3.0f, 4.0f, 6.0f, new CubeDeformation(0.0f)).texOffs(22, 5).addBox(-0.5f, -1.375f, -2.0f, 1.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(22, 0).addBox(-0.5f, -2.375f, -2.0f, 1.0f, 1.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(24, 20).addBox(-0.5f, -1.375f, 1.0f, 1.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-0.5f, (float)-4.625f, (float)0.0f));
        }
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer buffer, int packedLight, int packedOverlay, int color) {
        poseStack.pushPose();
        poseStack.translate(0.0f, 1.0f, 0.0f);
        poseStack.scale(-1.0f, -1.0f, 1.0f);
        this.main.render(poseStack, buffer, packedLight, packedOverlay, color);
        poseStack.popPose();
    }
}

