/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.shatterbyte.clavis.common.client.render;

import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import it.hurts.shatterbyte.clavis.common.client.model.LockModel;
import it.hurts.shatterbyte.clavis.common.data.Box;
import it.hurts.shatterbyte.clavis.common.data.Lock;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.client.Camera;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Vector3f;

public class LockWorldRenderer {
    public static final Function<ResourceLocation, RenderType> LOCK_TYPE = minigameType -> RenderType.entityCutoutNoCull((ResourceLocation)LockModel.getTexture(minigameType));
    public static final Function<ResourceLocation, RenderType> GLOW_TYPE = minigameType -> RenderType.create((String)"clavis_outline", (VertexFormat)DefaultVertexFormat.NEW_ENTITY, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)1536, (boolean)true, (boolean)false, (RenderType.CompositeState)RenderType.CompositeState.builder().setTransparencyState(RenderStateShard.ADDITIVE_TRANSPARENCY).setShaderState(RenderStateShard.RENDERTYPE_ENTITY_TRANSLUCENT_EMISSIVE_SHADER).setLightmapState(RenderStateShard.NO_LIGHTMAP).setOutputState(RenderStateShard.MAIN_TARGET).setColorLogicState(RenderStateShard.NO_COLOR_LOGIC).setDepthTestState(RenderStateShard.LEQUAL_DEPTH_TEST).setCullState(RenderStateShard.CULL).setOverlayState(RenderStateShard.OVERLAY).setWriteMaskState(new RenderStateShard.WriteMaskStateShard(true, true)).setTextureState((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(LockModel.getTexture(minigameType), false, false)).createCompositeState(false));
    private static final ResourceLocation CHAIN_TEXTURE = ResourceLocation.withDefaultNamespace((String)"textures/block/chain.png");
    public static final RenderType CHAIN_TYPE = RenderType.entityCutoutNoCull((ResourceLocation)CHAIN_TEXTURE);
    public static final Set<Lock> FOR_RENDERING = new HashSet<Lock>();
    public static final LockModel LOCK = new LockModel(false);
    public static final LockModel GLOW = new LockModel(true);
    public static final float f = 0.0625f;
    public static final float d = 0.06629f;
    public static final float THREE_SIXTEENTH = 0.1875f;

    public static void render(Camera camera, Matrix4f modelViewMatrix, PoseStack poseStack, DeltaTracker partialTick, MultiBufferSource multiBufferSource, ClientLevel level, Frustum frustum) {
        if (FOR_RENDERING.isEmpty()) {
            return;
        }
        List<LockRenderData> dataList = FOR_RENDERING.stream().filter(lock -> {
            Box b = lock.getBox();
            Vec3 min = new Vec3((double)b.minX, (double)b.minY, (double)b.minZ);
            Vec3 max = new Vec3((double)(b.maxX + 1), (double)(b.maxY + 1), (double)(b.maxZ + 1));
            return frustum.isVisible(new AABB(min, max.add(0.0, 1.0, 0.0)));
        }).map(lock -> {
            BlockPos blockPos;
            VoxelShape shape;
            Box b = lock.getBox();
            Vec3 max = new Vec3((double)(b.maxX + 1), (double)(b.maxY + 1), (double)(b.maxZ + 1));
            Vec3 min = new Vec3((double)b.minX, (double)b.minY, (double)b.minZ);
            if (max.subtract(min).equals((Object)new Vec3(1.0, 1.0, 1.0)) && !(shape = level.getBlockState(blockPos = new BlockPos((int)min.x, (int)min.y, (int)min.z)).getShape((BlockGetter)level, blockPos)).isEmpty()) {
                AABB bounds = shape.bounds();
                min = bounds.getMinPosition().add(Vec3.atLowerCornerOf((Vec3i)blockPos));
                max = bounds.getMaxPosition().add(Vec3.atLowerCornerOf((Vec3i)blockPos));
            }
            AABB renderBox = new AABB(min, max);
            Vec3 center = new Vec3(Mth.lerp((double)0.5, (double)min.x, (double)max.x), max.y + 0.5, Mth.lerp((double)0.5, (double)min.z, (double)max.z));
            BlockPos pos = new BlockPos(Mth.floor((double)center.x), Mth.floor((double)center.y), Mth.floor((double)center.z));
            int sky = level.getBrightness(LightLayer.SKY, pos);
            int block = level.getBrightness(LightLayer.BLOCK, pos);
            int light = LightTexture.pack((int)block, (int)sky);
            float hash = new Random(lock.getSeed()).nextFloat() * (float)Math.PI;
            float ticks = ((float)level.getGameTime() + partialTick.getGameTimeDeltaPartialTick(true)) / 10.0f + hash;
            VoxelShape atLockPos = level.getBlockState(pos).getShape((BlockGetter)level, pos);
            AABB lockAABB = new AABB(center, center).inflate(0.25, 0.5, 0.25);
            return new LockRenderData((Lock)lock, renderBox, center, light, ticks, atLockPos.isEmpty() || !atLockPos.bounds().move(pos).intersects(lockAABB), lock.getType((Level)level));
        }).toList();
        Vec3 camPos = camera.getPosition();
        List<ResourceLocation> types = dataList.stream().map(data -> data.minigameType).distinct().toList();
        for (ResourceLocation type : types) {
            VertexConsumer lockBuf = multiBufferSource.getBuffer(LOCK_TYPE.apply(type));
            for (LockRenderData lockRenderData : dataList) {
                if (!lockRenderData.shouldRenderLock || !lockRenderData.minigameType.equals((Object)type)) continue;
                Vec3 subtractedPos = lockRenderData.center.subtract(camPos);
                poseStack.pushPose();
                poseStack.translate(subtractedPos.x, subtractedPos.y + 0.25 + (double)((float)Math.sin(lockRenderData.ticks) * 0.075f), subtractedPos.z);
                poseStack.mulPose(Axis.YP.rotation(lockRenderData.ticks / 2.0f % ((float)Math.PI * 2)));
                LOCK.renderToBuffer(poseStack, lockBuf, lockRenderData.light, OverlayTexture.NO_OVERLAY);
                poseStack.popPose();
            }
            VertexConsumer glowBuf = multiBufferSource.getBuffer(GLOW_TYPE.apply(type));
            for (LockRenderData data3 : dataList) {
                if (!data3.shouldRenderLock || !data3.minigameType.equals((Object)type)) continue;
                Vec3 subtractedPos = data3.center.subtract(camPos);
                int color = data3.lock.getDifficulty() < 0.33f ? -13369566 : (data3.lock.getDifficulty() < 0.66f ? -13312 : -65519);
                poseStack.pushPose();
                poseStack.translate(subtractedPos.x, subtractedPos.y + 0.25 + (double)((float)Math.sin(data3.ticks) * 0.075f), subtractedPos.z);
                poseStack.mulPose(Axis.YP.rotation(data3.ticks / 2.0f % ((float)Math.PI * 2)));
                GLOW.renderToBuffer(poseStack, glowBuf, 0xF000F0, OverlayTexture.NO_OVERLAY, color);
                poseStack.popPose();
            }
        }
        Quaternionf xRot = Axis.XP.rotationDegrees(90.0f);
        Quaternionf zRot = Axis.ZN.rotationDegrees(90.0f);
        VertexConsumer chainBuf = multiBufferSource.getBuffer(CHAIN_TYPE);
        for (LockRenderData lockRenderData : dataList) {
            Vec3 min = lockRenderData.renderBox.getMinPosition().subtract(camPos);
            Vec3 max = lockRenderData.renderBox.getMaxPosition().subtract(camPos);
            float yLen = (float)(max.y - min.y) + 0.125f;
            float xLen = (float)(max.x - min.x) + 0.125f;
            float zLen = (float)(max.z - min.z) + 0.125f;
            int light = lockRenderData.light;
            Vec3 subtractedPos = lockRenderData.center.subtract(camPos);
            LockWorldRenderer.renderChainAt(chainBuf, poseStack, subtractedPos.x, min.y - 0.0625, min.z - (double)0.06629f, null, light, yLen);
            LockWorldRenderer.renderChainAt(chainBuf, poseStack, max.x + (double)0.06629f, min.y - 0.0625, subtractedPos.z, null, light, yLen);
            LockWorldRenderer.renderChainAt(chainBuf, poseStack, min.x - (double)0.06629f, min.y - 0.0625, subtractedPos.z, null, light, yLen);
            LockWorldRenderer.renderChainAt(chainBuf, poseStack, subtractedPos.x, min.y - 0.0625, max.z + (double)0.06629f, null, light, yLen);
            LockWorldRenderer.renderChainAt(chainBuf, poseStack, subtractedPos.x, max.y + (double)0.06629f, min.z - 0.0625, xRot, light, zLen);
            LockWorldRenderer.renderChainAt(chainBuf, poseStack, min.x - 0.0625, max.y + (double)0.06629f, subtractedPos.z, zRot, light, xLen);
            LockWorldRenderer.renderChainAt(chainBuf, poseStack, subtractedPos.x, min.y - (double)0.06629f, min.z - 0.0625, xRot, light, zLen);
            LockWorldRenderer.renderChainAt(chainBuf, poseStack, min.x - 0.0625, min.y - (double)0.06629f, subtractedPos.z, zRot, light, xLen);
        }
    }

    private static void renderChainAt(VertexConsumer buf, PoseStack ps, double x, double y, double z, Quaternionf rotation, int light, float length) {
        ps.pushPose();
        ps.translate(x, y, z);
        if (rotation != null) {
            ps.mulPose(rotation);
        }
        LockWorldRenderer.renderChain(buf, ps, light, length);
        ps.popPose();
    }

    private static void renderChain(VertexConsumer consumer, PoseStack poseStack, int light, float length) {
        float width = 0.1875f;
        poseStack.pushPose();
        poseStack.mulPose(Axis.YP.rotationDegrees(45.0f));
        poseStack.pushPose();
        poseStack.translate(-width / 2.0f, 0.0f, 0.0f);
        Matrix4f matrix = poseStack.last().pose();
        Matrix3f normalMatrix = poseStack.last().normal();
        Vector3f nZ = new Vector3f(0.0f, 0.0f, 1.0f);
        normalMatrix.transform(nZ);
        consumer.addVertex(matrix, 0.0f, 0.0f, 0.0f).setColor(1.0f, 1.0f, 1.0f, 1.0f).setUv(0.0f, 0.0f).setOverlay(OverlayTexture.NO_OVERLAY).setLight(light).setNormal(nZ.x, nZ.y, nZ.z);
        consumer.addVertex(matrix, 0.0f, length, 0.0f).setColor(1.0f, 1.0f, 1.0f, 1.0f).setUv(0.0f, length).setOverlay(OverlayTexture.NO_OVERLAY).setLight(light).setNormal(nZ.x, nZ.y, nZ.z);
        consumer.addVertex(matrix, width, length, 0.0f).setColor(1.0f, 1.0f, 1.0f, 1.0f).setUv(width, length).setOverlay(OverlayTexture.NO_OVERLAY).setLight(light).setNormal(nZ.x, nZ.y, nZ.z);
        consumer.addVertex(matrix, width, 0.0f, 0.0f).setColor(1.0f, 1.0f, 1.0f, 1.0f).setUv(width, 0.0f).setOverlay(OverlayTexture.NO_OVERLAY).setLight(light).setNormal(nZ.x, nZ.y, nZ.z);
        poseStack.popPose();
        poseStack.pushPose();
        poseStack.translate(0.0f, 0.0f, -width / 2.0f);
        matrix = poseStack.last().pose();
        normalMatrix = poseStack.last().normal();
        Vector3f nX = new Vector3f(1.0f, 0.0f, 0.0f);
        normalMatrix.transform(nX);
        consumer.addVertex(matrix, 0.0f, 0.0f, 0.0f).setColor(1.0f, 1.0f, 1.0f, 1.0f).setUv(width, 0.0f).setOverlay(OverlayTexture.NO_OVERLAY).setLight(light).setNormal(nX.x, nX.y, nX.z);
        consumer.addVertex(matrix, 0.0f, length, 0.0f).setColor(1.0f, 1.0f, 1.0f, 1.0f).setUv(width, length).setOverlay(OverlayTexture.NO_OVERLAY).setLight(light).setNormal(nX.x, nX.y, nX.z);
        consumer.addVertex(matrix, 0.0f, length, width).setColor(1.0f, 1.0f, 1.0f, 1.0f).setUv(width * 2.0f, length).setOverlay(OverlayTexture.NO_OVERLAY).setLight(light).setNormal(nX.x, nX.y, nX.z);
        consumer.addVertex(matrix, 0.0f, 0.0f, width).setColor(1.0f, 1.0f, 1.0f, 1.0f).setUv(width * 2.0f, 0.0f).setOverlay(OverlayTexture.NO_OVERLAY).setLight(light).setNormal(nX.x, nX.y, nX.z);
        poseStack.popPose();
        poseStack.popPose();
    }

    public static void clear() {
        FOR_RENDERING.clear();
    }

    private static class LockRenderData {
        final Vec3 center;
        final int light;
        final float ticks;
        final Lock lock;
        final AABB renderBox;
        final boolean shouldRenderLock;
        final ResourceLocation minigameType;

        LockRenderData(Lock lock, AABB renderBox, Vec3 center, int light, float ticks, boolean shouldRenderLock, ResourceLocation minigameType) {
            this.lock = lock;
            this.center = center;
            this.light = light;
            this.ticks = ticks;
            this.renderBox = renderBox;
            this.shouldRenderLock = shouldRenderLock;
            this.minigameType = minigameType;
        }
    }
}

