/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.shatterbyte.clavis.common.client.screen.widget;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.math.Axis;
import it.hurts.octostudios.octolib.client.animation.Tween;
import it.hurts.octostudios.octolib.client.animation.easing.EaseType;
import it.hurts.octostudios.octolib.client.animation.easing.TransitionType;
import it.hurts.octostudios.octolib.util.OctoColor;
import it.hurts.shatterbyte.clavis.common.Clavis;
import it.hurts.shatterbyte.clavis.common.client.particle.MouseTeleportUIParticle;
import it.hurts.shatterbyte.clavis.common.client.particle.ShockwaveUIParticle;
import it.hurts.shatterbyte.clavis.common.client.screen.LockpickingScreen;
import it.hurts.shatterbyte.clavis.common.client.screen.widget.AbstractMinigameWidget;
import it.hurts.shatterbyte.clavis.common.client.screen.widget.MeteorWidget;
import it.hurts.shatterbyte.clavis.common.minigame.Minigame;
import it.hurts.shatterbyte.clavis.common.mixin.MouseHandlerAccessor;
import it.hurts.shatterbyte.clavis.common.registry.SoundEventRegistry;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import org.joml.Vector2d;
import org.joml.Vector2dc;

public class MirrorWidget
extends AbstractMinigameWidget<MeteorWidget> {
    public static final ResourceLocation ID = Clavis.path("mirror");
    public static final ResourceLocation BACKGROUND = Clavis.path("textures/minigame/mirror/black_circle.png");
    public static final ResourceLocation FRAME = Clavis.path("textures/minigame/mirror/frame.png");
    public static final ResourceLocation ROTATING_PART = Clavis.path("textures/minigame/mirror/rotating_part.png");
    public static final ResourceLocation MIRROR = Clavis.path("textures/minigame/mirror/mirror.png");
    public static final ResourceLocation BACK_CLOUDS = Clavis.path("textures/minigame/mirror/background_back_clouds.png");
    public static final ResourceLocation MIDDLE_CLOUDS = Clavis.path("textures/minigame/mirror/background_middle_clouds.png");
    public static final ResourceLocation TOP_CLOUDS = Clavis.path("textures/minigame/mirror/background_top_clouds.png");
    public static final ResourceLocation CROSSHAIR = Clavis.path("textures/minigame/mirror/crosshair.png");
    public static final ResourceLocation CROSSHAIR_SQUARE = Clavis.path("textures/minigame/mirror/crosshair_square.png");
    float oldBackgroundRotation;
    float backgroundRotation;
    OctoColor gameColor = OctoColor.WHITE;
    Tween crosshairTween = Tween.create();
    float crosshairScale = 1.0f;
    boolean playing = true;
    Tween mainTween = Tween.create();
    int rotationDir = 1;
    double rot;
    Tween rotationTween = Tween.create();

    public MirrorWidget() {
        super(0, 0, 192, 192, (LockpickingScreen)Minecraft.getInstance().screen);
    }

    @Override
    protected void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        float partial = Minecraft.getInstance().getTimer().getGameTimeDeltaPartialTick(false);
        Vector2d center = new Vector2d((double)((float)this.getX() + (float)this.width / 2.0f), (double)((float)this.getY() + (float)this.height / 2.0f));
        double guiScale = Minecraft.getInstance().getWindow().getGuiScale();
        double i = Minecraft.getInstance().mouseHandler.xpos() / guiScale;
        double j = Minecraft.getInstance().mouseHandler.ypos() / guiScale;
        Vector2d mousePos = MirrorWidget.mirrorPosition(new Vector2d(i, j), center, this.rot);
        Vector2d actualMousePos = new Vector2d(i, j);
        actualMousePos.sub((Vector2dc)center);
        if (actualMousePos.lengthSquared() > 7396.0) {
            actualMousePos.normalize(86.0);
        }
        RenderSystem.setShaderColor((float)this.gameColor.r(), (float)this.gameColor.g(), (float)this.gameColor.b(), (float)this.gameColor.a());
        RenderSystem.enableBlend();
        guiGraphics.pose().pushPose();
        guiGraphics.blit(BACKGROUND, this.getX(), this.getY(), 192, 192, 0.0f, 0.0f, 192, 192, 192, 192);
        this.drawClouds(guiGraphics, partialTick, BACK_CLOUDS, 1.5f, actualMousePos.x, actualMousePos.y);
        this.drawClouds(guiGraphics, partialTick, MIDDLE_CLOUDS, 2.0f, actualMousePos.x, actualMousePos.y);
        this.drawClouds(guiGraphics, partialTick, TOP_CLOUDS, 3.0f, actualMousePos.x, actualMousePos.y);
        guiGraphics.pose().popPose();
        super.renderWidget(guiGraphics, mouseX, mouseY, partialTick);
        guiGraphics.pose().pushPose();
        guiGraphics.pose().translate(mousePos.x, mousePos.y, 0.0);
        guiGraphics.pose().scale(this.crosshairScale, this.crosshairScale, 1.0f);
        guiGraphics.blit(CROSSHAIR, -8, -8, 17, 17, 0.0f, 0.0f, 17, 17, 17, 17);
        guiGraphics.pose().popPose();
        guiGraphics.pose().pushPose();
        guiGraphics.pose().translate(0.0f, 0.0f, 2.0f);
        guiGraphics.blit(FRAME, this.getX(), this.getY(), 192, 192, 0.0f, 0.0f, 192, 192, 192, 192);
        guiGraphics.pose().popPose();
        guiGraphics.pose().pushPose();
        guiGraphics.pose().translate((float)this.getX() + (float)this.width / 2.0f, (float)this.getY() + (float)this.height / 2.0f, 0.0f);
        guiGraphics.pose().mulPose(Axis.ZP.rotation((float)this.rot));
        guiGraphics.pose().translate((float)(-this.width) / 2.0f - (float)this.getX(), (float)(-this.height) / 2.0f - (float)this.getY(), 1.0f);
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
        guiGraphics.blit(MIRROR, this.getX(), this.getY(), 192, 192, 0.0f, 0.0f, 192, 192, 192, 192);
        RenderSystem.disableBlend();
        guiGraphics.pose().translate(0.0f, 0.0f, 1.0f);
        guiGraphics.blit(ROTATING_PART, this.getX() - 9, (int)((float)this.getY() + (float)this.height / 2.0f - 21.0f), 210, 41, 0.0f, 0.0f, 210, 41, 210, 41);
        guiGraphics.pose().popPose();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableBlend();
    }

    private void drawClouds(GuiGraphics guiGraphics, float partialTick, ResourceLocation topClouds, float speedFactor, double x, double y) {
        guiGraphics.pose().pushPose();
        guiGraphics.pose().translate(-x / 96.0 * (double)(speedFactor - 1.25f), -y / 96.0 * (double)(speedFactor - 1.25f), 0.0);
        guiGraphics.pose().translate((float)this.getX() + (float)this.width / 2.0f, (float)this.getY() + (float)this.height / 2.0f, 0.0f);
        guiGraphics.pose().mulPose(Axis.ZP.rotation(Mth.lerp((float)partialTick, (float)this.oldBackgroundRotation, (float)this.backgroundRotation) * speedFactor));
        guiGraphics.pose().translate((float)(-this.width) / 2.0f - (float)this.getX(), (float)(-this.height) / 2.0f - (float)this.getY(), 0.0f);
        guiGraphics.blit(topClouds, this.getX(), this.getY(), 192, 192, 0.0f, 0.0f, 192, 192, 192, 192);
        guiGraphics.pose().popPose();
    }

    public void playDownSound(SoundManager handler) {
        handler.play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)SoundEvents.ALLAY_HURT, (float)0.5f, (float)0.3f));
    }

    public void regenerateAll() {
        if (this.children().stream().noneMatch(MeteorWidget::isCracked)) {
            return;
        }
        this.children().forEach(MeteorWidget::regenerate);
        Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)((SoundEvent)SoundEventRegistry.METEOR_REGENERATE.get()), (float)0.66f, (float)1.0f));
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (!this.isPlaying()) {
            return false;
        }
        Vector2d realMousePos = new Vector2d(mouseX, mouseY);
        Vector2d center = new Vector2d((double)((float)this.getX() + (float)this.width / 2.0f), (double)((float)this.getY() + (float)this.height / 2.0f));
        if (realMousePos.distanceSquared((Vector2dc)center) > 11664.0) {
            return false;
        }
        Vector2d pos = MirrorWidget.mirrorPosition(realMousePos, new Vector2d((double)((float)this.getX() + (float)this.width / 2.0f), (double)((float)this.getY() + (float)this.height / 2.0f)), this.rot);
        return super.mouseClicked(pos.x, pos.y, button);
    }

    public void onClick(double mouseX, double mouseY) {
        this.getMinigame().hurt();
        this.getMinigame().processOnClickRules(false);
    }

    @Override
    public void playHurtAnimation() {
        this.mainTween.kill();
        this.mainTween = Tween.create();
        this.mainTween.tweenMethod(this::setGameColor, (Object)new OctoColor(0.8f, 0.2f, 1.0f, 1.0f), (Object)OctoColor.WHITE, 0.5);
        this.mainTween.start();
    }

    @Override
    public void playWinAnimation() {
        this.playing = false;
        this.children().forEach(meteor -> {
            meteor.playCrackAnimation();
            meteor.playCrackAnimation();
        });
        this.children().clear();
        this.rotationTween.kill();
        this.rotationTween = Tween.create();
        this.rotationTween.tweenMethod(this::setRot, (Object)this.rot, (Object)(this.rot + Math.toRadians(180.0)), 1.0).setEaseType(EaseType.EASE_OUT).setTransitionType(TransitionType.CUBIC);
        this.rotationTween.tweenRunnable(() -> this.screen.finish(false));
        this.rotationTween.start();
    }

    @Override
    public void playLoseAnimation() {
        this.playing = false;
        this.screen.finish(true);
    }

    @Override
    public void processDifficulty(Minigame<? extends AbstractMinigameWidget<?>> game) {
        this.random = new Random(game.getSeed());
        if (this.random.nextBoolean()) {
            this.rot = 1.5707f;
        }
        if (this.random.nextBoolean()) {
            this.rotationDir = -1;
        }
        float difficulty = game.getDifficulty();
        float scaled = 0.25f + difficulty * 0.75f;
        int meteorCount = Mth.ceil((float)(this.random.nextFloat(4.0f, 8.0f) * scaled));
        for (int i = 0; i < meteorCount; ++i) {
            MeteorWidget meteor = new MeteorWidget(0, 0, this.getRandomMeteorSize(), this);
            Vector2d randomPos = this.getRandomPos().sub((double)((float)meteor.getWidth() / 2.0f), (double)((float)meteor.getHeight() / 2.0f));
            meteor.setPosition((int)randomPos.x, (int)randomPos.y);
            meteor.precisePosition = randomPos;
            meteor.oldPos = new Vector2d((Vector2dc)randomPos);
            this.children.add(meteor);
        }
    }

    @Override
    public void killTweens() {
        this.mainTween.kill();
        this.rotationTween.kill();
    }

    private static Vector2d mirrorPosition(Vector2d point, Vector2d center, double angle) {
        double px = point.x - center.x;
        double py = point.y - center.y;
        double cos = Math.cos(angle);
        double sin = Math.sin(angle);
        double rx = cos * px + sin * py;
        double ry = -sin * px + cos * py;
        double fx = cos * rx - sin * (ry = -ry);
        double fy = sin * rx + cos * ry;
        Vector2d pos = new Vector2d(fx, fy);
        if (pos.lengthSquared() > 7396.0) {
            pos.normalize(86.0);
        }
        pos.add((Vector2dc)center);
        return pos;
    }

    private Vector2d getMirroredMousePos(double mouseX, double mouseY) {
        return MirrorWidget.mirrorPosition(new Vector2d(mouseX, mouseY), new Vector2d((double)((float)this.getX() + (float)this.width / 2.0f), (double)((float)this.getY() + (float)this.height / 2.0f)), this.rot);
    }

    public void swapMousePositions() {
        double guiScale = Minecraft.getInstance().getWindow().getGuiScale();
        double mouseX = Minecraft.getInstance().mouseHandler.xpos() / guiScale;
        double mouseY = Minecraft.getInstance().mouseHandler.ypos() / guiScale;
        Vector2d original = new Vector2d(mouseX, mouseY);
        Vector2d swapped = this.getMirroredMousePos(mouseX, mouseY);
        MouseHandlerAccessor accessor = (MouseHandlerAccessor)Minecraft.getInstance().mouseHandler;
        double sX = swapped.x * guiScale;
        double sY = swapped.y * guiScale;
        long windowHandle = Minecraft.getInstance().getWindow().getWindow();
        Clavis.CURSOR_MOVER.moveMouse(windowHandle, sX, sY);
        accessor.invokeOnMove(windowHandle, sX, sY);
        MouseTeleportUIParticle.drawLine(this.screen, swapped, original);
        this.crosshairTween.kill();
        this.crosshairTween = Tween.create();
        this.crosshairTween.tweenMethod(this::setCrosshairScale, (Object)Float.valueOf(1.5f), (Object)Float.valueOf(1.0f), 1.0).setTransitionType(TransitionType.QUART).setEaseType(EaseType.EASE_OUT);
        this.crosshairTween.start();
    }

    public void doShockwave() {
        double guiScale = Minecraft.getInstance().getWindow().getGuiScale();
        double mouseX = Minecraft.getInstance().mouseHandler.xpos() / guiScale;
        double mouseY = Minecraft.getInstance().mouseHandler.ypos() / guiScale;
        Vector2d mousePos = this.getMirroredMousePos(mouseX, mouseY);
        for (MeteorWidget meteor : this.children()) {
            Vector2d centerPos = meteor.getCenterPos(true);
            double dist = mousePos.distance((Vector2dc)centerPos);
            if (dist > 96.0) continue;
            Vector2d direction = new Vector2d((Vector2dc)mousePos).sub((Vector2dc)centerPos).normalize((96.0 - dist) / 32.0);
            if (dist <= (double)((float)Math.max(meteor.getWidth(), meteor.getHeight()) / 2.0f)) {
                direction.mul(0.25);
            }
            meteor.velocity.sub((Vector2dc)direction);
        }
        ShockwaveUIParticle.summonShockwaveEffect(this.screen, mousePos.x, mousePos.y);
    }

    public void tick() {
        this.oldBackgroundRotation = this.backgroundRotation;
        this.backgroundRotation += 0.003f;
        for (MeteorWidget child : this.children()) {
            child.tick();
        }
    }

    public void rotate(float alpha) {
        this.rotationTween.kill();
        this.rotationTween = Tween.create();
        this.rotationTween.parallel().tweenMethod(this::setRot, (Object)this.rot, (Object)(this.rot + Math.toRadians(alpha) * (double)this.rotationDir), 5.0).setEaseType(EaseType.EASE_IN_OUT).setTransitionType(TransitionType.QUART);
        this.rotationTween.start();
    }

    public Vector2d getRandomPos() {
        Vector2d randomPos = new Vector2d(this.getRandom().nextDouble(-90.0, 90.0), this.getRandom().nextDouble(-90.0, 90.0));
        if (randomPos.length() > 80.0) {
            randomPos.normalize(80.0);
        }
        randomPos.add(96.0, 96.0);
        return randomPos;
    }

    public int getRandomMeteorSize() {
        int smallestSize;
        float difficulty = this.minigame.getDifficulty();
        int n = difficulty > 0.66f ? 0 : (smallestSize = difficulty > 0.33f ? 1 : 2);
        if (smallestSize == 2) {
            return 2;
        }
        return this.random.nextInt(smallestSize, 3);
    }

    public OctoColor getGameColor() {
        return this.gameColor;
    }

    public void setGameColor(OctoColor gameColor) {
        this.gameColor = gameColor;
    }

    public void setCrosshairScale(float crosshairScale) {
        this.crosshairScale = crosshairScale;
    }

    public boolean isPlaying() {
        return this.playing;
    }

    public void setRot(double rot) {
        this.rot = rot;
    }
}

