/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.shatterbyte.clavis.common.config;

import it.hurts.octostudios.octolib.module.config.annotation.Prop;
import it.hurts.octostudios.octolib.module.config.impl.OctoConfig;
import it.hurts.shatterbyte.clavis.common.config.ModifiersConfig;
import it.hurts.shatterbyte.clavis.common.config.Range;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.world.level.Level;

public class Config
implements OctoConfig {
    @Prop(comment="Minigame type by dimension.")
    private Map<String, String> minigameType = new HashMap<String, String>(){
        {
            this.put(Level.OVERWORLD.location().toString(), "clavis:gear");
            this.put(Level.END.location().toString(), "clavis:mirror");
        }
    };
    @Prop(comment="Starting quality of a minigame.", inlineComment="0.0 - 10.0")
    private float startingQuality = 2.0f;
    @Prop(comment="Penalty for losing HP.")
    private float qualityPenaltyPerHit = 0.2f;
    @Prop(comment="Default base value for any item, that doesn't have any valuable tags.")
    private double defaultBaseItemValue = 0.33;
    @Prop(comment="A collection of valuable items and tags and its values. If an item isn't in the list and doesn't have any of these tags, it will use the base item value above. Item IDs are prioritized over tags.")
    private Map<String, Double> valuableItems = new LinkedHashMap<String, Double>(){
        {
            this.put("minecraft:saddle", 1.25);
            this.put("minecraft:name_tag", 1.0);
            this.put("#c:ingots", 5.0);
            this.put("#c:gems", 8.0);
            this.put("#c:storage_blocks", 16.0);
            this.put("#c:ores", 4.0);
            this.put("#c:raw_materials", 4.0);
            this.put("#c:rods", 6.0);
            this.put("#c:alloys", 6.0);
            this.put("#c:circuits", 8.0);
            this.put("#c:dusts", 1.0);
            this.put("#c:foods/golden", 16.0);
            this.put("#c:tools", 2.0);
            this.put("#c:armors", 2.0);
            this.put("#c:music_discs", 8.0);
        }
    };
    @Prop(comment="Additional value multipliers. Added on top of item value")
    private ModifiersConfig modifiers = new ModifiersConfig();
    @Prop(comment="Linearly maps calculated item values within this range to a 0% \u2013 100% difficulty scale.")
    private Range itemValueRange = new Range(0.0, 224.0);
    @Prop(comment="Difficulty threshold for spawning locks. Locks with difficulty below this value will not spawn.")
    private double difficultyThreshold = 0.05;
    @Prop(comment="Clamps the difficulty to this value.")
    private double upperDifficultyClamp = 1.5;
    @Prop(comment="Multiplies every difficulty by this value before clamping, simple as that.")
    private double globalDifficultyMultiplier = 1.0;
    @Prop(comment="Multiplies the difficulty for the loot table by the value provided below (before clamping).")
    private Map<String, Double> lootTableMultiplier = new HashMap<String, Double>(){
        {
            this.put("minecraft:chests/example", 1.5);
        }
    };
    @Prop(comment="Determines whether losing the minigame unlocks the lock.")
    private boolean unlocksAfterLosing = true;
    @Prop(comment="Disables rendering of locks for players.")
    private boolean disableLockRendering = false;

    public Map<String, String> getMinigameType() {
        return this.minigameType;
    }

    public float getStartingQuality() {
        return this.startingQuality;
    }

    public float getQualityPenaltyPerHit() {
        return this.qualityPenaltyPerHit;
    }

    public double getDefaultBaseItemValue() {
        return this.defaultBaseItemValue;
    }

    public Map<String, Double> getValuableItems() {
        return this.valuableItems;
    }

    public ModifiersConfig getModifiers() {
        return this.modifiers;
    }

    public Range getItemValueRange() {
        return this.itemValueRange;
    }

    public double getDifficultyThreshold() {
        return this.difficultyThreshold;
    }

    public double getUpperDifficultyClamp() {
        return this.upperDifficultyClamp;
    }

    public double getGlobalDifficultyMultiplier() {
        return this.globalDifficultyMultiplier;
    }

    public Map<String, Double> getLootTableMultiplier() {
        return this.lootTableMultiplier;
    }

    public boolean isUnlocksAfterLosing() {
        return this.unlocksAfterLosing;
    }

    public boolean isDisableLockRendering() {
        return this.disableLockRendering;
    }

    public void setMinigameType(Map<String, String> minigameType) {
        this.minigameType = minigameType;
    }

    public void setStartingQuality(float startingQuality) {
        this.startingQuality = startingQuality;
    }

    public void setQualityPenaltyPerHit(float qualityPenaltyPerHit) {
        this.qualityPenaltyPerHit = qualityPenaltyPerHit;
    }

    public void setDefaultBaseItemValue(double defaultBaseItemValue) {
        this.defaultBaseItemValue = defaultBaseItemValue;
    }

    public void setValuableItems(Map<String, Double> valuableItems) {
        this.valuableItems = valuableItems;
    }

    public void setModifiers(ModifiersConfig modifiers) {
        this.modifiers = modifiers;
    }

    public void setItemValueRange(Range itemValueRange) {
        this.itemValueRange = itemValueRange;
    }

    public void setDifficultyThreshold(double difficultyThreshold) {
        this.difficultyThreshold = difficultyThreshold;
    }

    public void setUpperDifficultyClamp(double upperDifficultyClamp) {
        this.upperDifficultyClamp = upperDifficultyClamp;
    }

    public void setGlobalDifficultyMultiplier(double globalDifficultyMultiplier) {
        this.globalDifficultyMultiplier = globalDifficultyMultiplier;
    }

    public void setLootTableMultiplier(Map<String, Double> lootTableMultiplier) {
        this.lootTableMultiplier = lootTableMultiplier;
    }

    public void setUnlocksAfterLosing(boolean unlocksAfterLosing) {
        this.unlocksAfterLosing = unlocksAfterLosing;
    }

    public void setDisableLockRendering(boolean disableLockRendering) {
        this.disableLockRendering = disableLockRendering;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Config)) {
            return false;
        }
        Config other = (Config)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Float.compare(this.getStartingQuality(), other.getStartingQuality()) != 0) {
            return false;
        }
        if (Float.compare(this.getQualityPenaltyPerHit(), other.getQualityPenaltyPerHit()) != 0) {
            return false;
        }
        if (Double.compare(this.getDefaultBaseItemValue(), other.getDefaultBaseItemValue()) != 0) {
            return false;
        }
        if (Double.compare(this.getDifficultyThreshold(), other.getDifficultyThreshold()) != 0) {
            return false;
        }
        if (Double.compare(this.getUpperDifficultyClamp(), other.getUpperDifficultyClamp()) != 0) {
            return false;
        }
        if (Double.compare(this.getGlobalDifficultyMultiplier(), other.getGlobalDifficultyMultiplier()) != 0) {
            return false;
        }
        if (this.isUnlocksAfterLosing() != other.isUnlocksAfterLosing()) {
            return false;
        }
        if (this.isDisableLockRendering() != other.isDisableLockRendering()) {
            return false;
        }
        Map<String, String> this$minigameType = this.getMinigameType();
        Map<String, String> other$minigameType = other.getMinigameType();
        if (this$minigameType == null ? other$minigameType != null : !((Object)this$minigameType).equals(other$minigameType)) {
            return false;
        }
        Map<String, Double> this$valuableItems = this.getValuableItems();
        Map<String, Double> other$valuableItems = other.getValuableItems();
        if (this$valuableItems == null ? other$valuableItems != null : !((Object)this$valuableItems).equals(other$valuableItems)) {
            return false;
        }
        ModifiersConfig this$modifiers = this.getModifiers();
        ModifiersConfig other$modifiers = other.getModifiers();
        if (this$modifiers == null ? other$modifiers != null : !((Object)this$modifiers).equals(other$modifiers)) {
            return false;
        }
        Range this$itemValueRange = this.getItemValueRange();
        Range other$itemValueRange = other.getItemValueRange();
        if (this$itemValueRange == null ? other$itemValueRange != null : !((Object)this$itemValueRange).equals(other$itemValueRange)) {
            return false;
        }
        Map<String, Double> this$lootTableMultiplier = this.getLootTableMultiplier();
        Map<String, Double> other$lootTableMultiplier = other.getLootTableMultiplier();
        return !(this$lootTableMultiplier == null ? other$lootTableMultiplier != null : !((Object)this$lootTableMultiplier).equals(other$lootTableMultiplier));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Config;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Float.floatToIntBits(this.getStartingQuality());
        result = result * 59 + Float.floatToIntBits(this.getQualityPenaltyPerHit());
        long $defaultBaseItemValue = Double.doubleToLongBits(this.getDefaultBaseItemValue());
        result = result * 59 + (int)($defaultBaseItemValue >>> 32 ^ $defaultBaseItemValue);
        long $difficultyThreshold = Double.doubleToLongBits(this.getDifficultyThreshold());
        result = result * 59 + (int)($difficultyThreshold >>> 32 ^ $difficultyThreshold);
        long $upperDifficultyClamp = Double.doubleToLongBits(this.getUpperDifficultyClamp());
        result = result * 59 + (int)($upperDifficultyClamp >>> 32 ^ $upperDifficultyClamp);
        long $globalDifficultyMultiplier = Double.doubleToLongBits(this.getGlobalDifficultyMultiplier());
        result = result * 59 + (int)($globalDifficultyMultiplier >>> 32 ^ $globalDifficultyMultiplier);
        result = result * 59 + (this.isUnlocksAfterLosing() ? 79 : 97);
        result = result * 59 + (this.isDisableLockRendering() ? 79 : 97);
        Map<String, String> $minigameType = this.getMinigameType();
        result = result * 59 + ($minigameType == null ? 43 : ((Object)$minigameType).hashCode());
        Map<String, Double> $valuableItems = this.getValuableItems();
        result = result * 59 + ($valuableItems == null ? 43 : ((Object)$valuableItems).hashCode());
        ModifiersConfig $modifiers = this.getModifiers();
        result = result * 59 + ($modifiers == null ? 43 : ((Object)$modifiers).hashCode());
        Range $itemValueRange = this.getItemValueRange();
        result = result * 59 + ($itemValueRange == null ? 43 : ((Object)$itemValueRange).hashCode());
        Map<String, Double> $lootTableMultiplier = this.getLootTableMultiplier();
        result = result * 59 + ($lootTableMultiplier == null ? 43 : ((Object)$lootTableMultiplier).hashCode());
        return result;
    }

    public String toString() {
        return "Config(minigameType=" + String.valueOf(this.getMinigameType()) + ", startingQuality=" + this.getStartingQuality() + ", qualityPenaltyPerHit=" + this.getQualityPenaltyPerHit() + ", defaultBaseItemValue=" + this.getDefaultBaseItemValue() + ", valuableItems=" + String.valueOf(this.getValuableItems()) + ", modifiers=" + String.valueOf(this.getModifiers()) + ", itemValueRange=" + String.valueOf(this.getItemValueRange()) + ", difficultyThreshold=" + this.getDifficultyThreshold() + ", upperDifficultyClamp=" + this.getUpperDifficultyClamp() + ", globalDifficultyMultiplier=" + this.getGlobalDifficultyMultiplier() + ", lootTableMultiplier=" + String.valueOf(this.getLootTableMultiplier()) + ", unlocksAfterLosing=" + this.isUnlocksAfterLosing() + ", disableLockRendering=" + this.isDisableLockRendering() + ")";
    }
}

