/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.shatterbyte.clavis.common.network;

import it.hurts.shatterbyte.clavis.common.Clavis;
import it.hurts.shatterbyte.clavis.common.LockManager;
import it.hurts.shatterbyte.clavis.common.LootrCompat;
import it.hurts.shatterbyte.clavis.common.data.Box;
import it.hurts.shatterbyte.clavis.common.data.Lock;
import it.hurts.shatterbyte.clavis.common.data.LootUtils;
import java.util.UUID;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.RandomizableContainer;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.DispenserBlockEntity;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.chunk.LevelChunk;

public class ChunkListeners {
    public static void onGenerate(ServerLevel level, LevelChunk levelChunk) {
        levelChunk.getBlockEntities().forEach((blockPos, blockEntity) -> {
            RandomizableContainerBlockEntity randomizable;
            if (!(blockEntity instanceof RandomizableContainerBlockEntity) || (randomizable = (RandomizableContainerBlockEntity)blockEntity).getLootTable() == null || LootrCompat.COMPAT.isLootrBlockEntity((BlockEntity)randomizable)) {
                return;
            }
            if (randomizable instanceof DispenserBlockEntity) {
                return;
            }
            float difficulty = (float)LootUtils.calculateDifficulty(level, blockPos, (RandomizableContainer)randomizable, 0, false, null);
            if ((double)difficulty < Clavis.CONFIG.getDifficultyThreshold()) {
                return;
            }
            LockManager.addLock(level, new Lock(UUID.randomUUID(), new Box((Vec3i)blockPos), difficulty, randomizable.getLootTableSeed(), false));
        });
    }
}

