/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.shatterbyte.clavis.common.client.screen.widget;

import it.hurts.octostudios.octolib.client.screen.widget.HasRenderMatrix;
import it.hurts.shatterbyte.clavis.common.client.screen.LockpickingScreen;
import it.hurts.shatterbyte.clavis.common.minigame.Minigame;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.ContainerEventHandler;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.renderer.texture.Tickable;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;

public abstract class AbstractMinigameWidget<T extends GuiEventListener>
extends AbstractWidget
implements ContainerEventHandler,
HasRenderMatrix,
Tickable {
    Random random = new Random();
    LockpickingScreen screen;
    Minigame minigame;
    Matrix4f matrix;
    List<T> children = new ArrayList<T>();
    GuiEventListener focused;
    boolean dragging;

    protected AbstractMinigameWidget(int x, int y, int width, int height, LockpickingScreen screen) {
        super(x, y, width, height, (Component)Component.empty());
        this.screen = screen;
    }

    public void killTweens() {
    }

    public abstract void playHurtAnimation();

    public abstract void playWinAnimation();

    public abstract void playLoseAnimation();

    public abstract void processDifficulty(Minigame<? extends AbstractMinigameWidget<?>> var1);

    protected void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
    }

    protected void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.setMatrix(new Matrix4f((Matrix4fc)guiGraphics.pose().last().pose()));
        this.children.reversed().forEach(child -> {
            if (child instanceof Renderable) {
                Renderable renderable = (Renderable)child;
                renderable.render(guiGraphics, mouseX, mouseY, partialTick);
            }
        });
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (super.mouseClicked(mouseX, mouseY, button)) {
            return false;
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    @NotNull
    public List<T> children() {
        return this.children;
    }

    public boolean isDragging() {
        return this.dragging;
    }

    public void setDragging(boolean isDragging) {
        this.dragging = isDragging;
    }

    @Nullable
    public GuiEventListener getFocused() {
        return this.focused;
    }

    public void setFocused(@Nullable GuiEventListener focused) {
        this.focused = focused;
    }

    public Matrix4f getMatrix() {
        return this.matrix;
    }

    public void setMatrix(Matrix4f matrix) {
        this.matrix = matrix;
    }

    public Random getRandom() {
        return this.random;
    }

    public LockpickingScreen getScreen() {
        return this.screen;
    }

    public Minigame getMinigame() {
        return this.minigame;
    }

    public void setMinigame(Minigame minigame) {
        this.minigame = minigame;
    }
}

