/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.shatterbyte.clavis.common.registry;

import it.hurts.shatterbyte.clavis.common.Clavis;
import it.hurts.shatterbyte.clavis.common.data.ValueModifier;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.ItemEnchantments;

public class ValueModifierRegistry {
    public static final Map<ResourceLocation, ValueModifier> MODIFIERS = new HashMap<ResourceLocation, ValueModifier>();
    public static final ValueModifier ENCHANTMENT = ValueModifierRegistry.createModifier(Clavis.path("enchantment"), itemStack -> {
        ItemEnchantments enchantments = EnchantmentHelper.getEnchantmentsForCrafting((ItemStack)itemStack);
        double perEnchantmentLevel = Clavis.CONFIG.getModifiers().getPerEnchantmentLevel();
        if (enchantments.isEmpty()) {
            return 1.0;
        }
        AtomicReference<Double> multiplier = new AtomicReference<Double>(1.0);
        enchantments.keySet().forEach(enchantmentHolder -> {
            int level = itemStack.getEnchantments().getLevel(enchantmentHolder);
            multiplier.updateAndGet(v -> v + (double)level * perEnchantmentLevel);
        });
        return multiplier.get();
    });
    public static final ValueModifier MAX_STACK = ValueModifierRegistry.createModifier(Clavis.path("max_stack"), itemStack -> {
        int maxStack = itemStack.getMaxStackSize();
        if (maxStack <= 16) {
            return Clavis.CONFIG.getModifiers().getLowStackSize();
        }
        if (maxStack <= 64) {
            return 1.0;
        }
        return 1.0;
    });
    public static final ValueModifier RARITY = ValueModifierRegistry.createModifier(Clavis.path("rarity"), itemStack -> {
        Rarity rarity = itemStack.getRarity();
        return Clavis.CONFIG.getModifiers().getRarity().getOrDefault(rarity, 1.0);
    });
    public static final ValueModifier CURIOS = ValueModifierRegistry.createModifier(Clavis.path("curios"), itemStack -> {
        if (itemStack.getTags().anyMatch(itemTagKey -> itemTagKey.location().getNamespace().equals("curios") || itemTagKey.location().getNamespace().equals("trinkets"))) {
            return Clavis.CONFIG.getModifiers().getIsCuriosOrTrinkets();
        }
        return 1.0;
    });

    public static ValueModifier createModifier(ResourceLocation resourceLocation, ValueModifier modifier) {
        MODIFIERS.put(resourceLocation, modifier);
        return modifier;
    }
}

