/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.shatterbyte.clavis.common.client.screen;

import com.google.common.collect.Lists;
import dev.architectury.networking.NetworkManager;
import dev.architectury.platform.Platform;
import it.hurts.octostudios.octolib.client.animation.Tween;
import it.hurts.octostudios.octolib.client.particle.UIParticle;
import it.hurts.octostudios.octolib.util.RenderUtils;
import it.hurts.shatterbyte.clavis.common.Clavis;
import it.hurts.shatterbyte.clavis.common.ClavisClient;
import it.hurts.shatterbyte.clavis.common.client.particle.HalfHeartUIParticle;
import it.hurts.shatterbyte.clavis.common.client.particle.HeartPartUIParticle;
import it.hurts.shatterbyte.clavis.common.client.screen.widget.AbstractMinigameWidget;
import it.hurts.shatterbyte.clavis.common.client.screen.widget.MinigameInfoWidget;
import it.hurts.shatterbyte.clavis.common.client.screen.widget.RuleWidget;
import it.hurts.shatterbyte.clavis.common.data.Lock;
import it.hurts.shatterbyte.clavis.common.data.MinigameStyleData;
import it.hurts.shatterbyte.clavis.common.data.TooltipInfoData;
import it.hurts.shatterbyte.clavis.common.minigame.Minigame;
import it.hurts.shatterbyte.clavis.common.minigame.rule.Rule;
import it.hurts.shatterbyte.clavis.common.network.packet.FinishLockpickingPacket;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.class_1061;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_364;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_5481;
import net.minecraft.class_8710;

public class LockpickingScreen<T extends AbstractMinigameWidget<?>>
extends class_437 {
    public static final class_2960 EMPTY_HEART = Clavis.path("textures/lockpicking/empty_heart.png");
    public static final class_2960 HEART = Clavis.path("textures/lockpicking/heart.png");
    private final Supplier<T> widgetFactory;
    Minigame<T> game;
    T minigameWidget;
    class_2338 blockPos;
    Lock lock;
    MinigameStyleData styleData;

    public LockpickingScreen(class_2338 blockPos, Lock lock, Supplier<T> widgetFactory) {
        super((class_2561)class_2561.method_43473());
        this.blockPos = blockPos;
        this.lock = lock;
        this.widgetFactory = widgetFactory;
        Tween tween = Tween.create().setLoops(-1);
        tween.tweenRunnable(() -> class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_4758((class_3414)class_3417.field_14699, (float)2.0f)));
        tween.tweenInterval(0.5);
        tween.tweenRunnable(() -> class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_4758((class_3414)class_3417.field_15105, (float)1.6f)));
        tween.tweenInterval(0.5);
        tween.tweenRunnable(() -> class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_4758((class_3414)class_3417.field_15105, (float)1.6f)));
        tween.tweenInterval(0.5);
        tween.tweenRunnable(() -> class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_4758((class_3414)class_3417.field_15105, (float)1.6f)));
        tween.tweenInterval(0.5);
        tween.tweenRunnable(() -> {
            if (class_310.method_1551().field_1755 != this) {
                tween.kill();
            }
        });
    }

    public void method_25393() {
        this.method_25396().forEach(child -> {
            if (child instanceof class_1061) {
                class_1061 tickable = (class_1061)child;
                tickable.method_4622();
            }
        });
        this.game.processOnTickRules();
        if (class_310.method_1551().field_1724 != null && class_310.method_1551().field_1724.method_19538().method_1025(this.blockPos.method_46558()) > 256.0) {
            class_310.method_1551().method_1507(null);
        }
    }

    public void finish(boolean hasLostTheGame) {
        ClavisClient.SCREEN_CACHE.remove(this.lock);
        NetworkManager.sendToServer((class_8710)new FinishLockpickingPacket(this.blockPos, this.lock, this.game.getLootQuality(), hasLostTheGame));
        class_310.method_1551().method_1507(null);
    }

    protected void method_25426() {
        this.addOrRepositionWidget((AbstractMinigameWidget)((Object)this.widgetFactory.get()));
    }

    private void addOrRepositionWidget(T genericWidget) {
        if (this.minigameWidget == null) {
            this.minigameWidget = genericWidget;
            this.game = new Minigame<T>(this.minigameWidget);
            ((AbstractMinigameWidget)((Object)this.minigameWidget)).setMinigame(this.game);
            this.game.load(this.lock, (class_1937)class_310.method_1551().field_1687);
            ((AbstractMinigameWidget)((Object)this.minigameWidget)).processDifficulty(this.game);
            if (this.game.getRules().isEmpty()) {
                int ruleNumber = (int)Math.min(Math.ceil(this.game.getDifficulty() / 0.33f), 3.0);
                List rules = Lists.newArrayList(Rule.getRegisteredRules(this.minigameWidget.getClass()));
                Collections.shuffle(rules, ((AbstractMinigameWidget)((Object)this.minigameWidget)).getRandom());
                rules = rules.stream().limit(ruleNumber).toList();
                this.game.addRules(rules);
            }
            this.game.processOnCreateRules();
        }
        this.minigameWidget.method_48229(Math.round((float)this.field_22789 / 2.0f - (float)this.minigameWidget.method_25368() + 8.0f), Math.round((float)this.field_22790 / 2.0f - (float)this.minigameWidget.method_25364() / 2.0f - 8.0f));
        int x = Math.round((float)this.field_22789 / 2.0f) + 20;
        int y = Math.round((float)this.field_22790 / 2.0f - (float)this.minigameWidget.method_25364() / 2.0f) - 8;
        this.styleData = MinigameStyleData.get(this.game.getMinigameType());
        for (Rule<T> rule : this.game.getRules()) {
            RuleWidget widget = new RuleWidget(x, y, rule, this);
            this.method_37063((class_364)widget);
            y += widget.method_25364() + 2;
        }
        MinigameInfoWidget infoWidget = new MinigameInfoWidget(this.game, this.styleData);
        infoWidget.method_48229(x, y);
        this.method_37063((class_364)infoWidget);
        this.method_37063((class_364)this.minigameWidget);
    }

    public void method_25420(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.method_52752(guiGraphics);
    }

    public void animateHeart() {
        class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_4757((class_3414)class_3417.field_26942, (float)1.5f, (float)0.8f));
        float x = (float)this.minigameWidget.method_46426() + (float)this.minigameWidget.method_25368() / 2.0f - 64.0f;
        float y = this.minigameWidget.method_46427() + this.minigameWidget.method_25364() + 16;
        int health = this.game.getHealth();
        HalfHeartUIParticle left = new HalfHeartUIParticle(false, x += (float)(health * 32), y, UIParticle.Layer.SCREEN, 1.0f);
        HalfHeartUIParticle right = new HalfHeartUIParticle(true, x, y, UIParticle.Layer.SCREEN, 1.0f);
        left.setScreen(this);
        right.setScreen(this);
        left.instantiate();
        right.instantiate();
        for (int i = 0; i < 3; ++i) {
            HeartPartUIParticle particle = new HeartPartUIParticle(x, y, UIParticle.Layer.SCREEN, 0.5f);
            particle.setScreen(this);
            particle.instantiate();
        }
    }

    public void method_25394(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.method_25394(guiGraphics, mouseX, mouseY, partialTick);
        guiGraphics.method_51448().method_22903();
        guiGraphics.method_51448().method_46416((float)this.minigameWidget.method_46426() + (float)this.minigameWidget.method_25368() / 2.0f, (float)(this.minigameWidget.method_46427() + this.minigameWidget.method_25364()), 0.0f);
        guiGraphics.method_51448().method_46416(-80.0f, 8.0f, 10.0f);
        for (int i = 1; i <= 5; ++i) {
            guiGraphics.method_25293(i <= this.getGame().getHealth() ? HEART : EMPTY_HEART, 0, 0, 32, 32, 0.0f, 0.0f, 32, 32, 32, 32);
            guiGraphics.method_51448().method_46416(32.0f, 0.0f, 0.0f);
        }
        guiGraphics.method_51448().method_22909();
    }

    public static void renderTooltip(class_2960 minigameType, class_327 font, TooltipInfoData tooltipInfoData, class_332 guiGraphics, double mouseX, double mouseY, float partialTick, boolean isDescription) {
        List<class_5481> toRender = isDescription ? tooltipInfoData.getDescription() : tooltipInfoData.getSummary();
        int length = isDescription ? tooltipInfoData.getDescriptionLength() : tooltipInfoData.getSummaryLength();
        length = Math.round((float)length * 0.75f) + 2;
        int height = Math.round((float)((toRender.size() - 1) * 9) * 0.75f) + 3;
        mouseX += 1.0;
        mouseY -= (double)(22 + height);
        if (mouseX + (double)length + 16.0 > (double)class_310.method_1551().field_1755.field_22789) {
            mouseX -= (double)(18 + length);
        }
        class_2960 tooltip = Clavis.path(minigameType.method_12836(), "textures/lockpicking/" + minigameType.method_12832() + "/tooltip.png");
        guiGraphics.method_51448().method_22903();
        guiGraphics.method_51448().method_22904(mouseX, mouseY, 0.0);
        guiGraphics.method_25293(tooltip, 0, 0, 8, 8, 0.0f, 0.0f, 8, 8, 34, 16);
        guiGraphics.method_25293(tooltip, 8, 0, length, 8, 8.0f, 0.0f, 1, 8, 34, 16);
        guiGraphics.method_25293(tooltip, 8 + length, 0, 8, 8, 9.0f, 0.0f, 8, 8, 34, 16);
        RenderUtils.renderTilingTexture((class_4587)guiGraphics.method_51448(), (float)0.0f, (float)8.0f, (float)17.0f, (float)8.0f, (float)34.0f, (float)16.0f, (float)8.0f, (float)height, (float)0.0f, (boolean)true, (boolean)true);
        guiGraphics.method_25293(tooltip, 8, 8, length, height, 25.0f, 8.0f, 1, 8, 34, 16);
        RenderUtils.renderTilingTexture((class_4587)guiGraphics.method_51448(), (float)(8 + length), (float)8.0f, (float)26.0f, (float)8.0f, (float)34.0f, (float)16.0f, (float)8.0f, (float)height, (float)0.0f, (boolean)true, (boolean)true);
        guiGraphics.method_25293(tooltip, 0, 8 + height, 8, 8, 0.0f, 8.0f, 8, 8, 34, 16);
        guiGraphics.method_25293(tooltip, 8, 8 + height, length, 8, 8.0f, 8.0f, 1, 8, 34, 16);
        guiGraphics.method_25293(tooltip, 8 + length, 8 + height, 8, 8, 9.0f, 8.0f, 8, 8, 34, 16);
        guiGraphics.method_51448().method_22909();
        guiGraphics.method_51448().method_22903();
        guiGraphics.method_51448().method_22904(mouseX + 9.0, mouseY + 8.0, 1.0);
        guiGraphics.method_51448().method_22905(0.75f, 0.75f, 1.0f);
        for (class_5481 sequence : toRender) {
            guiGraphics.method_51430(font, sequence, 0, 0, -9228512, false);
            guiGraphics.method_51448().method_46416(0.0f, 9.0f, 0.0f);
        }
        guiGraphics.method_51448().method_22909();
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (Platform.isDevelopmentEnvironment() && button == 1) {
            ((AbstractMinigameWidget)((Object)this.minigameWidget)).killTweens();
            this.minigameWidget = null;
            this.method_41843();
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public boolean method_25421() {
        return false;
    }

    public Minigame<T> getGame() {
        return this.game;
    }

    public Lock getLock() {
        return this.lock;
    }

    public MinigameStyleData getStyleData() {
        return this.styleData;
    }
}

