/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.shatterbyte.clavis.common.client.screen.widget;

import com.mojang.blaze3d.systems.RenderSystem;
import it.hurts.octostudios.octolib.OctoLibClient;
import it.hurts.octostudios.octolib.client.animation.Tween;
import it.hurts.octostudios.octolib.client.animation.easing.EaseType;
import it.hurts.octostudios.octolib.client.animation.easing.TransitionType;
import it.hurts.octostudios.octolib.client.particle.ExtendedUIParticle;
import it.hurts.octostudios.octolib.client.particle.UIParticle;
import it.hurts.octostudios.octolib.util.OctoColor;
import it.hurts.octostudios.octolib.util.VectorUtils;
import it.hurts.shatterbyte.clavis.common.Clavis;
import it.hurts.shatterbyte.clavis.common.client.screen.LockpickingScreen;
import it.hurts.shatterbyte.clavis.common.client.screen.widget.AbstractMinigameWidget;
import it.hurts.shatterbyte.clavis.common.client.screen.widget.FakePinWidget;
import it.hurts.shatterbyte.clavis.common.client.screen.widget.LockPinWidget;
import it.hurts.shatterbyte.clavis.common.client.screen.widget.RotatingParent;
import it.hurts.shatterbyte.clavis.common.minigame.Minigame;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_437;
import net.minecraft.class_6880;
import net.minecraft.class_7833;
import org.joml.Vector2d;
import org.joml.Vector2dc;
import org.joml.Vector2f;

public class GearMechanismWidget
extends AbstractMinigameWidget<RotatingParent<LockPinWidget, GearMechanismWidget>> {
    public static final class_2960 ID = Clavis.path("gear");
    public static final class_2960 BACKGROUND = Clavis.path("textures/minigame/gear/background.png");
    public static final class_2960 COGWHEEL = Clavis.path("textures/minigame/gear/gear.png");
    public static final class_2960 ARROW = Clavis.path("textures/minigame/gear/arrow.png");
    public static final class_2960 ARROW_HOT = Clavis.path("textures/minigame/gear/arrow_hot.png");
    public static final class_2960 CENTER = Clavis.path("textures/minigame/gear/center.png");
    public static final class_2960 CENTER_WARNING_ON = Clavis.path("textures/minigame/gear/center_warning_on.png");
    public static final class_2960 CENTER_WARNING_OFF = Clavis.path("textures/minigame/gear/center_warning_off.png");
    OctoColor gameColor = OctoColor.WHITE;
    float rot;
    float arrowRot;
    float arrowSpeed;
    float maxArrowSpeed;
    float maxPins;
    public float arrowSpeedModifier;
    List<Integer> freeSpots = new ArrayList<Integer>();
    int maxSpots;
    float arrowTemperature;
    float warningVisibility = 0.0f;
    boolean playing = true;
    public boolean selfDestructRule;
    Tween gearTween = Tween.create();
    Tween arrowTween = Tween.create();
    Tween mainTween = Tween.create();
    Tween selfDestructionTween = Tween.create();

    public boolean isArrowHot() {
        return (double)this.arrowTemperature > 0.5;
    }

    public GearMechanismWidget() {
        super(0, 0, 192, 192, (LockpickingScreen)class_310.method_1551().field_1755);
    }

    @Override
    public void processDifficulty(Minigame<? extends AbstractMinigameWidget<?>> game) {
        this.random = new Random(game.getSeed());
        float difficulty = game.getDifficulty();
        float scaled = 0.6666667f + difficulty * 0.33333334f;
        int pins = class_3532.method_15386((float)(this.random.nextFloat(5.0f, 8.0f) * scaled));
        this.maxPins = pins;
        this.maxSpots = (int)Math.round((double)pins * 1.5);
        this.arrowSpeed = this.random.nextFloat(220.0f, 280.0f) * scaled;
        if (this.random.nextBoolean()) {
            this.arrowSpeed *= -1.0f;
        }
        this.maxArrowSpeed = Math.abs(this.arrowSpeed);
        List list = IntStream.range(0, this.maxSpots).boxed().collect(Collectors.toCollection(ArrayList::new));
        Collections.shuffle(list, this.random);
        list.stream().limit(pins).forEach(i -> {
            float newI = (float)i.intValue() * (360.0f / (float)this.maxSpots) + this.random.nextFloat(-5.0f, 5.0f) * (10.0f / (float)this.maxSpots);
            this.children.add(LockPinWidget.create(Math.round((float)this.field_22758 / 2.0f), Math.round((float)this.field_22759 / 2.0f), newI, this));
        });
        this.freeSpots = new ArrayList<Integer>(list.subList(pins, list.size()));
    }

    public void setRot(float rot) {
        this.rot = (float)GearMechanismWidget.normalizeAngle(rot);
    }

    @Override
    public void playHurtAnimation() {
        this.mainTween.kill();
        this.mainTween = Tween.create();
        this.mainTween.tweenMethod(this::setGameColor, (Object)new OctoColor(1.25f, 0.4f, 0.4f, 1.0f), (Object)OctoColor.WHITE, 0.5);
        this.mainTween.start();
    }

    @Override
    public void playWinAnimation() {
        this.playing = false;
        this.gearTween.kill();
        this.gearTween = Tween.create();
        this.gearTween.tweenMethod(this::setRot, (Object)Float.valueOf(this.rot), (Object)Float.valueOf(this.rot + (float)(180 * -GearMechanismWidget.sign(this.arrowSpeed))), 1.0).setEaseType(EaseType.EASE_OUT).setTransitionType(TransitionType.CUBIC);
        this.gearTween.start();
        this.arrowTween.kill();
        this.arrowTween = Tween.create();
        this.arrowTween.tweenInterval(0.25);
        this.arrowTween.tweenRunnable(() -> this.children.forEach(rotating -> ((LockPinWidget)((Object)((Object)((Object)rotating.children.getFirst())))).disappear()));
        this.arrowTween.tweenMethod(this::setArrowSpeed, (Object)Float.valueOf(this.arrowSpeed), (Object)Float.valueOf(0.0f), 0.75);
        this.arrowTween.tweenRunnable(() -> this.screen.finish(false));
        this.arrowTween.start();
    }

    @Override
    public void playLoseAnimation() {
        this.playing = false;
        this.arrowTween.kill();
        this.mainTween.kill();
        this.screen.finish(true);
    }

    public void activateSelfDestruction() {
        this.warningVisibility = 0.0f;
        this.arrowTemperature = 0.0f;
        class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_4758((class_3414)class_3417.field_14703, (float)1.25f));
        this.selfDestructionTween.kill();
        this.selfDestructionTween = Tween.create();
        this.selfDestructionTween.tweenMethod(this::setWarningVisibility, (Object)Float.valueOf(0.0f), (Object)Float.valueOf(1.0f), 0.2);
        this.selfDestructionTween.tweenInterval(0.3);
        this.selfDestructionTween.tweenRunnable(() -> class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_4758((class_3414)class_3417.field_14993, (float)0.85f)));
        this.selfDestructionTween.tweenMethod(this::setArrowTemperature, (Object)Float.valueOf(0.0f), (Object)Float.valueOf(1.0f), 1.0).setEaseType(EaseType.EASE_IN_OUT).setTransitionType(TransitionType.QUAD);
        this.selfDestructionTween.tweenInterval(1.0);
        this.selfDestructionTween.tweenMethod(this::setWarningVisibility, (Object)Float.valueOf(1.0f), (Object)Float.valueOf(0.0f), 0.2);
        this.selfDestructionTween.parallel().tweenMethod(this::setArrowTemperature, (Object)Float.valueOf(1.0f), (Object)Float.valueOf(0.0f), 0.6).setEaseType(EaseType.EASE_OUT).setTransitionType(TransitionType.EXPO);
        this.selfDestructionTween.start();
    }

    @Override
    protected void method_48579(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        RenderSystem.setShaderColor((float)this.gameColor.r(), (float)this.gameColor.g(), (float)this.gameColor.b(), (float)this.gameColor.a());
        RenderSystem.enableBlend();
        guiGraphics.method_51448().method_22903();
        int offset = 23;
        guiGraphics.method_25293(BACKGROUND, this.method_46426() + offset, this.method_46427() + offset, 146, 146, 0.0f, 0.0f, 146, 146, 146, 146);
        guiGraphics.method_51448().method_46416((float)this.method_46426() + (float)this.field_22758 / 2.0f, (float)this.method_46427() + (float)this.field_22759 / 2.0f, 0.0f);
        guiGraphics.method_51448().method_22907(class_7833.field_40718.rotationDegrees(this.rot));
        guiGraphics.method_51448().method_46416((float)(-this.field_22758) / 2.0f - (float)this.method_46426(), (float)(-this.field_22759) / 2.0f - (float)this.method_46427(), 0.0f);
        super.method_48579(guiGraphics, mouseX, mouseY, partialTick);
        guiGraphics.method_25293(COGWHEEL, this.method_46426(), this.method_46427(), 192, 192, 0.0f, 0.0f, 192, 192, 192, 192);
        guiGraphics.method_51448().method_22909();
        guiGraphics.method_51448().method_22903();
        guiGraphics.method_51448().method_46416((float)this.method_46426() + (float)this.field_22758 / 2.0f, (float)this.method_46427() + (float)this.field_22759 / 2.0f, 0.0f);
        guiGraphics.method_51448().method_22907(class_7833.field_40718.rotationDegrees(this.arrowRot));
        guiGraphics.method_25293(ARROW, -8, -6, 16, 42, 0.0f, 0.0f, 16, 42, 16, 42);
        if (this.arrowTemperature > 0.0f) {
            RenderSystem.setShaderColor((float)this.gameColor.r(), (float)this.gameColor.g(), (float)this.gameColor.b(), (float)this.arrowTemperature);
            RenderSystem.enableBlend();
            guiGraphics.method_25293(ARROW_HOT, -8, -6, 16, 42, 0.0f, 0.0f, 16, 42, 16, 42);
            RenderSystem.setShaderColor((float)this.gameColor.r(), (float)this.gameColor.g(), (float)this.gameColor.b(), (float)this.gameColor.a());
            RenderSystem.disableBlend();
        }
        guiGraphics.method_51448().method_22909();
        guiGraphics.method_51448().method_22903();
        guiGraphics.method_51448().method_46416((float)this.method_46426() + (float)this.field_22758 / 2.0f, (float)this.method_46427() + (float)this.field_22759 / 2.0f, 0.0f);
        guiGraphics.method_25293(this.selfDestructRule ? CENTER_WARNING_OFF : CENTER, -8, -8, 16, 16, 0.0f, 0.0f, 16, 16, 16, 16);
        if (this.warningVisibility > 0.0f) {
            RenderSystem.setShaderColor((float)this.gameColor.r(), (float)this.gameColor.g(), (float)this.gameColor.b(), (float)this.warningVisibility);
            RenderSystem.enableBlend();
            guiGraphics.method_25293(CENTER_WARNING_ON, -8, -8, 16, 16, 0.0f, 0.0f, 16, 16, 16, 16);
            RenderSystem.setShaderColor((float)this.gameColor.r(), (float)this.gameColor.g(), (float)this.gameColor.b(), (float)this.gameColor.a());
            RenderSystem.disableBlend();
        }
        guiGraphics.method_51448().method_22909();
        this.arrowRot = (float)GearMechanismWidget.normalizeAngle((double)this.arrowRot + OctoLibClient.getDeltaTime() * (double)(this.arrowSpeed + this.arrowSpeedModifier * (this.arrowSpeed / this.maxArrowSpeed)));
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableBlend();
    }

    @Override
    public boolean method_25402(double mouseX, double mouseY, int button) {
        boolean result;
        if (button != 0 || !this.playing) {
            return false;
        }
        Vector2d vector2d = new Vector2d(mouseX, mouseY);
        Vector2d center = new Vector2d((double)((float)this.method_46426() + (float)this.field_22758 / 2.0f), (double)((float)this.method_46427() + (float)this.field_22759 / 2.0f));
        double distance = vector2d.distance((Vector2dc)center);
        if (distance > (double)((float)this.field_22758 / 2.0f)) {
            return false;
        }
        if (this.isArrowHot()) {
            class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_4758((class_3414)class_3417.field_15102, (float)1.25f));
            result = false;
        } else {
            result = this.unlockPin(this.arrowRot);
        }
        if (!result) {
            this.screen.getGame().hurt();
            class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_4758((class_3414)class_3417.field_14808, (float)1.0f));
        }
        this.screen.getGame().processOnClickRules(result);
        if (this.areAllPinsActive()) {
            this.screen.getGame().finish();
        }
        return result;
    }

    public boolean areAllPinsActive() {
        return this.children.stream().filter(rotating -> !(rotating.children.getFirst() instanceof FakePinWidget)).allMatch(rotating -> ((LockPinWidget)((Object)((Object)rotating.children.getFirst()))).active);
    }

    public boolean unlockPin(float arrowAngle) {
        double angle = GearMechanismWidget.normalizeAngle(arrowAngle - this.rot);
        Optional<RotatingParent> optional = this.children.stream().filter(rotatingParent -> GearMechanismWidget.roughlyEquals(GearMechanismWidget.normalizeAngle(rotatingParent.rot), angle, 10.0)).findFirst();
        if (optional.isEmpty()) {
            return false;
        }
        boolean result = ((LockPinWidget)((Object)optional.get().children.getFirst())).activate();
        if (result) {
            class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_47978((class_6880)class_3417.field_15015, (float)1.5f));
        }
        return result;
    }

    private static boolean roughlyEquals(double first, double second, double margin) {
        double diff = Math.abs(first - second);
        return (diff = Math.min(diff, 360.0 - diff)) <= margin;
    }

    private static double normalizeAngle(double angle) {
        if ((angle %= 360.0) < 0.0) {
            angle += 360.0;
        }
        return angle;
    }

    public void flipArrowDirection() {
        if (!this.playing) {
            return;
        }
        this.arrowTween.kill();
        this.arrowTween = Tween.create();
        this.arrowTween.tweenMethod(this::setArrowSpeed, (Object)Float.valueOf(this.arrowSpeed), (Object)Float.valueOf(this.maxArrowSpeed * (float)(-GearMechanismWidget.sign(this.arrowSpeed))), 0.5);
        this.arrowTween.start();
    }

    public void rotateGear(float degrees) {
        if (!this.playing) {
            return;
        }
        this.gearTween.kill();
        this.gearTween = Tween.create();
        this.gearTween.tweenRunnable(() -> class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_4758((class_3414)class_3417.field_16865, (float)0.3f))).setDelay(0.5);
        this.gearTween.parallel().tweenMethod(this::setRot, (Object)Float.valueOf(this.rot), (Object)Float.valueOf(this.rot + degrees), 4.0).setEaseType(EaseType.EASE_IN_OUT).setTransitionType(TransitionType.QUART);
        this.gearTween.start();
    }

    public void deactivateAllPins() {
        this.method_25396().forEach(child -> {
            if (!(child.children.getFirst() instanceof FakePinWidget)) {
                ((LockPinWidget)((Object)((Object)child.children.getFirst()))).deactivate();
            }
        });
    }

    @Override
    public void killTweens() {
        this.gearTween.kill();
        this.arrowTween.kill();
        this.mainTween.kill();
        this.selfDestructionTween.kill();
    }

    public static int sign(double value) {
        return value >= 0.0 ? 1 : -1;
    }

    public void method_4622() {
        if (!this.isArrowHot()) {
            return;
        }
        float x = (float)this.method_46426() + (float)this.field_22758 / 2.0f + this.random.nextFloat(-3.0f, 3.0f);
        float y = (float)this.method_46427() + (float)this.field_22759 / 2.0f + this.random.nextFloat(-3.0f, 3.0f);
        for (int i = 0; i < 3; ++i) {
            Vector2f bananarotate = VectorUtils.rotate((Vector2f)new Vector2f(0.0f, this.random.nextFloat(30.0f, 35.0f)), (float)this.arrowRot);
            ExtendedUIParticle particle = new ExtendedUIParticle(new UIParticle.Texture2D(Clavis.path("textures/particle/pixel.png"), 1, 1), 0.4f, this.random.nextInt(10, 30), x + bananarotate.x, y + bananarotate.y, UIParticle.Layer.SCREEN, 0.0f);
            particle.setScreen((class_437)this.screen);
            particle.setColors(new OctoColor[]{OctoColor.RED, OctoColor.RED, new OctoColor(1.0f, 1.0f, 0.0f, 1.0f), OctoColor.WHITE, new OctoColor(0.05f, 0.05f, 0.05f, 1.0f)});
            particle.setDirection(new Vector2f(this.random.nextFloat() - 0.5f, this.random.nextFloat() - 0.5f).normalize());
            particle.setGravityDirection(new Vector2f(0.0f, -1.0f));
            particle.setGravity(0.15f);
            float size = this.random.nextFloat(0.75f, 1.5f);
            particle.getTransform().setSize(new Vector2f(size, size));
            particle.setRollVelocity(this.random.nextFloat(-10.0f, 10.0f));
            particle.instantiate();
        }
    }

    public void setGameColor(OctoColor gameColor) {
        this.gameColor = gameColor;
    }

    public void setArrowSpeed(float arrowSpeed) {
        this.arrowSpeed = arrowSpeed;
    }

    public float getArrowSpeed() {
        return this.arrowSpeed;
    }

    public float getMaxArrowSpeed() {
        return this.maxArrowSpeed;
    }

    public List<Integer> getFreeSpots() {
        return this.freeSpots;
    }

    public int getMaxSpots() {
        return this.maxSpots;
    }

    public void setArrowTemperature(float arrowTemperature) {
        this.arrowTemperature = arrowTemperature;
    }

    public void setWarningVisibility(float warningVisibility) {
        this.warningVisibility = warningVisibility;
    }
}

