/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.shatterbyte.clavis.common.client.screen.widget;

import com.mojang.blaze3d.systems.RenderSystem;
import it.hurts.shatterbyte.clavis.common.Clavis;
import it.hurts.shatterbyte.clavis.common.client.screen.LockpickingScreen;
import it.hurts.shatterbyte.clavis.common.data.MinigameStyleData;
import it.hurts.shatterbyte.clavis.common.data.TooltipInfoData;
import it.hurts.shatterbyte.clavis.common.minigame.Minigame;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import net.minecraft.class_1144;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_3532;
import net.minecraft.class_6382;

public class MinigameInfoWidget
extends class_339 {
    public static final class_2960 EASY = Clavis.path("textures/icon/easy.png");
    public static final class_2960 MEDIUM = Clavis.path("textures/icon/medium.png");
    public static final class_2960 HARD = Clavis.path("textures/icon/hard.png");
    public static final class_2960 TIME = Clavis.path("textures/icon/time.png");
    public static final class_2960 QUALITY = Clavis.path("textures/icon/quality.png");
    public final class_2960 STAT_BG;
    TooltipInfoData difficultyInfo;
    TooltipInfoData timeInfo;
    TooltipInfoData qualityInfo;
    Minigame<?> game;
    MinigameStyleData styleData;

    public MinigameInfoWidget(Minigame<?> game, MinigameStyleData styleData) {
        super(0, 0, 160, 16, (class_2561)class_2561.method_43473());
        this.game = game;
        this.styleData = styleData;
        this.STAT_BG = Clavis.path(game.getMinigameType().method_12836(), "textures/lockpicking/" + game.getMinigameType().method_12832() + "/stat_background.png");
        class_327 font = class_310.method_1551().field_1772;
        this.difficultyInfo = new TooltipInfoData(font, "difficulty", Math.round(170.66667f));
        this.timeInfo = new TooltipInfoData(font, "time", Math.round(170.66667f));
        this.qualityInfo = new TooltipInfoData(font, "quality", Math.round(170.66667f));
    }

    protected void method_48579(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        float difficulty = this.game.getDifficulty();
        long tickCount = this.game.getTickCount();
        float lootQuality = this.game.getLootQuality();
        float mouseHovered = Math.clamp((float)(mouseX - this.method_46426()) / (float)this.method_25368(), 0.0f, 1.0f);
        boolean difficultyHovered = this.method_49606() && mouseHovered < 0.33f;
        boolean timeHovered = this.method_49606() && mouseHovered >= 0.33f && mouseHovered < 0.66f;
        boolean qualityHovered = this.method_49606() && mouseHovered >= 0.66f;
        class_327 font = class_310.method_1551().field_1772;
        LocalTime time = LocalTime.ofSecondOfDay(class_3532.method_15375((float)((float)tickCount / 20.0f)));
        String timeString = time.format(DateTimeFormatter.ISO_LOCAL_TIME);
        if (timeString.startsWith("00:")) {
            timeString = timeString.substring(3);
        }
        class_2960 difficultyIcon = difficulty < 0.33f ? EASY : (difficulty < 0.66f ? MEDIUM : HARD);
        guiGraphics.method_51448().method_22903();
        guiGraphics.method_51448().method_46416((float)this.method_46426(), (float)this.method_46427(), 1.0f);
        this.renderStat(guiGraphics, difficultyHovered, Math.round(difficulty * 100.0f) + "%", font, difficultyIcon);
        guiGraphics.method_51448().method_46416(54.0f, 0.0f, 0.0f);
        this.renderStat(guiGraphics, timeHovered, timeString, font, TIME);
        guiGraphics.method_51448().method_46416(54.0f, 0.0f, 0.0f);
        this.renderStat(guiGraphics, qualityHovered, Math.round(lootQuality * 100.0f) + "%", font, QUALITY);
        guiGraphics.method_51448().method_22909();
        boolean isDescription = LockpickingScreen.method_25442();
        guiGraphics.method_51448().method_22903();
        guiGraphics.method_51448().method_46416(0.0f, 0.0f, 20.0f);
        if (qualityHovered) {
            LockpickingScreen.renderTooltip(this.game.getMinigameType(), font, this.qualityInfo, guiGraphics, mouseX, mouseY, partialTick, isDescription);
        } else if (timeHovered) {
            LockpickingScreen.renderTooltip(this.game.getMinigameType(), font, this.timeInfo, guiGraphics, mouseX, mouseY, partialTick, isDescription);
        } else if (difficultyHovered) {
            LockpickingScreen.renderTooltip(this.game.getMinigameType(), font, this.difficultyInfo, guiGraphics, mouseX, mouseY, partialTick, isDescription);
        }
        guiGraphics.method_51448().method_22909();
    }

    private void renderStat(class_332 guiGraphics, boolean isHovered, String string, class_327 font, class_2960 icon) {
        if (isHovered) {
            guiGraphics.method_51737(0, 0, 52, 16, 0, this.styleData.getTitleColor());
            guiGraphics.method_51737(-1, 0, 53, 16, 0, this.styleData.getTitleColor());
            guiGraphics.method_51737(0, -1, 52, 17, 0, this.styleData.getTitleColor());
        }
        guiGraphics.method_25293(this.STAT_BG, 0, 0, 52, 16, 0.0f, 0.0f, 52, 16, 52, 16);
        RenderSystem.enableBlend();
        guiGraphics.method_25293(icon, 2, 2, 12, 13, 0.0f, 0.0f, 12, 13, 12, 13);
        RenderSystem.disableBlend();
        guiGraphics.method_51448().method_22903();
        guiGraphics.method_51448().method_22904(18.0, 5.5, 0.0);
        guiGraphics.method_51448().method_22905(0.75f, 0.75f, 1.0f);
        guiGraphics.method_51439(font, (class_2561)class_2561.method_43470((String)string).method_27692(class_124.field_1067), 0, 0, this.styleData.getTitleColor(), false);
        guiGraphics.method_51448().method_22909();
    }

    public void method_25354(class_1144 handler) {
    }

    protected void method_47399(class_6382 narrationElementOutput) {
    }
}

