/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.shatterbyte.clavis.common.minigame;

import it.hurts.shatterbyte.clavis.common.Clavis;
import it.hurts.shatterbyte.clavis.common.client.screen.widget.AbstractMinigameWidget;
import it.hurts.shatterbyte.clavis.common.client.screen.widget.MirrorWidget;
import it.hurts.shatterbyte.clavis.common.data.Lock;
import it.hurts.shatterbyte.clavis.common.minigame.rule.EndRules;
import it.hurts.shatterbyte.clavis.common.minigame.rule.Rule;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_1937;
import net.minecraft.class_2960;

public class Minigame<T extends AbstractMinigameWidget<?>> {
    class_2960 minigameType;
    T widget;
    List<Rule<T>> rules = new ArrayList<Rule<T>>();
    float difficulty;
    int health = 5;
    long tickCount;
    float lootQuality;
    long seed;

    public Minigame(T widget) {
        this.widget = widget;
        this.difficulty = 1.0f;
        this.lootQuality = Clavis.CONFIG.getStartingQuality();
    }

    public void hurt() {
        --this.health;
        this.lootQuality -= Clavis.CONFIG.getQualityPenaltyPerHit();
        ((AbstractMinigameWidget)((Object)this.widget)).getScreen().animateHeart();
        if (this.health <= 0) {
            this.lose();
            return;
        }
        ((AbstractMinigameWidget)((Object)this.widget)).playHurtAnimation();
    }

    public void lose() {
        ((AbstractMinigameWidget)((Object)this.widget)).playLoseAnimation();
    }

    public void finish() {
        ((AbstractMinigameWidget)((Object)this.widget)).playWinAnimation();
    }

    public void processOnTickRules() {
        this.rules.forEach(rule -> {
            if (rule.getEveryTick() != null) {
                rule.getEveryTick().accept(this.widget, this.tickCount);
            }
        });
        ++this.tickCount;
    }

    public void processOnCreateRules() {
        this.rules.forEach(rule -> {
            if (rule.getOnCreate() != null) {
                rule.getOnCreate().accept(this.widget);
            }
        });
    }

    public void processOnClickRules(boolean result) {
        boolean shouldSwap = false;
        for (Rule<T> rule : this.rules) {
            if (rule.equals(EndRules.SWAP)) {
                shouldSwap = true;
                continue;
            }
            if (rule.getOnClick() == null) continue;
            rule.getOnClick().accept(this.widget, result);
        }
        if (shouldSwap) {
            EndRules.SWAP.getOnClick().accept((MirrorWidget)((Object)this.widget), result);
        }
    }

    public void load(Lock lock, class_1937 level) {
        this.difficulty = lock.getDifficulty();
        this.seed = lock.getSeed();
        this.minigameType = lock.getType(level);
        if (!lock.getRules().isEmpty()) {
            this.rules.addAll(lock.getRules().stream().map(id -> Rule.getRegisteredRule(id)).filter(Objects::nonNull).toList());
        }
    }

    @SafeVarargs
    public final void addRules(Rule<T> ... rules) {
        this.rules.addAll(Arrays.asList(rules));
    }

    public final void addRules(List<Rule<T>> rules) {
        this.rules.addAll(rules);
    }

    public class_2960 getMinigameType() {
        return this.minigameType;
    }

    public List<Rule<T>> getRules() {
        return this.rules;
    }

    public float getDifficulty() {
        return this.difficulty;
    }

    public int getHealth() {
        return this.health;
    }

    public long getTickCount() {
        return this.tickCount;
    }

    public float getLootQuality() {
        return this.lootQuality;
    }

    public long getSeed() {
        return this.seed;
    }
}

