/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.shatterbyte.clavis.common.network.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.LongArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import it.hurts.shatterbyte.clavis.common.LockManager;
import it.hurts.shatterbyte.clavis.common.data.Box;
import it.hurts.shatterbyte.clavis.common.data.Lock;
import it.hurts.shatterbyte.clavis.common.data.LootUtils;
import it.hurts.shatterbyte.clavis.common.registry.MinigameTypeRegistry;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.class_124;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2232;
import net.minecraft.class_2262;
import net.minecraft.class_2280;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import net.minecraft.class_7157;
import net.minecraft.class_8934;

public class ClavisCommands {
    public static void register(CommandDispatcher<class_2168> dispatcher, class_7157 commandBuildContext, class_2170.class_5364 commandSelection) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"clavis").requires(source -> source.method_9259(2))).then(class_2170.method_9247((String)"calculate").then(class_2170.method_9244((String)"blockpos", (ArgumentType)class_2262.method_9698()).then(class_2170.method_9244((String)"iterations", (ArgumentType)IntegerArgumentType.integer((int)0, (int)100)).executes(context -> {
            class_3218 level = ((class_2168)context.getSource()).method_9225();
            class_2338 pos = ((class_2280)context.getArgument("blockpos", class_2280.class)).method_9704((class_2168)context.getSource());
            int iterations = (Integer)context.getArgument("iterations", Integer.class);
            class_2586 blockEntity = level.method_8321(pos);
            if (!(blockEntity instanceof class_8934)) {
                ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)"Not a randomizable container!"));
                return 1;
            }
            class_8934 rbe = (class_8934)blockEntity;
            float difficulty = (float)LootUtils.calculateDifficulty(((class_2168)context.getSource()).method_9225(), pos, rbe, iterations, true, (class_2168)context.getSource());
            class_5250 component = class_2561.method_43470((String)"Difficulty: ").method_10852((class_2561)class_2561.method_43470((String)(String.format("%.1f", Float.valueOf(difficulty * 100.0f)) + "%")).method_54663(LootUtils.getColorForDifficulty(difficulty)));
            ((class_2168)context.getSource()).method_45068((class_2561)component);
            return 1;
        }))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"lock").then(class_2170.method_9247((String)"add").then(class_2170.method_9244((String)"type", (ArgumentType)class_2232.method_9441()).suggests((ctx, builder) -> class_2172.method_9264(MinigameTypeRegistry.REGISTRY.stream().map(class_2960::toString), (SuggestionsBuilder)builder)).then(class_2170.method_9244((String)"difficulty", (ArgumentType)FloatArgumentType.floatArg((float)0.0f)).then(class_2170.method_9244((String)"seed", (ArgumentType)LongArgumentType.longArg()).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"perplayer", (ArgumentType)BoolArgumentType.bool()).then(class_2170.method_9244((String)"blockpos", (ArgumentType)class_2262.method_9698()).executes(context -> {
            class_2960 type = (class_2960)context.getArgument("type", class_2960.class);
            if (!MinigameTypeRegistry.REGISTRY.contains(type)) {
                ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)("Non-existent minigame type: " + type.toString())));
                return 1;
            }
            Lock lock = new Lock(UUID.randomUUID(), new Box((class_2382)((class_2280)context.getArgument("blockpos", class_2280.class)).method_9704((class_2168)context.getSource())), ((Float)context.getArgument("difficulty", Float.class)).floatValue(), (Long)context.getArgument("seed", Long.class), (Boolean)context.getArgument("perplayer", Boolean.class), new ArrayList<class_2960>(), type);
            LockManager.addLock(((class_2168)context.getSource()).method_9225(), lock);
            return 1;
        }))).then(class_2170.method_9244((String)"blockpos2", (ArgumentType)class_2262.method_9698()).executes(context -> {
            class_2960 type = (class_2960)context.getArgument("type", class_2960.class);
            if (!MinigameTypeRegistry.REGISTRY.contains(type)) {
                ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)("Non-existent minigame type: " + type.toString())));
                return 1;
            }
            Lock lock = new Lock(UUID.randomUUID(), new Box((class_2382)((class_2280)context.getArgument("blockpos", class_2280.class)).method_9704((class_2168)context.getSource()), (class_2382)((class_2280)context.getArgument("blockpos2", class_2280.class)).method_9704((class_2168)context.getSource())), ((Float)context.getArgument("difficulty", Float.class)).floatValue(), (Long)context.getArgument("seed", Long.class), (Boolean)context.getArgument("perplayer", Boolean.class), new ArrayList<class_2960>(), type);
            LockManager.addLock(((class_2168)context.getSource()).method_9225(), lock);
            return 1;
        })))))))).then(class_2170.method_9247((String)"remove").then(class_2170.method_9244((String)"blockpos", (ArgumentType)class_2262.method_9698()).executes(context -> {
            class_2338 pos = ((class_2280)context.getArgument("blockpos", class_2280.class)).method_9704((class_2168)context.getSource());
            List<Lock> locks = LockManager.getLocksAt(((class_2168)context.getSource()).method_9225(), null, pos);
            if (locks.isEmpty()) {
                ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)"No locks have been found at this position. Aborting..."));
                return 1;
            }
            LockManager.removeLock(((class_2168)context.getSource()).method_9225(), locks.getFirst());
            return 1;
        })))).then(class_2170.method_9247((String)"get").then(class_2170.method_9244((String)"blockpos", (ArgumentType)class_2262.method_9698()).executes(context -> {
            class_2338 pos = ((class_2280)context.getArgument("blockpos", class_2280.class)).method_9704((class_2168)context.getSource());
            List<Lock> locks = LockManager.getLocksAt(((class_2168)context.getSource()).method_9225(), null, pos);
            if (locks.isEmpty()) {
                ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)"No locks have been found at this position. Aborting..."));
                return 1;
            }
            class_5250 component = class_2561.method_43470((String)("Locks at " + pos.method_23854() + ":")).method_27693("\n\n");
            for (Lock lock : locks) {
                component.method_10852((class_2561)class_2561.method_43470((String)(lock.getUuid().toString() + ":")).method_27692(class_124.field_1065)).method_27693("\n");
                component.method_27693("    ").method_10852((class_2561)class_2561.method_43470((String)"Type: ").method_27692(class_124.field_1080)).method_27693(lock.getType((class_1937)((class_2168)context.getSource()).method_9225()).toString()).method_27693("\n");
                component.method_27693("    ").method_10852((class_2561)class_2561.method_43470((String)"Difficulty: ").method_27692(class_124.field_1080)).method_27693(String.format("%.2f", Float.valueOf(lock.getDifficulty()))).method_27693("\n");
                component.method_27693("    ").method_10852((class_2561)class_2561.method_43470((String)"Seed: ").method_27692(class_124.field_1080)).method_27693(String.valueOf(lock.getSeed())).method_27693("\n");
                component.method_27693("    ").method_10852((class_2561)class_2561.method_43470((String)"Per-player: ").method_27692(class_124.field_1080)).method_27693(String.valueOf(lock.isPerPlayer())).method_27693("\n");
            }
            ((class_2168)context.getSource()).method_45068((class_2561)component);
            return 1;
        })))).then(class_2170.method_9247((String)"unlock").then(class_2170.method_9244((String)"blockpos", (ArgumentType)class_2262.method_9698()).then(class_2170.method_9244((String)"quality", (ArgumentType)FloatArgumentType.floatArg((float)0.0f, (float)10.0f)).executes(context -> {
            class_3222 player = ((class_2168)context.getSource()).method_44023();
            if (player == null) {
                ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)"Should be run by a player. Aborting..."));
                return 1;
            }
            class_2338 pos = ((class_2280)context.getArgument("blockpos", class_2280.class)).method_9704((class_2168)context.getSource());
            List<Lock> locks = LockManager.getLocksAt(((class_2168)context.getSource()).method_9225(), player, pos);
            if (locks.isEmpty()) {
                ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)"No locks have been found at this position. Aborting..."));
                return 1;
            }
            LootUtils.unlockWithQuality(((class_2168)context.getSource()).method_9225(), player, pos, locks.getFirst(), ((Float)context.getArgument("quality", Float.class)).floatValue());
            return 1;
        }))))));
    }
}

