/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.shatterbyte.clavis.common;

import dev.architectury.networking.NetworkManager;
import dev.architectury.platform.Platform;
import it.hurts.shatterbyte.clavis.common.client.render.LockWorldRenderer;
import it.hurts.shatterbyte.clavis.common.data.ClavisSavedData;
import it.hurts.shatterbyte.clavis.common.data.Lock;
import it.hurts.shatterbyte.clavis.common.data.UnlockDataStorage;
import it.hurts.shatterbyte.clavis.common.network.packet.RemoveLockPacket;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1657;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5218;
import net.minecraft.class_8710;
import org.jetbrains.annotations.Nullable;

public class LockManager {
    public static UnlockDataStorage UNLOCK_STORAGE;

    public static void addLock(class_3218 level, Lock lock) {
        ClavisSavedData data = ClavisSavedData.get(level);
        data.addLock(lock, level);
    }

    public static void removeLock(class_3218 level, Lock lock) {
        ClavisSavedData data = ClavisSavedData.get(level);
        data.removeLock(lock, level);
    }

    public static void unlock(class_3218 level, @Nullable class_3222 player, Lock lock) {
        if (!lock.isPerPlayer()) {
            LockManager.removeLock(level, lock);
            return;
        }
        if (player == null) {
            return;
        }
        LockManager.UNLOCK_STORAGE.getData().unlockedLocks.computeIfAbsent(player.method_5667(), uuid -> new ArrayList()).add(lock.getUuid());
        NetworkManager.sendToPlayer((class_3222)player, (class_8710)new RemoveLockPacket(lock));
    }

    public static List<Lock> getLocksAt(class_3218 level, @Nullable class_3222 player, class_1923 pos) {
        ClavisSavedData data = ClavisSavedData.get(level);
        List<Lock> locks = data.getLocksAt(pos);
        if (player == null) {
            return locks;
        }
        List unlocked = LockManager.UNLOCK_STORAGE.getData().unlockedLocks.getOrDefault(player.method_5667(), new ArrayList());
        locks.removeIf(lock -> lock.isPerPlayer() && unlocked.contains(lock.getUuid()));
        return locks;
    }

    public static List<Lock> getLocksAt(class_3218 level, @Nullable class_3222 player, class_2338 pos) {
        class_1923 chunkPos = new class_1923(pos);
        List<Lock> chunkLocks = LockManager.getLocksAt(level, player, chunkPos);
        return new ArrayList<Lock>(chunkLocks.stream().filter(lock -> lock.getBox().isInside((class_2382)pos)).toList());
    }

    public static boolean isLocked(class_1937 level, class_1657 player, class_2338 pos) {
        if (level.field_9236) {
            return LockWorldRenderer.FOR_RENDERING.stream().anyMatch(lock -> lock.getBox().isInside((class_2382)pos));
        }
        if (level instanceof class_3218) {
            class_3218 serverLevel = (class_3218)level;
            return !LockManager.getLocksAt(serverLevel, (class_3222)player, pos).isEmpty();
        }
        return false;
    }

    public static void load(class_3218 serverLevel) {
        Path worldFolder = Platform.getGameFolder().resolve(serverLevel.method_8503().method_27050(class_5218.field_24188).getParent());
        UNLOCK_STORAGE = new UnlockDataStorage(worldFolder);
        try {
            UNLOCK_STORAGE.load();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void save(class_3218 serverLevel) {
        if (UNLOCK_STORAGE != null) {
            try {
                UNLOCK_STORAGE.save();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

