/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.shatterbyte.clavis.common.client.render;

import it.hurts.shatterbyte.clavis.common.client.model.LockModel;
import it.hurts.shatterbyte.clavis.common.data.Box;
import it.hurts.shatterbyte.clavis.common.data.Lock;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.class_1921;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_1944;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_265;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4604;
import net.minecraft.class_4608;
import net.minecraft.class_4668;
import net.minecraft.class_638;
import net.minecraft.class_765;
import net.minecraft.class_7833;
import net.minecraft.class_9779;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Vector3f;

public class LockWorldRenderer {
    public static final Function<class_2960, class_1921> LOCK_TYPE = minigameType -> class_1921.method_23578((class_2960)LockModel.getTexture(minigameType));
    public static final Function<class_2960, class_1921> GLOW_TYPE = minigameType -> class_1921.method_24049((String)"clavis_outline", (class_293)class_290.field_1580, (class_293.class_5596)class_293.class_5596.field_27382, (int)1536, (boolean)true, (boolean)false, (class_1921.class_4688)class_1921.class_4688.method_23598().method_23615(class_4668.field_21366).method_34578(class_4668.field_38344).method_23608(class_4668.field_21384).method_23610(class_4668.field_21358).method_51788(class_4668.field_44815).method_23604(class_4668.field_21348).method_23603(class_4668.field_21344).method_23611(class_4668.field_21385).method_23616(new class_4668.class_4686(true, true)).method_34577((class_4668.class_5939)new class_4668.class_4683(LockModel.getTexture(minigameType), false, false)).method_23617(false));
    private static final class_2960 CHAIN_TEXTURE = class_2960.method_60656((String)"textures/block/chain.png");
    public static final class_1921 CHAIN_TYPE = class_1921.method_23578((class_2960)CHAIN_TEXTURE);
    public static final Set<Lock> FOR_RENDERING = new HashSet<Lock>();
    public static final LockModel LOCK = new LockModel(false);
    public static final LockModel GLOW = new LockModel(true);
    public static final float f = 0.0625f;
    public static final float d = 0.06629f;
    public static final float THREE_SIXTEENTH = 0.1875f;

    public static void render(class_4184 camera, Matrix4f modelViewMatrix, class_4587 poseStack, class_9779 partialTick, class_4597 multiBufferSource, class_638 level, class_4604 frustum) {
        if (FOR_RENDERING.isEmpty()) {
            return;
        }
        List<LockRenderData> dataList = FOR_RENDERING.stream().filter(lock -> {
            Box b = lock.getBox();
            class_243 min = new class_243((double)b.minX, (double)b.minY, (double)b.minZ);
            class_243 max = new class_243((double)(b.maxX + 1), (double)(b.maxY + 1), (double)(b.maxZ + 1));
            return frustum.method_23093(new class_238(min, max.method_1031(0.0, 1.0, 0.0)));
        }).map(lock -> {
            class_2338 blockPos;
            class_265 shape;
            Box b = lock.getBox();
            class_243 max = new class_243((double)(b.maxX + 1), (double)(b.maxY + 1), (double)(b.maxZ + 1));
            class_243 min = new class_243((double)b.minX, (double)b.minY, (double)b.minZ);
            if (max.method_1020(min).equals((Object)new class_243(1.0, 1.0, 1.0)) && !(shape = level.method_8320(blockPos = new class_2338((int)min.field_1352, (int)min.field_1351, (int)min.field_1350)).method_26218((class_1922)level, blockPos)).method_1110()) {
                class_238 bounds = shape.method_1107();
                min = bounds.method_61125().method_1019(class_243.method_24954((class_2382)blockPos));
                max = bounds.method_61126().method_1019(class_243.method_24954((class_2382)blockPos));
            }
            class_238 renderBox = new class_238(min, max);
            class_243 center = new class_243(class_3532.method_16436((double)0.5, (double)min.field_1352, (double)max.field_1352), max.field_1351 + 0.5, class_3532.method_16436((double)0.5, (double)min.field_1350, (double)max.field_1350));
            class_2338 pos = new class_2338(class_3532.method_15357((double)center.field_1352), class_3532.method_15357((double)center.field_1351), class_3532.method_15357((double)center.field_1350));
            int sky = level.method_8314(class_1944.field_9284, pos);
            int block = level.method_8314(class_1944.field_9282, pos);
            int light = class_765.method_23687((int)block, (int)sky);
            float hash = new Random(lock.getSeed()).nextFloat() * (float)Math.PI;
            float ticks = ((float)level.method_8510() + partialTick.method_60637(true)) / 10.0f + hash;
            class_265 atLockPos = level.method_8320(pos).method_26218((class_1922)level, pos);
            class_238 lockAABB = new class_238(center, center).method_1009(0.25, 0.5, 0.25);
            return new LockRenderData((Lock)lock, renderBox, center, light, ticks, atLockPos.method_1110() || !atLockPos.method_1107().method_996(pos).method_994(lockAABB), lock.getType((class_1937)level));
        }).toList();
        class_243 camPos = camera.method_19326();
        List<class_2960> types = dataList.stream().map(data -> data.minigameType).distinct().toList();
        for (class_2960 type : types) {
            class_4588 lockBuf = multiBufferSource.getBuffer(LOCK_TYPE.apply(type));
            for (LockRenderData lockRenderData : dataList) {
                if (!lockRenderData.shouldRenderLock || !lockRenderData.minigameType.equals((Object)type)) continue;
                class_243 subtractedPos = lockRenderData.center.method_1020(camPos);
                poseStack.method_22903();
                poseStack.method_22904(subtractedPos.field_1352, subtractedPos.field_1351 + 0.25 + (double)((float)Math.sin(lockRenderData.ticks) * 0.075f), subtractedPos.field_1350);
                poseStack.method_22907(class_7833.field_40716.rotation(lockRenderData.ticks / 2.0f % ((float)Math.PI * 2)));
                LOCK.method_60879(poseStack, lockBuf, lockRenderData.light, class_4608.field_21444);
                poseStack.method_22909();
            }
            class_4588 glowBuf = multiBufferSource.getBuffer(GLOW_TYPE.apply(type));
            for (LockRenderData data3 : dataList) {
                if (!data3.shouldRenderLock || !data3.minigameType.equals((Object)type)) continue;
                class_243 subtractedPos = data3.center.method_1020(camPos);
                int color = data3.lock.getDifficulty() < 0.33f ? -13369566 : (data3.lock.getDifficulty() < 0.66f ? -13312 : -65519);
                poseStack.method_22903();
                poseStack.method_22904(subtractedPos.field_1352, subtractedPos.field_1351 + 0.25 + (double)((float)Math.sin(data3.ticks) * 0.075f), subtractedPos.field_1350);
                poseStack.method_22907(class_7833.field_40716.rotation(data3.ticks / 2.0f % ((float)Math.PI * 2)));
                GLOW.method_2828(poseStack, glowBuf, 0xF000F0, class_4608.field_21444, color);
                poseStack.method_22909();
            }
        }
        Quaternionf xRot = class_7833.field_40714.rotationDegrees(90.0f);
        Quaternionf zRot = class_7833.field_40717.rotationDegrees(90.0f);
        class_4588 chainBuf = multiBufferSource.getBuffer(CHAIN_TYPE);
        for (LockRenderData lockRenderData : dataList) {
            class_243 min = lockRenderData.renderBox.method_61125().method_1020(camPos);
            class_243 max = lockRenderData.renderBox.method_61126().method_1020(camPos);
            float yLen = (float)(max.field_1351 - min.field_1351) + 0.125f;
            float xLen = (float)(max.field_1352 - min.field_1352) + 0.125f;
            float zLen = (float)(max.field_1350 - min.field_1350) + 0.125f;
            int light = lockRenderData.light;
            class_243 subtractedPos = lockRenderData.center.method_1020(camPos);
            LockWorldRenderer.renderChainAt(chainBuf, poseStack, subtractedPos.field_1352, min.field_1351 - 0.0625, min.field_1350 - (double)0.06629f, null, light, yLen);
            LockWorldRenderer.renderChainAt(chainBuf, poseStack, max.field_1352 + (double)0.06629f, min.field_1351 - 0.0625, subtractedPos.field_1350, null, light, yLen);
            LockWorldRenderer.renderChainAt(chainBuf, poseStack, min.field_1352 - (double)0.06629f, min.field_1351 - 0.0625, subtractedPos.field_1350, null, light, yLen);
            LockWorldRenderer.renderChainAt(chainBuf, poseStack, subtractedPos.field_1352, min.field_1351 - 0.0625, max.field_1350 + (double)0.06629f, null, light, yLen);
            LockWorldRenderer.renderChainAt(chainBuf, poseStack, subtractedPos.field_1352, max.field_1351 + (double)0.06629f, min.field_1350 - 0.0625, xRot, light, zLen);
            LockWorldRenderer.renderChainAt(chainBuf, poseStack, min.field_1352 - 0.0625, max.field_1351 + (double)0.06629f, subtractedPos.field_1350, zRot, light, xLen);
            LockWorldRenderer.renderChainAt(chainBuf, poseStack, subtractedPos.field_1352, min.field_1351 - (double)0.06629f, min.field_1350 - 0.0625, xRot, light, zLen);
            LockWorldRenderer.renderChainAt(chainBuf, poseStack, min.field_1352 - 0.0625, min.field_1351 - (double)0.06629f, subtractedPos.field_1350, zRot, light, xLen);
        }
    }

    private static void renderChainAt(class_4588 buf, class_4587 ps, double x, double y, double z, Quaternionf rotation, int light, float length) {
        ps.method_22903();
        ps.method_22904(x, y, z);
        if (rotation != null) {
            ps.method_22907(rotation);
        }
        LockWorldRenderer.renderChain(buf, ps, light, length);
        ps.method_22909();
    }

    private static void renderChain(class_4588 consumer, class_4587 poseStack, int light, float length) {
        float width = 0.1875f;
        poseStack.method_22903();
        poseStack.method_22907(class_7833.field_40716.rotationDegrees(45.0f));
        poseStack.method_22903();
        poseStack.method_46416(-width / 2.0f, 0.0f, 0.0f);
        Matrix4f matrix = poseStack.method_23760().method_23761();
        Matrix3f normalMatrix = poseStack.method_23760().method_23762();
        Vector3f nZ = new Vector3f(0.0f, 0.0f, 1.0f);
        normalMatrix.transform(nZ);
        consumer.method_22918(matrix, 0.0f, 0.0f, 0.0f).method_22915(1.0f, 1.0f, 1.0f, 1.0f).method_22913(0.0f, 0.0f).method_22922(class_4608.field_21444).method_60803(light).method_22914(nZ.x, nZ.y, nZ.z);
        consumer.method_22918(matrix, 0.0f, length, 0.0f).method_22915(1.0f, 1.0f, 1.0f, 1.0f).method_22913(0.0f, length).method_22922(class_4608.field_21444).method_60803(light).method_22914(nZ.x, nZ.y, nZ.z);
        consumer.method_22918(matrix, width, length, 0.0f).method_22915(1.0f, 1.0f, 1.0f, 1.0f).method_22913(width, length).method_22922(class_4608.field_21444).method_60803(light).method_22914(nZ.x, nZ.y, nZ.z);
        consumer.method_22918(matrix, width, 0.0f, 0.0f).method_22915(1.0f, 1.0f, 1.0f, 1.0f).method_22913(width, 0.0f).method_22922(class_4608.field_21444).method_60803(light).method_22914(nZ.x, nZ.y, nZ.z);
        poseStack.method_22909();
        poseStack.method_22903();
        poseStack.method_46416(0.0f, 0.0f, -width / 2.0f);
        matrix = poseStack.method_23760().method_23761();
        normalMatrix = poseStack.method_23760().method_23762();
        Vector3f nX = new Vector3f(1.0f, 0.0f, 0.0f);
        normalMatrix.transform(nX);
        consumer.method_22918(matrix, 0.0f, 0.0f, 0.0f).method_22915(1.0f, 1.0f, 1.0f, 1.0f).method_22913(width, 0.0f).method_22922(class_4608.field_21444).method_60803(light).method_22914(nX.x, nX.y, nX.z);
        consumer.method_22918(matrix, 0.0f, length, 0.0f).method_22915(1.0f, 1.0f, 1.0f, 1.0f).method_22913(width, length).method_22922(class_4608.field_21444).method_60803(light).method_22914(nX.x, nX.y, nX.z);
        consumer.method_22918(matrix, 0.0f, length, width).method_22915(1.0f, 1.0f, 1.0f, 1.0f).method_22913(width * 2.0f, length).method_22922(class_4608.field_21444).method_60803(light).method_22914(nX.x, nX.y, nX.z);
        consumer.method_22918(matrix, 0.0f, 0.0f, width).method_22915(1.0f, 1.0f, 1.0f, 1.0f).method_22913(width * 2.0f, 0.0f).method_22922(class_4608.field_21444).method_60803(light).method_22914(nX.x, nX.y, nX.z);
        poseStack.method_22909();
        poseStack.method_22909();
    }

    public static void clear() {
        FOR_RENDERING.clear();
    }

    private static class LockRenderData {
        final class_243 center;
        final int light;
        final float ticks;
        final Lock lock;
        final class_238 renderBox;
        final boolean shouldRenderLock;
        final class_2960 minigameType;

        LockRenderData(Lock lock, class_238 renderBox, class_243 center, int light, float ticks, boolean shouldRenderLock, class_2960 minigameType) {
            this.lock = lock;
            this.center = center;
            this.light = light;
            this.ticks = ticks;
            this.renderBox = renderBox;
            this.shouldRenderLock = shouldRenderLock;
            this.minigameType = minigameType;
        }
    }
}

