/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.shatterbyte.clavis.common.client.screen.widget;

import com.mojang.blaze3d.systems.RenderSystem;
import it.hurts.octostudios.octolib.client.animation.Tween;
import it.hurts.octostudios.octolib.client.animation.easing.EaseType;
import it.hurts.octostudios.octolib.client.animation.easing.TransitionType;
import it.hurts.octostudios.octolib.client.particle.UIParticle;
import it.hurts.octostudios.octolib.client.screen.widget.Child;
import it.hurts.shatterbyte.clavis.common.Clavis;
import it.hurts.shatterbyte.clavis.common.client.particle.MeteorPartUIParticle;
import it.hurts.shatterbyte.clavis.common.client.screen.widget.FakeMeteorWidget;
import it.hurts.shatterbyte.clavis.common.client.screen.widget.MirrorWidget;
import it.hurts.shatterbyte.clavis.common.registry.SoundEventRegistry;
import net.minecraft.class_1061;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_1144;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_6382;
import net.minecraft.class_7833;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector2d;
import org.joml.Vector2dc;
import org.joml.Vector2f;
import org.joml.Vector2i;

public class MeteorWidget
extends class_339
implements Child<MirrorWidget>,
class_1061 {
    public class_2960 METEOR;
    public class_2960 METEOR_CRACKED;
    public class_2960 METEOR_HOT;
    public class_2960 METEOR_SHINE = Clavis.path("textures/minigame/mirror/meteor_shine.png");
    Tween scaleTween = Tween.create();
    Tween hotTween = Tween.create();
    Vector2f visualSize = new Vector2f(1.0f, 1.0f);
    boolean cracked = false;
    float heatProgress;
    float oldRot;
    float rot;
    float rotSpeed;
    float conservedMomentum = 0.975f;
    int size = 0;
    MirrorWidget parent;
    public Vector2d oldPos;
    public Vector2d precisePosition;
    Vector2d velocity = new Vector2d();

    public MeteorWidget(int x, int y, int size, MirrorWidget parent) {
        super(x, y, 11 + size * 4, 11 + size * 4, (class_2561)class_2561.method_43473());
        this.size = size;
        this.rotSpeed = parent.random.nextFloat(-0.05f, 0.05f);
        this.setParent(parent);
        this.precisePosition = new Vector2d((double)x, (double)y);
        this.oldPos = new Vector2d((double)x, (double)y);
        this.METEOR = Clavis.path("textures/minigame/mirror/meteor_" + size + ".png");
        this.METEOR_CRACKED = Clavis.path("textures/minigame/mirror/meteor_cracked_" + size + ".png");
        this.METEOR_HOT = Clavis.path("textures/minigame/mirror/meteor_hot_" + size + ".png");
    }

    protected void method_48579(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        Vector2i parentPos = this.getParentPosition();
        float partial = class_310.method_1551().method_60646().method_60637(false);
        guiGraphics.method_51448().method_22903();
        guiGraphics.method_51448().method_46416((float)parentPos.x, (float)parentPos.y, 0.0f);
        guiGraphics.method_51448().method_22904(class_3532.method_16436((double)partial, (double)this.oldPos.x, (double)this.precisePosition.x), class_3532.method_16436((double)partial, (double)this.oldPos.y, (double)this.precisePosition.y), 0.0);
        guiGraphics.method_51448().method_46416((float)this.field_22758 / 2.0f, (float)this.field_22759 / 2.0f, 0.0f);
        guiGraphics.method_51448().method_22907(class_7833.field_40718.rotation(class_3532.method_16439((float)partial, (float)this.oldRot, (float)this.rot)));
        guiGraphics.method_51448().method_22905(this.visualSize.x, this.visualSize.y, 1.0f);
        guiGraphics.method_25293(this.cracked ? this.METEOR_CRACKED : this.METEOR, -10, -10, 19, 19, 0.0f, 0.0f, 19, 19, 19, 19);
        if ((double)this.heatProgress > 0.01 && !this.cracked) {
            RenderSystem.enableBlend();
            RenderSystem.setShaderColor((float)this.parent.gameColor.r(), (float)this.parent.gameColor.g(), (float)this.parent.gameColor.b(), (float)(this.heatProgress / (4.0f - (float)this.size)));
            guiGraphics.method_25293(this.METEOR_SHINE, -19, -19, 38, 38, 0.0f, 0.0f, 38, 38, 38, 38);
            RenderSystem.setShaderColor((float)this.parent.gameColor.r(), (float)this.parent.gameColor.g(), (float)this.parent.gameColor.b(), (float)this.heatProgress);
            guiGraphics.method_25293(this.METEOR_HOT, -10, -10, 19, 19, 0.0f, 0.0f, 19, 19, 19, 19);
            RenderSystem.setShaderColor((float)this.parent.gameColor.r(), (float)this.parent.gameColor.g(), (float)this.parent.gameColor.b(), (float)this.parent.gameColor.a());
            RenderSystem.disableBlend();
        }
        guiGraphics.method_51448().method_46416((float)(-this.field_22758) / 2.0f, (float)(-this.field_22759) / 2.0f, 0.0f);
        guiGraphics.method_51448().method_22909();
    }

    protected void method_47399(class_6382 narrationElementOutput) {
    }

    public void method_25354(class_1144 handler) {
        handler.method_4873((class_1113)class_1109.method_4757((class_3414)((class_3414)class_3417.field_15152.comp_349()), (float)1.33f, (float)0.25f));
        handler.method_4873((class_1113)class_1109.method_4757((class_3414)((class_3414)SoundEventRegistry.METEOR_SMASH.get()), (float)0.66f, (float)1.25f));
    }

    public boolean isHot() {
        return this.heatProgress >= 0.6f;
    }

    public void makeItHot() {
        this.heatProgress = 0.0f;
        class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_4758((class_3414)class_3417.field_14703, (float)1.25f));
        this.hotTween.kill();
        this.hotTween = Tween.create();
        this.hotTween.tweenInterval(0.4);
        this.hotTween.tweenRunnable(() -> class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_4758((class_3414)class_3417.field_14993, (float)0.85f)));
        this.hotTween.tweenMethod(this::setHeatProgress, (Object)Float.valueOf(0.0f), (Object)Float.valueOf(1.0f), 1.25).setEaseType(EaseType.EASE_IN_OUT).setTransitionType(TransitionType.QUAD);
        this.hotTween.tweenInterval(1.5);
        this.hotTween.tweenMethod(this::setHeatProgress, (Object)Float.valueOf(1.0f), (Object)Float.valueOf(0.0f), 0.8).setEaseType(EaseType.EASE_OUT).setTransitionType(TransitionType.EXPO);
        this.hotTween.start();
    }

    public void regenerate() {
        if (!this.isCracked()) {
            return;
        }
        this.hotTween.kill();
        this.heatProgress = 0.0f;
        this.scaleTween.kill();
        this.scaleTween = Tween.create();
        this.scaleTween.setTransitionType(TransitionType.QUART);
        this.scaleTween.setEase(EaseType.EASE_IN);
        this.scaleTween.tweenMethod(this::setVisualSize, (Object)new Vector2f(0.95f, 0.95f), (Object)new Vector2f(1.25f, 1.25f), (double)0.275f);
        this.scaleTween.tweenRunnable(() -> {
            this.cracked = false;
            Vector2d center = this.getCenterPos(true);
            for (int i = 0; i < 4 + this.size; ++i) {
                MeteorPartUIParticle particle = new MeteorPartUIParticle(MeteorPartUIParticle.getRandomPart(this.parent.random), 16, (float)center.x, (float)center.y, (float)this.field_22758 * 1.75f, UIParticle.Layer.SCREEN, 1.0f);
                particle.setSpeed(0.75f);
                particle.getDirection().mul(-1.0f);
                particle.setScreen(this.parent.getScreen());
                particle.instantiate();
            }
        });
        this.scaleTween.tweenMethod(this::setVisualSize, (Object)new Vector2f(1.2f, 1.2f), (Object)new Vector2f(1.0f, 1.0f), 0.25).setEaseType(EaseType.EASE_OUT);
        this.scaleTween.start();
    }

    @Nullable
    public MirrorWidget getParent() {
        return this.parent;
    }

    public void setParent(@Nullable MirrorWidget parent) {
        this.parent = parent;
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (this.isCracked()) {
            return false;
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public void method_25348(double mouseX, double mouseY) {
        if (this.isHot()) {
            this.parent.minigame.hurt();
            this.getParent().getMinigame().processOnClickRules(false);
            return;
        }
        this.cracked = true;
        this.hotTween.kill();
        this.heatProgress = 0.0f;
        if (this.getParent().children.stream().filter(meteor -> !(meteor instanceof FakeMeteorWidget)).allMatch(MeteorWidget::isCracked)) {
            this.getParent().playWinAnimation();
            return;
        }
        this.playCrackAnimation();
        this.getParent().getMinigame().processOnClickRules(true);
    }

    public void playCrackAnimation() {
        this.scaleTween.kill();
        this.scaleTween = Tween.create();
        this.scaleTween.setTransitionType(TransitionType.QUART);
        this.scaleTween.setEase(EaseType.EASE_OUT);
        this.scaleTween.tweenMethod(this::setVisualSize, (Object)new Vector2f(1.25f, 1.25f), (Object)new Vector2f(1.0f, 1.0f), 1.0);
        this.scaleTween.start();
        Vector2d center = this.getCenterPos(true);
        for (int i = 0; i < 4 + this.size; ++i) {
            MeteorPartUIParticle particle = new MeteorPartUIParticle(MeteorPartUIParticle.getRandomPart(this.parent.random), 30, (float)center.x, (float)center.y, this.field_22758, UIParticle.Layer.SCREEN, 1.0f);
            particle.setScreen(this.parent.getScreen());
            particle.instantiate();
        }
    }

    public Vector2d getCenterPos(boolean global) {
        Vector2d localCenterPos = new Vector2d((Vector2dc)this.precisePosition).add((double)((float)this.field_22758 / 2.0f), (double)((float)this.field_22759 / 2.0f));
        if (!global) {
            return localCenterPos;
        }
        Vector2i parentPos = this.getParentPosition();
        return localCenterPos.add((double)parentPos.x, (double)parentPos.y);
    }

    private void collide() {
        double objCenterX = this.precisePosition.x + (double)((float)this.method_25368() / 2.0f);
        double objCenterY = this.precisePosition.y + (double)((float)this.method_25364() / 2.0f);
        double dx = objCenterX - (double)((float)this.getParent().method_25368() / 2.0f);
        double dy = objCenterY - (double)((float)this.getParent().method_25364() / 2.0f);
        float dist = (float)Math.sqrt(dx * dx + dy * dy);
        float objRadius = (float)Math.max(this.field_22758, this.field_22759) / 2.0f;
        objRadius += (float)Math.sqrt((float)this.field_22758 / 2.0f * ((float)this.field_22759 / 2.0f) * 2.0f);
        float radius = (float)this.getParent().method_25368() / 2.0f - 6.0f;
        if (dist + (objRadius /= 2.0f) > radius) {
            float overlap = dist + objRadius - radius;
            double normX = dx / (double)dist;
            double normY = dy / (double)dist;
            this.precisePosition.x = objCenterX -= normX * (double)overlap + (double)((float)this.method_25368() / 2.0f);
            this.precisePosition.y = objCenterY -= normY * (double)overlap + (double)((float)this.method_25364() / 2.0f);
            double prevLength = this.velocity.length();
            double dot = this.velocity.x * normX + this.velocity.y * normY;
            this.velocity.x -= 2.0 * dot * normX;
            this.velocity.y -= 2.0 * dot * normY;
            this.velocity.normalize(prevLength * (double)0.925f);
            double tangentX = this.velocity.x - normX * (this.velocity.x * normX + this.velocity.y * normY);
            double tangentY = this.velocity.y - normY * (this.velocity.x * normX + this.velocity.y * normY);
            double tangentialSpeed = Math.sqrt(tangentX * tangentX + tangentY * tangentY);
            this.rotSpeed = -this.rotSpeed;
            this.rotSpeed += (float)(tangentialSpeed * 0.01);
            this.rotSpeed = class_3532.method_15363((float)this.rotSpeed, (float)-0.1f, (float)0.1f);
        }
    }

    public void method_4622() {
        this.oldPos = new Vector2d((Vector2dc)this.precisePosition);
        this.oldRot = this.rot;
        this.rot += this.rotSpeed;
        for (MeteorWidget child : this.getParent().method_25396()) {
            Vector2d otherPos;
            Vector2d thisPos;
            if (child == this || !((thisPos = this.getCenterPos(false)).distance((Vector2dc)(otherPos = child.getCenterPos(false))) < (double)((float)this.field_22758 * 0.9f))) continue;
            this.velocity.add((Vector2dc)thisPos.sub((Vector2dc)otherPos).normalize(0.75));
            child.velocity.sub((Vector2dc)thisPos);
        }
        if (this.velocity.lengthSquared() > 0.005) {
            this.precisePosition.x += this.velocity.x;
            this.precisePosition.y += this.velocity.y;
            this.collide();
        } else if (this.velocity.lengthSquared() != 0.0) {
            this.velocity.mul(0.0);
        }
        this.method_46421((int)this.precisePosition.x);
        this.method_46419((int)this.precisePosition.y);
        this.velocity.mul((double)this.conservedMomentum);
    }

    public void setVisualSize(Vector2f visualSize) {
        this.visualSize = visualSize;
    }

    public boolean isCracked() {
        return this.cracked;
    }

    public void setHeatProgress(float heatProgress) {
        this.heatProgress = heatProgress;
    }

    public Vector2d getVelocity() {
        return this.velocity;
    }
}

