/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.shatterbyte.clavis.common.data;

import com.mojang.serialization.Codec;
import java.util.stream.IntStream;
import net.minecraft.Util;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class Box {
    public static final Codec<Box> CODEC = Codec.INT_STREAM.comapFlatMap(intStream -> Util.fixedSize((IntStream)intStream, (int)6).map(is -> new Box(is[0], is[1], is[2], is[3], is[4], is[5])), box -> IntStream.of(box.minX, box.minY, box.minZ, box.maxX, box.maxY, box.maxZ)).stable();
    public final int minX;
    public final int minY;
    public final int minZ;
    public final int maxX;
    public final int maxY;
    public final int maxZ;

    public Box(int x1, int y1, int z1, int x2, int y2, int z2) {
        this.minX = Math.min(x1, x2);
        this.minY = Math.min(y1, y2);
        this.minZ = Math.min(z1, z2);
        this.maxX = Math.max(x1, x2);
        this.maxY = Math.max(y1, y2);
        this.maxZ = Math.max(z1, z2);
    }

    public Box(Vec3i block) {
        this(block, block);
    }

    public Box(Vec3i start, Vec3i end) {
        this(start.getX(), start.getY(), start.getZ(), end.getX(), end.getY(), end.getZ());
    }

    public boolean isInside(Vec3i block) {
        int x = block.getX();
        int y = block.getY();
        int z = block.getZ();
        return this.minX <= x && x <= this.maxX && this.minY <= y && y <= this.maxY && this.minZ <= z && z <= this.maxZ;
    }

    public boolean intersectsChunk(ChunkPos pos) {
        int minX = pos.getMinBlockX();
        int maxX = pos.getMaxBlockX();
        int minZ = pos.getMinBlockZ();
        int maxZ = pos.getMaxBlockZ();
        return this.minX <= maxX && this.maxX >= minX && this.minZ <= maxZ && this.maxZ >= minZ;
    }

    public AABB getAABB() {
        return new AABB((double)this.minX, (double)this.minY, (double)this.minZ, (double)(this.maxX + 1), (double)(this.maxY + 1), (double)(this.maxZ + 1));
    }

    public Vec3 getCenter() {
        return new Vec3(Mth.lerp((double)0.5, (double)this.minX, (double)(this.maxX + 1)), Mth.lerp((double)0.5, (double)this.minY, (double)(this.maxY + 1)), Mth.lerp((double)0.5, (double)this.minZ, (double)(this.maxZ + 1)));
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Box)) {
            return false;
        }
        Box other = (Box)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.minX != other.minX) {
            return false;
        }
        if (this.minY != other.minY) {
            return false;
        }
        if (this.minZ != other.minZ) {
            return false;
        }
        if (this.maxX != other.maxX) {
            return false;
        }
        if (this.maxY != other.maxY) {
            return false;
        }
        return this.maxZ == other.maxZ;
    }

    protected boolean canEqual(Object other) {
        return other instanceof Box;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.minX;
        result = result * 59 + this.minY;
        result = result * 59 + this.minZ;
        result = result * 59 + this.maxX;
        result = result * 59 + this.maxY;
        result = result * 59 + this.maxZ;
        return result;
    }
}

