/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.shatterbyte.clavis.neoforge;

import com.mojang.authlib.GameProfile;
import it.hurts.shatterbyte.clavis.common.data.LootUtils;
import it.hurts.shatterbyte.clavis.common.mixin.LootPoolAccessor;
import it.hurts.shatterbyte.clavis.common.mixin.LootTableAccessor;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSet;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.neoforged.neoforge.common.util.FakePlayer;

public class PlatformLootImpl {
    private static final UUID DEFAULT_UUID = UUID.fromString("41C82C87-7AfB-4024-BA57-13D2C99CAE77");
    private static final GameProfile DEFAULT_PROFILE = new GameProfile(DEFAULT_UUID, "[Minecraft]");
    private static Map<ServerLevel, Player> PLAYER_CACHE = new HashMap<ServerLevel, Player>();

    public static Player getFakePlayer(ServerLevel level) {
        if (!PLAYER_CACHE.containsKey(level)) {
            PLAYER_CACHE.put(level, (Player)new FakePlayer(level, DEFAULT_PROFILE));
        }
        return PLAYER_CACHE.get(level);
    }

    public static LootTable stripTreasureMaps(LootTable lootTable, ResourceLocation lootTableId) {
        ArrayList<LootPool> filteredPools = new ArrayList<LootPool>();
        LootTableAccessor lootTableAccessor = (LootTableAccessor)lootTable;
        for (LootPool pool : ((LootTableAccessor)lootTable).getPools()) {
            ArrayList<LootPoolEntryContainer> filteredEntries = new ArrayList<LootPoolEntryContainer>();
            LootPoolAccessor accessor = (LootPoolAccessor)pool;
            for (LootPoolEntryContainer entry : accessor.clavis$getEntries()) {
                if (LootUtils.isTreasureMapEntry(entry)) continue;
                filteredEntries.add(entry);
            }
            Constructor constructor = LootPool.class.getDeclaredConstructor(List.class, List.class, List.class, NumberProvider.class, NumberProvider.class, Optional.class);
            constructor.setAccessible(true);
            LootPool lootPool = (LootPool)constructor.newInstance(filteredEntries, accessor.clavis$getConditions(), accessor.clavis$getFunctions(), accessor.clavis$getRolls(), accessor.clavis$getBonusRolls(), Optional.empty());
            if (filteredEntries.isEmpty()) continue;
            filteredPools.add(lootPool);
        }
        Constructor constructor = LootTable.class.getDeclaredConstructor(LootContextParamSet.class, Optional.class, List.class, List.class);
        constructor.setAccessible(true);
        LootTable table = (LootTable)constructor.newInstance(lootTableAccessor.getParamSet(), lootTableAccessor.getRandomSequence(), filteredPools, lootTableAccessor.getFunctions());
        table.setLootTableId(lootTableId);
        return table;
    }
}

