/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.shatterbyte.clavis.common;

import dev.architectury.networking.NetworkManager;
import dev.architectury.platform.Platform;
import it.hurts.shatterbyte.clavis.common.client.render.LockWorldRenderer;
import it.hurts.shatterbyte.clavis.common.data.ClavisSavedData;
import it.hurts.shatterbyte.clavis.common.data.Lock;
import it.hurts.shatterbyte.clavis.common.data.UnlockDataStorage;
import it.hurts.shatterbyte.clavis.common.network.packet.RemoveLockPacket;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.LevelResource;
import org.jetbrains.annotations.Nullable;

public class LockManager {
    public static UnlockDataStorage UNLOCK_STORAGE;

    public static void addLock(ServerLevel level, Lock lock) {
        ClavisSavedData data = ClavisSavedData.get(level);
        data.addLock(lock, level);
    }

    public static void removeLock(ServerLevel level, Lock lock) {
        ClavisSavedData data = ClavisSavedData.get(level);
        data.removeLock(lock, level);
    }

    public static void unlock(ServerLevel level, @Nullable ServerPlayer player, Lock lock) {
        if (!lock.isPerPlayer()) {
            LockManager.removeLock(level, lock);
            return;
        }
        if (player == null) {
            return;
        }
        LockManager.UNLOCK_STORAGE.getData().unlockedLocks.computeIfAbsent(player.getUUID(), uuid -> new ArrayList()).add(lock.getUuid());
        NetworkManager.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new RemoveLockPacket(lock));
    }

    public static List<Lock> getLocksAt(ServerLevel level, @Nullable ServerPlayer player, ChunkPos pos) {
        ClavisSavedData data = ClavisSavedData.get(level);
        List<Lock> locks = data.getLocksAt(pos);
        if (player == null) {
            return locks;
        }
        List unlocked = LockManager.UNLOCK_STORAGE.getData().unlockedLocks.getOrDefault(player.getUUID(), new ArrayList());
        locks.removeIf(lock -> lock.isPerPlayer() && unlocked.contains(lock.getUuid()));
        return locks;
    }

    public static List<Lock> getLocksAt(ServerLevel level, @Nullable ServerPlayer player, BlockPos pos) {
        ChunkPos chunkPos = new ChunkPos(pos);
        List<Lock> chunkLocks = LockManager.getLocksAt(level, player, chunkPos);
        return new ArrayList<Lock>(chunkLocks.stream().filter(lock -> lock.getBox().isInside((Vec3i)pos)).toList());
    }

    public static boolean isLocked(Level level, Player player, BlockPos pos) {
        if (level.isClientSide) {
            return LockWorldRenderer.FOR_RENDERING.stream().anyMatch(lock -> lock.getBox().isInside((Vec3i)pos));
        }
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            return !LockManager.getLocksAt(serverLevel, (ServerPlayer)player, pos).isEmpty();
        }
        return false;
    }

    public static void load(ServerLevel serverLevel) {
        Path worldFolder = Platform.getGameFolder().resolve(serverLevel.getServer().getWorldPath(LevelResource.ROOT).getParent());
        UNLOCK_STORAGE = new UnlockDataStorage(worldFolder);
        try {
            UNLOCK_STORAGE.load();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void save(ServerLevel serverLevel) {
        if (UNLOCK_STORAGE != null) {
            try {
                UNLOCK_STORAGE.save();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

