/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.shatterbyte.clavis.common.client.screen.widget;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import it.hurts.octostudios.octolib.util.RenderUtils;
import it.hurts.shatterbyte.clavis.common.Clavis;
import it.hurts.shatterbyte.clavis.common.client.screen.LockpickingScreen;
import it.hurts.shatterbyte.clavis.common.minigame.rule.Rule;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import org.joml.Vector2i;

public class RuleWidget
extends AbstractWidget {
    public final ResourceLocation BOTTOM;
    public final ResourceLocation FILL;
    public final ResourceLocation SIDE;
    public final ResourceLocation TOP;
    ResourceLocation icon;
    LockpickingScreen screen;
    List<FormattedCharSequence> description;

    public RuleWidget(int x, int y, Rule<?> rule, LockpickingScreen screen) {
        super(x, y, 160, 32, (Component)Component.translatable((String)rule.getLanguageKey(screen.getGame().getMinigameType())).withStyle(ChatFormatting.BOLD));
        ResourceLocation minigameType = screen.getGame().getMinigameType();
        this.screen = screen;
        this.BOTTOM = Clavis.path(minigameType.getNamespace(), "textures/lockpicking/" + minigameType.getPath() + "/bottom.png");
        this.FILL = Clavis.path(minigameType.getNamespace(), "textures/lockpicking/" + minigameType.getPath() + "/fill.png");
        this.SIDE = Clavis.path(minigameType.getNamespace(), "textures/lockpicking/" + minigameType.getPath() + "/side.png");
        this.TOP = Clavis.path(minigameType.getNamespace(), "textures/lockpicking/" + minigameType.getPath() + "/top.png");
        MutableComponent description = Component.translatable((String)rule.getLanguageKey(minigameType, "description"));
        this.description = Minecraft.getInstance().font.split((FormattedText)description, Math.round(202.66667f));
        int lines = this.description.size();
        this.setHeight(Math.max(32, 22 + lines * 8));
        this.icon = ResourceLocation.fromNamespaceAndPath((String)rule.getId().getNamespace(), (String)("textures/icon/rule/" + minigameType.getPath() + "/" + rule.getId().getPath() + ".png"));
    }

    protected void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        Font font = Minecraft.getInstance().font;
        if (this.isHovered()) {
            guiGraphics.fill(this.getX(), this.getY(), this.getX() + this.getWidth(), this.getY() + this.getHeight(), 0, this.screen.getStyleData().getTitleColor());
            guiGraphics.fill(this.getX() - 1, this.getY(), this.getX() + this.getWidth() + 1, this.getY() + this.getHeight(), 0, this.screen.getStyleData().getTitleColor());
            guiGraphics.fill(this.getX(), this.getY() - 1, this.getX() + this.getWidth(), this.getY() + this.getHeight() + 1, 0, this.screen.getStyleData().getTitleColor());
        }
        guiGraphics.pose().pushPose();
        guiGraphics.pose().translate((float)this.getX(), (float)this.getY(), 1.0f);
        guiGraphics.blit(this.TOP, 0, 0, 160, 16, 0.0f, 0.0f, 160, 16, 160, 16);
        guiGraphics.blit(this.icon, 3, 3, 10, 10, 0.0f, 0.0f, 10, 10, 10, 10);
        Vector2i fill = this.screen.getStyleData().getFillTextureSize();
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)this.FILL);
        RenderUtils.renderTilingTexture((PoseStack)guiGraphics.pose(), (float)2.0f, (float)16.0f, (float)0.0f, (float)0.0f, (float)fill.x, (float)fill.y, (float)156.0f, (float)(this.height - 20), (float)0.0f, (boolean)false, (boolean)true);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)this.SIDE);
        RenderUtils.renderTilingTexture((PoseStack)guiGraphics.pose(), (float)0.0f, (float)16.0f, (float)0.0f, (float)0.0f, (float)160.0f, (float)1.0f, (float)160.0f, (float)(this.height - 32), (float)0.0f, (boolean)false, (boolean)true);
        guiGraphics.blit(this.BOTTOM, 0, this.height - 16, 160, 16, 0.0f, 0.0f, 160, 16, 160, 16);
        guiGraphics.pose().pushPose();
        guiGraphics.pose().translate(18.0, 5.5, 0.0);
        guiGraphics.pose().scale(0.75f, 0.75f, 1.0f);
        guiGraphics.drawString(font, this.getMessage(), 0, 0, this.screen.getStyleData().getTitleColor(), true);
        guiGraphics.pose().popPose();
        guiGraphics.pose().pushPose();
        guiGraphics.pose().translate(5.75, 17.75, 0.0);
        int y = 0;
        for (FormattedCharSequence line : this.description) {
            guiGraphics.pose().pushPose();
            guiGraphics.pose().translate(0.0f, (float)y, 0.0f);
            guiGraphics.pose().scale(0.75f, 0.75f, 1.0f);
            guiGraphics.drawString(font, line, 0, 0, this.screen.getStyleData().getDescriptionColor(), false);
            guiGraphics.pose().popPose();
            y += 8;
        }
        guiGraphics.pose().popPose();
        guiGraphics.pose().popPose();
    }

    public void playDownSound(SoundManager handler) {
    }

    protected void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
    }
}

