/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.shatterbyte.clavis.common.data;

import dev.architectury.platform.Platform;
import it.hurts.octostudios.octolib.OctoLib;
import it.hurts.shatterbyte.clavis.common.Clavis;
import it.hurts.shatterbyte.clavis.common.LockManager;
import it.hurts.shatterbyte.clavis.common.LootrCompat;
import it.hurts.shatterbyte.clavis.common.data.ItemValues;
import it.hurts.shatterbyte.clavis.common.data.Lock;
import it.hurts.shatterbyte.clavis.common.mixin.LootPoolAccessor;
import it.hurts.shatterbyte.clavis.common.mixin.LootPoolSingletonContainerAccessor;
import it.hurts.shatterbyte.clavis.common.mixin.LootTableAccessor;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.ChatFormatting;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.RandomizableContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.functions.ExplorationMapFunction;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSet;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class LootUtils {
    private static final long SEED_STEP = 31571L;

    public static void shrinkStacks(ObjectArrayList<ItemStack> stacks, double factor, RandomSource random) {
        if (factor <= 0.0) {
            stacks.clear();
            return;
        }
        for (int i = stacks.size() - 1; i >= 0; --i) {
            ItemStack stack = (ItemStack)stacks.get(i);
            int original = stack.getCount();
            double scaled = (double)original * factor;
            int base = (int)Math.floor(scaled);
            if (random.nextDouble() < scaled - (double)base) {
                ++base;
            }
            if (base <= 0) {
                stacks.remove(i);
                continue;
            }
            stack.setCount(base);
        }
    }

    public static double calculateDifficulty(ServerLevel level, BlockPos pos, RandomizableContainer container, int randomIterations, boolean debug, @Nullable CommandSourceStack source) {
        if (debug) {
            source.sendSystemMessage((Component)Component.literal((String)"CALCULATING..."));
        }
        double value = 0.0;
        int totalIterations = 0;
        Random random = new Random(container.getLootTableSeed());
        ResourceKey lootTableKey = container.getLootTable();
        LootTable rawLootTable = LootUtils.getLootTableSafe(level, (ResourceKey<LootTable>)lootTableKey);
        if (rawLootTable == null || lootTableKey == null) {
            return 0.0;
        }
        LootTable noMapsTable = LootUtils.stripTreasureMaps(rawLootTable);
        LootTableAccessor accessor = (LootTableAccessor)noMapsTable;
        Optional<ResourceLocation> randomSequence = accessor.getRandomSequence();
        LootParams.Builder builder = new LootParams.Builder(level).withParameter(LootContextParams.ORIGIN, (Object)(pos == null ? Vec3.ZERO : Vec3.atCenterOf((Vec3i)pos)));
        Function<Long, LootContext> makeCtx = seed -> new LootContext.Builder(builder.create(LootContextParamSets.CHEST)).withOptionalRandomSeed(seed.longValue()).create(randomSequence);
        do {
            if (debug) {
                source.sendSystemMessage((Component)Component.literal((String)("Iteration: " + totalIterations)).withStyle(new ChatFormatting[]{ChatFormatting.BOLD, ChatFormatting.BLUE}));
            }
            long currentSeed = totalIterations > 0 ? random.nextLong() : container.getLootTableSeed();
            LootContext actualLootContext = makeCtx.apply(currentSeed);
            RandomSource randomSource = actualLootContext.getRandom();
            ObjectArrayList<ItemStack> actualItems = new ObjectArrayList<ItemStack>();
            try {
                actualItems = LootUtils.buildMainItemList(accessor, makeCtx, actualLootContext, currentSeed, 1.0f, randomSource);
            }
            catch (NoSuchElementException e) {
                OctoLib.LOGGER.error("Failed to calculate lock difficulty: {}", (Object)e.getMessage());
            }
            actualItems.size(Math.min(actualItems.size(), container.getContainerSize()));
            double iterationValue = 0.0;
            for (ItemStack stack : actualItems) {
                if (stack == null) continue;
                double stackValue = ItemValues.getValue(stack);
                if (debug) {
                    source.sendSystemMessage((Component)Component.literal((String)"  ").append((Component)stack.getDisplayName().copy().append(" x" + stack.getCount() + ": ").append((Component)Component.literal((String)String.format("%.2f", stackValue)).withStyle(ChatFormatting.GOLD))));
                }
                iterationValue += stackValue;
            }
            if (debug) {
                source.sendSystemMessage((Component)Component.literal((String)("  Iteration " + totalIterations + " value: " + String.format("%.2f", iterationValue))));
            }
            value += iterationValue;
        } while (++totalIterations < randomIterations);
        if (debug) {
            source.sendSystemMessage((Component)Component.literal((String)("Finished iterating. Total value: " + String.format("%.3f", value))));
        }
        value /= (double)totalIterations;
        if (debug) {
            source.sendSystemMessage((Component)Component.literal((String)("Dividing by number of iterations (" + totalIterations + "): " + String.format("%.3f", value))));
        }
        double bottomOffset = Clavis.CONFIG.getItemValueRange().getMin();
        double topValue = Clavis.CONFIG.getItemValueRange().getMax() - bottomOffset;
        double unclampedDifficulty = value / topValue * Clavis.CONFIG.getGlobalDifficultyMultiplier() * Clavis.CONFIG.getLootTableMultiplier().getOrDefault(lootTableKey.location().toString(), 1.0);
        return Math.clamp(unclampedDifficulty, (double)0.01f, Clavis.CONFIG.getUpperDifficultyClamp());
    }

    public static void unlockWithQuality(ServerLevel level, ServerPlayer player, BlockPos blockPos, Lock lock, float quality) {
        long lootTableSeed;
        RandomizableContainerBlockEntity randomizable;
        LockManager.unlock(level, player, lock);
        BlockEntity blockEntity = level.getBlockEntity(blockPos);
        if (!(blockEntity instanceof RandomizableContainerBlockEntity) || (randomizable = (RandomizableContainerBlockEntity)blockEntity).getLootTable() == null) {
            return;
        }
        ResourceKey resourceKey = randomizable.getLootTable();
        LootTable lootTable = LootUtils.getLootTableSafe(level, (ResourceKey<LootTable>)resourceKey);
        if (lootTable == null) {
            OctoLib.LOGGER.warn("loot table not found for {}", (Object)resourceKey);
            return;
        }
        LootTableAccessor accessor = (LootTableAccessor)lootTable;
        CriteriaTriggers.GENERATE_LOOT.trigger(player, resourceKey);
        LootParams.Builder baseBuilder = new LootParams.Builder(level).withParameter(LootContextParams.ORIGIN, (Object)Vec3.atCenterOf((Vec3i)blockPos));
        baseBuilder.withLuck(player.getLuck()).withParameter(LootContextParams.THIS_ENTITY, (Object)player);
        boolean isLootr = LootrCompat.COMPAT.isLootrBlockEntity((BlockEntity)randomizable);
        RandomizableContainerBlockEntity container = isLootr ? LootrCompat.COMPAT.getEmptyInventory((BlockEntity)randomizable, player) : randomizable;
        long l = lootTableSeed = isLootr ? player.getUUID().getLeastSignificantBits() + randomizable.getLootTableSeed() : randomizable.getLootTableSeed();
        if (!isLootr) {
            randomizable.setLootTable(null);
        }
        Function<Long, LootContext> makeCtx = LootUtils.createLootContextFactory(baseBuilder, accessor);
        LootContext defaultContext = makeCtx.apply(lootTableSeed);
        RandomSource randomSource = defaultContext.getRandom();
        ObjectArrayList<ItemStack> mainList = new ObjectArrayList<ItemStack>();
        try {
            mainList = LootUtils.buildMainItemList(accessor, makeCtx, defaultContext, lootTableSeed, quality, randomSource);
        }
        catch (NoSuchElementException e) {
            OctoLib.LOGGER.error("Failed to generate loot: {}", (Object)e.getMessage());
        }
        List<Integer> availableSlots = accessor.invokeGetAvailableSlots((Container)randomizable, randomSource);
        accessor.invokeShuffleAndSplitItems(mainList, availableSlots.size(), randomSource);
        if (container == null) {
            OctoLib.LOGGER.warn("container is null");
            return;
        }
        LootUtils.populateContainerFromList((Container)container, mainList, availableSlots);
        LootrCompat.COMPAT.performOpen((BlockEntity)randomizable, player);
    }

    private static LootTable getLootTableSafe(ServerLevel level, ResourceKey<LootTable> resourceKey) {
        try {
            return level.getServer().reloadableRegistries().getLootTable(resourceKey);
        }
        catch (Exception e) {
            OctoLib.LOGGER.warn("error loading loot table {}: {}", resourceKey, (Object)e.getMessage());
            return null;
        }
    }

    private static Function<Long, LootContext> createLootContextFactory(LootParams.Builder baseBuilder, LootTableAccessor accessor) {
        return seedOffset -> new LootContext.Builder(baseBuilder.create(LootContextParamSets.CHEST)).withOptionalRandomSeed(seedOffset.longValue()).create(accessor.getRandomSequence());
    }

    private static ObjectArrayList<ItemStack> buildMainItemList(LootTableAccessor accessor, Function<Long, LootContext> makeCtx, LootContext defaultContext, long lootTableSeed, float quality, RandomSource randomSource) {
        ObjectArrayList mainList = new ObjectArrayList();
        if (quality >= 1.0f) {
            int fullCopies = (int)quality;
            float fraction = quality - (float)fullCopies;
            for (int i = 0; i < fullCopies; ++i) {
                long seed = lootTableSeed + (long)i * 31571L;
                LootContext fullCtx = makeCtx.apply(seed);
                mainList.addAll(accessor.invokeGetRandomItems(fullCtx));
            }
            if (fraction > 0.0f) {
                long seed = lootTableSeed + 31571L * (long)fullCopies;
                LootContext fracCtx = makeCtx.apply(seed);
                ObjectArrayList<ItemStack> fractionalItems = accessor.invokeGetRandomItems(fracCtx);
                LootUtils.shrinkStacks(fractionalItems, fraction, randomSource);
                mainList.addAll(fractionalItems);
            }
        } else {
            mainList.addAll(accessor.invokeGetRandomItems(defaultContext));
            LootUtils.shrinkStacks((ObjectArrayList<ItemStack>)mainList, quality, randomSource);
        }
        ObjectArrayList aggregated = new ObjectArrayList();
        for (ItemStack stack : mainList) {
            if (stack.isEmpty()) continue;
            boolean merged = false;
            for (ItemStack a : aggregated) {
                if (!ItemStack.isSameItemSameComponents((ItemStack)a, (ItemStack)stack)) continue;
                a.grow(stack.getCount());
                merged = true;
                break;
            }
            if (merged) continue;
            aggregated.add((Object)stack.copy());
        }
        ObjectArrayList finalList = new ObjectArrayList();
        for (ItemStack agg : aggregated) {
            int take;
            int max = agg.getMaxStackSize();
            for (int total = agg.getCount(); total > 0; total -= take) {
                take = Math.min(total, max);
                ItemStack piece = agg.copy();
                piece.setCount(take);
                finalList.add((Object)piece);
            }
        }
        return finalList;
    }

    private static void populateContainerFromList(Container container, ObjectArrayList<ItemStack> items, List<Integer> availableSlots) {
        for (ItemStack itemStack : items) {
            if (availableSlots.isEmpty()) {
                return;
            }
            int slotIndex = availableSlots.removeLast();
            if (itemStack.isEmpty()) {
                container.setItem(slotIndex, ItemStack.EMPTY);
                continue;
            }
            container.setItem(slotIndex, itemStack);
        }
    }

    private static LootTable stripTreasureMaps(LootTable lootTable) {
        ArrayList<LootPool> filteredPools = new ArrayList<LootPool>();
        LootTableAccessor lootTableAccessor = (LootTableAccessor)lootTable;
        for (LootPool pool : ((LootTableAccessor)lootTable).getPools()) {
            LootPool lootPool;
            ArrayList<LootPoolEntryContainer> filteredEntries = new ArrayList<LootPoolEntryContainer>();
            LootPoolAccessor accessor = (LootPoolAccessor)pool;
            for (LootPoolEntryContainer entry : accessor.getEntries()) {
                if (LootUtils.isTreasureMapEntry(entry)) continue;
                filteredEntries.add(entry);
            }
            if (Platform.isNeoForge()) {
                constructor = LootPool.class.getDeclaredConstructor(List.class, List.class, List.class, NumberProvider.class, NumberProvider.class, Optional.class);
                constructor.setAccessible(true);
                lootPool = (LootPool)constructor.newInstance(filteredEntries, accessor.getConditions(), accessor.getFunctions(), accessor.getRolls(), accessor.getBonusRolls(), Optional.empty());
            } else {
                constructor = LootPool.class.getDeclaredConstructor(List.class, List.class, List.class, NumberProvider.class, NumberProvider.class);
                constructor.setAccessible(true);
                lootPool = (LootPool)constructor.newInstance(filteredEntries, accessor.getConditions(), accessor.getFunctions(), accessor.getRolls(), accessor.getBonusRolls());
            }
            if (filteredEntries.isEmpty()) continue;
            filteredPools.add(lootPool);
        }
        Constructor constructor = LootTable.class.getDeclaredConstructor(LootContextParamSet.class, Optional.class, List.class, List.class);
        constructor.setAccessible(true);
        return (LootTable)constructor.newInstance(lootTableAccessor.getParamSet(), lootTableAccessor.getRandomSequence(), filteredPools, lootTableAccessor.getFunctions());
    }

    private static boolean isTreasureMapEntry(LootPoolEntryContainer entry) {
        if (entry instanceof LootItem) {
            LootItem lootItem = (LootItem)entry;
            LootPoolSingletonContainerAccessor containerAccessor = (LootPoolSingletonContainerAccessor)lootItem;
            return containerAccessor.getFunctions().stream().anyMatch(f -> f instanceof ExplorationMapFunction);
        }
        return false;
    }

    public static int getColorForDifficulty(float difficulty) {
        return difficulty < 0.33f ? -13369566 : (difficulty < 0.66f ? -13312 : -65519);
    }
}

