/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.shatterbyte.clavis.common.data;

import it.hurts.shatterbyte.clavis.common.data.UnlockData;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtAccounter;
import net.minecraft.nbt.NbtIo;

public class UnlockDataStorage {
    private static final String FILE_NAME = "unlocked_locks.dat";
    private final Path worldFolder;
    private UnlockData data;

    public UnlockDataStorage(Path worldFolder) {
        this.worldFolder = worldFolder;
    }

    public void load() throws IOException {
        Path file = this.worldFolder.resolve(FILE_NAME);
        if (Files.exists(file, new LinkOption[0])) {
            try (InputStream is = Files.newInputStream(file, new OpenOption[0]);){
                CompoundTag tag = NbtIo.readCompressed((InputStream)is, (NbtAccounter)NbtAccounter.unlimitedHeap());
                this.data = UnlockData.fromNbt(tag);
            }
        } else {
            this.data = new UnlockData();
        }
    }

    public void save() throws IOException {
        Path file = this.worldFolder.resolve(FILE_NAME);
        try (OutputStream os = Files.newOutputStream(file, new OpenOption[0]);){
            NbtIo.writeCompressed((CompoundTag)this.data.toNbt(), (OutputStream)os);
        }
    }

    public UnlockData getData() {
        return this.data;
    }
}

