/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.shatterbyte.clavis.common.network.packet;

import dev.architectury.networking.NetworkManager;
import it.hurts.octostudios.octolib.module.network.Packet;
import it.hurts.shatterbyte.clavis.common.client.ClientMinigameTypeRegistry;
import it.hurts.shatterbyte.clavis.common.client.render.LockWorldRenderer;
import it.hurts.shatterbyte.clavis.common.client.screen.LockpickingScreen;
import it.hurts.shatterbyte.clavis.common.data.Lock;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class RemoveLockPacket
extends Packet {
    public static final CustomPacketPayload.Type<RemoveLockPacket> TYPE = Packet.createType((String)"clavis", (String)"remove_lock");
    public static final StreamCodec<RegistryFriendlyByteBuf, RemoveLockPacket> STREAM_CODEC = Packet.createCodec(RemoveLockPacket::write, RemoveLockPacket::new);
    Lock lock;

    public RemoveLockPacket(RegistryFriendlyByteBuf buf) {
        this.lock = (Lock)buf.readJsonWithCodec(Lock.CODEC);
    }

    public RemoveLockPacket(Lock lock) {
        this.lock = lock;
    }

    public void write(RegistryFriendlyByteBuf buf) {
        buf.writeJsonWithCodec(Lock.CODEC, (Object)this.lock);
    }

    @OnlyIn(value=Dist.CLIENT)
    protected void handleClient(NetworkManager.PacketContext packetContext) {
        Vec3 p;
        int i;
        LockpickingScreen screen;
        Screen screen2 = Minecraft.getInstance().screen;
        if (screen2 instanceof LockpickingScreen && (screen = (LockpickingScreen)screen2).getLock().equals(this.lock)) {
            Minecraft.getInstance().setScreen(null);
        }
        if (!LockWorldRenderer.FOR_RENDERING.remove(this.lock)) {
            return;
        }
        ClientLevel level = (ClientLevel)packetContext.getPlayer().level();
        Vec3 pos = this.lock.getBox().getCenter();
        AABB aabb = this.lock.getBox().getAABB();
        Random random = new Random();
        level.playSound(packetContext.getPlayer(), pos.x, pos.y, pos.z, SoundEvents.CHAIN_BREAK, SoundSource.BLOCKS, 1.0f, 1.125f);
        for (i = 0; i < 4; ++i) {
            p = new Vec3(pos.x, aabb.maxY + (double)0.35f, pos.z);
            level.addParticle(ClientMinigameTypeRegistry.getLockParticles(this.lock.getType((Level)level)), p.x, p.y, p.z, (double)random.nextFloat(-0.15f, 0.15f), (double)random.nextFloat(-0.15f, random.nextFloat(-0.15f, 0.15f)), 0.0);
        }
        for (i = 0; i < 50; ++i) {
            p = new Vec3(Mth.lerp((double)random.nextFloat(), (double)aabb.minX, (double)aabb.maxX), Mth.lerp((double)random.nextFloat(), (double)aabb.minY, (double)aabb.maxY), Mth.lerp((double)random.nextFloat(), (double)aabb.minZ, (double)aabb.maxZ));
            level.addParticle((ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, Blocks.CHAIN.defaultBlockState()), p.x, p.y, p.z, (double)random.nextFloat(-0.15f, 0.15f), (double)random.nextFloat(-0.15f, random.nextFloat(-0.15f, 0.15f)), 0.0);
        }
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

