/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.shatterbyte.clavis.common.data;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.hurts.shatterbyte.clavis.common.Clavis;
import it.hurts.shatterbyte.clavis.common.data.Box;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_4844;

public class Lock {
    public static final class_2960 DEFAULT = Clavis.path("default");
    public static final Codec<Lock> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_4844.field_25122.fieldOf("uuid").forGetter(lock -> lock.uuid), (App)Box.CODEC.fieldOf("box").forGetter(lock -> lock.box), (App)Codec.FLOAT.fieldOf("difficulty").forGetter(lock -> Float.valueOf(lock.difficulty)), (App)Codec.LONG.fieldOf("seed").forGetter(lock -> lock.seed), (App)Codec.BOOL.fieldOf("perPlayer").forGetter(lock -> lock.perPlayer), (App)class_2960.field_25139.listOf().optionalFieldOf("rules", new ArrayList()).forGetter(lock -> lock.rules), (App)class_2960.field_25139.optionalFieldOf("type", (Object)DEFAULT).forGetter(lock -> lock.type)).apply((Applicative)instance, Lock::new));
    public static final Codec<Set<Lock>> SET_CODEC = CODEC.listOf().xmap(HashSet::new, ArrayList::new);
    UUID uuid;
    Box box;
    float difficulty;
    long seed;
    boolean perPlayer;
    class_2960 type;
    List<class_2960> rules;

    public class_2960 getType(class_1937 level) {
        return this.type.equals((Object)DEFAULT) ? class_2960.method_60654((String)Clavis.CONFIG.getMinigameType().getOrDefault(level.method_27983().method_29177().toString(), "clavis:gear")) : this.type;
    }

    public Lock(UUID uuid, Box box, float difficulty, long seed, boolean perPlayer) {
        this.uuid = uuid;
        this.box = box;
        this.difficulty = difficulty;
        this.seed = seed;
        this.perPlayer = perPlayer;
        this.type = DEFAULT;
        this.rules = new ArrayList<class_2960>();
    }

    public Lock(UUID uuid, Box box, float difficulty, long seed, boolean perPlayer, List<class_2960> rules, class_2960 type) {
        this.uuid = uuid;
        this.box = box;
        this.difficulty = difficulty;
        this.seed = seed;
        this.perPlayer = perPlayer;
        this.type = type;
        this.rules = rules;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Lock)) {
            return false;
        }
        Lock other = (Lock)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Float.compare(this.getDifficulty(), other.getDifficulty()) != 0) {
            return false;
        }
        if (this.getSeed() != other.getSeed()) {
            return false;
        }
        if (this.isPerPlayer() != other.isPerPlayer()) {
            return false;
        }
        UUID this$uuid = this.getUuid();
        UUID other$uuid = other.getUuid();
        if (this$uuid == null ? other$uuid != null : !((Object)this$uuid).equals(other$uuid)) {
            return false;
        }
        Box this$box = this.getBox();
        Box other$box = other.getBox();
        if (this$box == null ? other$box != null : !((Object)this$box).equals(other$box)) {
            return false;
        }
        class_2960 this$type = this.type;
        class_2960 other$type = other.type;
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        List<class_2960> this$rules = this.getRules();
        List<class_2960> other$rules = other.getRules();
        return !(this$rules == null ? other$rules != null : !((Object)this$rules).equals(other$rules));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Lock;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Float.floatToIntBits(this.getDifficulty());
        long $seed = this.getSeed();
        result = result * 59 + (int)($seed >>> 32 ^ $seed);
        result = result * 59 + (this.isPerPlayer() ? 79 : 97);
        UUID $uuid = this.getUuid();
        result = result * 59 + ($uuid == null ? 43 : ((Object)$uuid).hashCode());
        Box $box = this.getBox();
        result = result * 59 + ($box == null ? 43 : ((Object)$box).hashCode());
        class_2960 $type = this.type;
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        List<class_2960> $rules = this.getRules();
        result = result * 59 + ($rules == null ? 43 : ((Object)$rules).hashCode());
        return result;
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public Box getBox() {
        return this.box;
    }

    public float getDifficulty() {
        return this.difficulty;
    }

    public long getSeed() {
        return this.seed;
    }

    public boolean isPerPlayer() {
        return this.perPlayer;
    }

    public List<class_2960> getRules() {
        return this.rules;
    }
}

