/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.shatterbyte.clavis.common.data;

import it.hurts.octostudios.octolib.OctoLib;
import it.hurts.shatterbyte.clavis.common.data.UnlockData;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import net.minecraft.class_2487;
import net.minecraft.class_2505;
import net.minecraft.class_2507;

public class UnlockDataStorage {
    private static final String FILE_NAME = "unlocked_locks.dat";
    private final Path worldFolder;
    private UnlockData data;

    public UnlockDataStorage(Path worldFolder) {
        this.worldFolder = worldFolder;
    }

    public void load() throws IOException {
        Path file = this.worldFolder.resolve(FILE_NAME);
        if (Files.exists(file, new LinkOption[0])) {
            try (InputStream is = Files.newInputStream(file, new OpenOption[0]);){
                class_2487 tag = class_2507.method_10629((InputStream)is, (class_2505)class_2505.method_53898());
                this.data = UnlockData.fromNbt(tag);
            }
            catch (IOException e) {
                OctoLib.LOGGER.warn("Unlock data is corrupted, creating new...");
                this.data = new UnlockData();
            }
        } else {
            this.data = new UnlockData();
        }
        this.save();
    }

    public void save() throws IOException {
        if (this.data == null) {
            this.load();
        }
        Path file = this.worldFolder.resolve(FILE_NAME);
        try (OutputStream os = Files.newOutputStream(file, new OpenOption[0]);){
            class_2507.method_10634((class_2487)this.data.toNbt(), (OutputStream)os);
        }
    }

    public UnlockData getData() {
        return this.data;
    }
}

