/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.shatterbyte.clavis.common.data;

import dev.architectury.platform.Platform;
import it.hurts.octostudios.octolib.OctoLib;
import it.hurts.shatterbyte.clavis.common.Clavis;
import it.hurts.shatterbyte.clavis.common.LockManager;
import it.hurts.shatterbyte.clavis.common.LootrCompat;
import it.hurts.shatterbyte.clavis.common.data.ItemValues;
import it.hurts.shatterbyte.clavis.common.data.Lock;
import it.hurts.shatterbyte.clavis.common.mixin.LootPoolAccessor;
import it.hurts.shatterbyte.clavis.common.mixin.LootPoolSingletonContainerAccessor;
import it.hurts.shatterbyte.clavis.common.mixin.LootTableAccessor;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.class_111;
import net.minecraft.class_124;
import net.minecraft.class_1263;
import net.minecraft.class_173;
import net.minecraft.class_174;
import net.minecraft.class_176;
import net.minecraft.class_1799;
import net.minecraft.class_181;
import net.minecraft.class_2168;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2621;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_47;
import net.minecraft.class_52;
import net.minecraft.class_5321;
import net.minecraft.class_55;
import net.minecraft.class_5658;
import net.minecraft.class_5819;
import net.minecraft.class_77;
import net.minecraft.class_79;
import net.minecraft.class_8567;
import net.minecraft.class_8934;
import org.jetbrains.annotations.Nullable;

public class LootUtils {
    private static final long SEED_STEP = 31571L;

    public static void shrinkStacks(ObjectArrayList<class_1799> stacks, double factor, class_5819 random) {
        if (factor <= 0.0) {
            stacks.clear();
            return;
        }
        for (int i = stacks.size() - 1; i >= 0; --i) {
            class_1799 stack = (class_1799)stacks.get(i);
            int original = stack.method_7947();
            double scaled = (double)original * factor;
            int base = (int)Math.floor(scaled);
            if (random.method_43058() < scaled - (double)base) {
                ++base;
            }
            if (base <= 0) {
                stacks.remove(i);
                continue;
            }
            stack.method_7939(base);
        }
    }

    public static double calculateDifficulty(class_3218 level, class_2338 pos, class_8934 container, int randomIterations, boolean debug, @Nullable class_2168 source) {
        if (debug) {
            source.method_45068((class_2561)class_2561.method_43470((String)"CALCULATING..."));
        }
        double value = 0.0;
        int totalIterations = 0;
        Random random = new Random(container.method_54870());
        class_5321 lootTableKey = container.method_54869();
        class_52 rawLootTable = LootUtils.getLootTableSafe(level, (class_5321<class_52>)lootTableKey);
        if (rawLootTable == null || lootTableKey == null) {
            return 0.0;
        }
        class_52 noMapsTable = LootUtils.stripTreasureMaps(rawLootTable);
        LootTableAccessor accessor = (LootTableAccessor)noMapsTable;
        Optional<class_2960> randomSequence = accessor.getRandomSequence();
        class_8567.class_8568 builder = new class_8567.class_8568(level).method_51874(class_181.field_24424, (Object)(pos == null ? class_243.field_1353 : class_243.method_24953((class_2382)pos)));
        Function<Long, class_47> makeCtx = seed -> new class_47.class_48(builder.method_51875(class_173.field_1179)).method_304(seed.longValue()).method_309(randomSequence);
        do {
            if (debug) {
                source.method_45068((class_2561)class_2561.method_43470((String)("Iteration: " + totalIterations)).method_27695(new class_124[]{class_124.field_1067, class_124.field_1078}));
            }
            long currentSeed = totalIterations > 0 ? random.nextLong() : container.method_54870();
            class_47 actualLootContext = makeCtx.apply(currentSeed);
            class_5819 randomSource = actualLootContext.method_294();
            ObjectArrayList<class_1799> actualItems = new ObjectArrayList<class_1799>();
            try {
                actualItems = LootUtils.buildMainItemList(accessor, makeCtx, actualLootContext, currentSeed, 1.0f, randomSource);
            }
            catch (NoSuchElementException e) {
                OctoLib.LOGGER.error("Failed to calculate lock difficulty: {}", (Object)e.getMessage());
            }
            actualItems.size(Math.min(actualItems.size(), container.method_5439()));
            double iterationValue = 0.0;
            for (class_1799 stack : actualItems) {
                if (stack == null) continue;
                double stackValue = ItemValues.getValue(stack);
                if (debug) {
                    source.method_45068((class_2561)class_2561.method_43470((String)"  ").method_10852((class_2561)stack.method_7954().method_27661().method_27693(" x" + stack.method_7947() + ": ").method_10852((class_2561)class_2561.method_43470((String)String.format("%.2f", stackValue)).method_27692(class_124.field_1065))));
                }
                iterationValue += stackValue;
            }
            if (debug) {
                source.method_45068((class_2561)class_2561.method_43470((String)("  Iteration " + totalIterations + " value: " + String.format("%.2f", iterationValue))));
            }
            value += iterationValue;
        } while (++totalIterations < randomIterations);
        if (debug) {
            source.method_45068((class_2561)class_2561.method_43470((String)("Finished iterating. Total value: " + String.format("%.3f", value))));
        }
        value /= (double)totalIterations;
        if (debug) {
            source.method_45068((class_2561)class_2561.method_43470((String)("Dividing by number of iterations (" + totalIterations + "): " + String.format("%.3f", value))));
        }
        double bottomOffset = Clavis.CONFIG.getItemValueRange().getMin();
        double topValue = Clavis.CONFIG.getItemValueRange().getMax() - bottomOffset;
        double unclampedDifficulty = value / topValue * Clavis.CONFIG.getGlobalDifficultyMultiplier() * Clavis.CONFIG.getLootTableMultiplier().getOrDefault(lootTableKey.method_29177().toString(), 1.0);
        return Math.clamp(unclampedDifficulty, (double)0.01f, Clavis.CONFIG.getUpperDifficultyClamp());
    }

    public static void unlockWithQuality(class_3218 level, class_3222 player, class_2338 blockPos, Lock lock, float quality) {
        long lootTableSeed;
        class_2621 randomizable;
        LockManager.unlock(level, player, lock);
        class_2586 class_25862 = level.method_8321(blockPos);
        if (!(class_25862 instanceof class_2621) || (randomizable = (class_2621)class_25862).method_54869() == null) {
            return;
        }
        class_5321 resourceKey = randomizable.method_54869();
        class_52 lootTable = LootUtils.getLootTableSafe(level, (class_5321<class_52>)resourceKey);
        if (lootTable == null) {
            OctoLib.LOGGER.warn("loot table not found for {}", (Object)resourceKey);
            return;
        }
        LootTableAccessor accessor = (LootTableAccessor)lootTable;
        class_174.field_24479.method_27993(player, resourceKey);
        class_8567.class_8568 baseBuilder = new class_8567.class_8568(level).method_51874(class_181.field_24424, (Object)class_243.method_24953((class_2382)blockPos));
        baseBuilder.method_51871(player.method_7292()).method_51874(class_181.field_1226, (Object)player);
        boolean isLootr = LootrCompat.COMPAT.isLootrBlockEntity((class_2586)randomizable);
        class_2621 container = isLootr ? LootrCompat.COMPAT.getEmptyInventory((class_2586)randomizable, player) : randomizable;
        long l = lootTableSeed = isLootr ? player.method_5667().getLeastSignificantBits() + randomizable.method_54870() : randomizable.method_54870();
        if (!isLootr) {
            randomizable.method_11285(null);
        }
        Function<Long, class_47> makeCtx = LootUtils.createLootContextFactory(baseBuilder, accessor);
        class_47 defaultContext = makeCtx.apply(lootTableSeed);
        class_5819 randomSource = defaultContext.method_294();
        ObjectArrayList<class_1799> mainList = new ObjectArrayList<class_1799>();
        try {
            mainList = LootUtils.buildMainItemList(accessor, makeCtx, defaultContext, lootTableSeed, quality, randomSource);
        }
        catch (NoSuchElementException e) {
            OctoLib.LOGGER.error("Failed to generate loot: {}", (Object)e.getMessage());
        }
        List<Integer> availableSlots = accessor.invokeGetAvailableSlots((class_1263)randomizable, randomSource);
        accessor.invokeShuffleAndSplitItems(mainList, availableSlots.size(), randomSource);
        if (container == null) {
            OctoLib.LOGGER.warn("container is null");
            return;
        }
        LootUtils.populateContainerFromList((class_1263)container, mainList, availableSlots);
        LootrCompat.COMPAT.performOpen((class_2586)randomizable, player);
    }

    private static class_52 getLootTableSafe(class_3218 level, class_5321<class_52> resourceKey) {
        try {
            return level.method_8503().method_58576().method_58295(resourceKey);
        }
        catch (Exception e) {
            OctoLib.LOGGER.warn("error loading loot table {}: {}", resourceKey, (Object)e.getMessage());
            return null;
        }
    }

    private static Function<Long, class_47> createLootContextFactory(class_8567.class_8568 baseBuilder, LootTableAccessor accessor) {
        return seedOffset -> new class_47.class_48(baseBuilder.method_51875(class_173.field_1179)).method_304(seedOffset.longValue()).method_309(accessor.getRandomSequence());
    }

    private static ObjectArrayList<class_1799> buildMainItemList(LootTableAccessor accessor, Function<Long, class_47> makeCtx, class_47 defaultContext, long lootTableSeed, float quality, class_5819 randomSource) {
        ObjectArrayList mainList = new ObjectArrayList();
        if (quality >= 1.0f) {
            int fullCopies = (int)quality;
            float fraction = quality - (float)fullCopies;
            for (int i = 0; i < fullCopies; ++i) {
                long seed = lootTableSeed + (long)i * 31571L;
                class_47 fullCtx = makeCtx.apply(seed);
                mainList.addAll(accessor.invokeGetRandomItems(fullCtx));
            }
            if (fraction > 0.0f) {
                long seed = lootTableSeed + 31571L * (long)fullCopies;
                class_47 fracCtx = makeCtx.apply(seed);
                ObjectArrayList<class_1799> fractionalItems = accessor.invokeGetRandomItems(fracCtx);
                LootUtils.shrinkStacks(fractionalItems, fraction, randomSource);
                mainList.addAll(fractionalItems);
            }
        } else {
            mainList.addAll(accessor.invokeGetRandomItems(defaultContext));
            LootUtils.shrinkStacks((ObjectArrayList<class_1799>)mainList, quality, randomSource);
        }
        ObjectArrayList aggregated = new ObjectArrayList();
        for (class_1799 stack : mainList) {
            if (stack.method_7960()) continue;
            boolean merged = false;
            for (class_1799 a : aggregated) {
                if (!class_1799.method_31577((class_1799)a, (class_1799)stack)) continue;
                a.method_7933(stack.method_7947());
                merged = true;
                break;
            }
            if (merged) continue;
            aggregated.add((Object)stack.method_7972());
        }
        ObjectArrayList finalList = new ObjectArrayList();
        for (class_1799 agg : aggregated) {
            int take;
            int max = agg.method_7914();
            for (int total = agg.method_7947(); total > 0; total -= take) {
                take = Math.min(total, max);
                class_1799 piece = agg.method_7972();
                piece.method_7939(take);
                finalList.add((Object)piece);
            }
        }
        return finalList;
    }

    private static void populateContainerFromList(class_1263 container, ObjectArrayList<class_1799> items, List<Integer> availableSlots) {
        for (class_1799 itemStack : items) {
            if (availableSlots.isEmpty()) {
                return;
            }
            int slotIndex = availableSlots.removeLast();
            if (itemStack.method_7960()) {
                container.method_5447(slotIndex, class_1799.field_8037);
                continue;
            }
            container.method_5447(slotIndex, itemStack);
        }
    }

    private static class_52 stripTreasureMaps(class_52 lootTable) {
        ArrayList<class_55> filteredPools = new ArrayList<class_55>();
        LootTableAccessor lootTableAccessor = (LootTableAccessor)lootTable;
        for (class_55 pool : ((LootTableAccessor)lootTable).getPools()) {
            class_55 lootPool;
            ArrayList<class_79> filteredEntries = new ArrayList<class_79>();
            LootPoolAccessor accessor = (LootPoolAccessor)pool;
            for (class_79 entry : accessor.getEntries()) {
                if (LootUtils.isTreasureMapEntry(entry)) continue;
                filteredEntries.add(entry);
            }
            if (Platform.isNeoForge()) {
                constructor = class_55.class.getDeclaredConstructor(List.class, List.class, List.class, class_5658.class, class_5658.class, Optional.class);
                constructor.setAccessible(true);
                lootPool = (class_55)constructor.newInstance(filteredEntries, accessor.getConditions(), accessor.getFunctions(), accessor.getRolls(), accessor.getBonusRolls(), Optional.empty());
            } else {
                constructor = class_55.class.getDeclaredConstructor(List.class, List.class, List.class, class_5658.class, class_5658.class);
                constructor.setAccessible(true);
                lootPool = (class_55)constructor.newInstance(filteredEntries, accessor.getConditions(), accessor.getFunctions(), accessor.getRolls(), accessor.getBonusRolls());
            }
            if (filteredEntries.isEmpty()) continue;
            filteredPools.add(lootPool);
        }
        Constructor constructor = class_52.class.getDeclaredConstructor(class_176.class, Optional.class, List.class, List.class);
        constructor.setAccessible(true);
        return (class_52)constructor.newInstance(lootTableAccessor.getParamSet(), lootTableAccessor.getRandomSequence(), filteredPools, lootTableAccessor.getFunctions());
    }

    private static boolean isTreasureMapEntry(class_79 entry) {
        if (entry instanceof class_77) {
            class_77 lootItem = (class_77)entry;
            LootPoolSingletonContainerAccessor containerAccessor = (LootPoolSingletonContainerAccessor)lootItem;
            return containerAccessor.getFunctions().stream().anyMatch(f -> f instanceof class_111);
        }
        return false;
    }

    public static int getColorForDifficulty(float difficulty) {
        return difficulty < 0.33f ? -13369566 : (difficulty < 0.66f ? -13312 : -65519);
    }
}

